/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.accessControl.AccessControlMode;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.ConfigurationTaskException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.management.ConfigAreaAndVersion;
import de.bsvrz.dav.daf.main.config.management.ConfigurationControl;
import de.bsvrz.dav.daf.main.config.management.consistenycheck.ConsistencyCheckResultInterface;
import de.bsvrz.puk.config.configFile.datamodel.ConfigDataModel;
import de.bsvrz.puk.config.main.managementfile.ManagementFile;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.testumg.util.DaVStarter;
import de.kappich.pat.testumg.util.FileCopy;
import de.kappich.pat.testumg.util.TempDirectoryCreator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigurationController {
    private static final Pattern AREA_AND_VERSION_PATTERN = Pattern.compile("^(.*):([0-9]+)$");
    private final Class _testClass;
    private final File _pathBase;
    private final File _adminFile;
    private File _importPath;
    private File _exportPath;
    private DataModel _dataModel;
    private DaVStarter _davStarter;

    public ConfigurationController(File adminFile) {
        this._testClass = null;
        this._pathBase = null;
        this._adminFile = adminFile;
    }

    public ConfigurationController(String className) {
        this(className, null);
    }

    public ConfigurationController(String className, File baseDirectory) {
        try {
            this._testClass = Class.forName(className);
            this._pathBase = baseDirectory == null ? new File(TempDirectoryCreator.createTemporaryDirectory().toFile(), this._testClass.getSimpleName()).getAbsoluteFile() : baseDirectory;
            if (this._pathBase.exists()) {
                FileCopy.deleteDirectoryOrFile(this._pathBase);
            }
            File configurationPath = new File(this._pathBase, "konfiguration").getCanonicalFile();
            FileCopy.copyTestConfigurationAreaFiles(configurationPath);
            this._adminFile = new File(configurationPath, "verwaltungsdaten.xml");
            this.setImportPath(new File(this._pathBase, "import"));
            this.setExportPath(new File(this._pathBase, "export"));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void closeAndDeleteConfiguration() {
        this.closeConfiguration();
        if (this._pathBase == null) {
            throw new IllegalStateException("Das Stammverzeichnis der Konfiguration wurde nicht im Konstruktor gesetzt und kann deshalb nicht gel\u00f6scht werden.");
        }
        System.out.println("Verzeichnis " + this._pathBase.getName() + " wird gel\u00f6scht.");
        FileCopy.deleteDirectoryOrFile(this._pathBase);
    }

    public void startConfiguration(String authorityPid) throws IOException {
        ManagementFile managementFile = new ManagementFile(this._adminFile);
        managementFile.setConfigurationAuthority(authorityPid);
        managementFile.close();
        System.out.println("Konfiguration wird mit " + authorityPid + " gestartet.");
        this.loadConfiguration();
    }

    public void startConfigurationWithTestAuthority() throws IOException {
        this.startConfiguration("kv.testKonfiguration");
    }

    public DataModel getDataModel() {
        return this._dataModel;
    }

    private DataModel loadConfiguration() {
        System.out.println("Konfiguration wird gestartet");
        this._dataModel = new ConfigDataModel(this._adminFile);
        return this._dataModel;
    }

    public DataModel reloadConfiguration() {
        this.closeConfiguration();
        return this.loadConfiguration();
    }

    public void reloadConfiguration(String authorityPid) throws IOException {
        this.closeConfiguration();
        this.startConfiguration(authorityPid);
    }

    public void closeConfiguration() {
        System.out.println("Konfiguration wird beendet.");
        if (this._dataModel != null) {
            ((ConfigDataModel)this._dataModel).close();
            this._dataModel = null;
        }
    }

    public ConsistencyCheckResultInterface activateConfigurationArea(String pid) throws ConfigurationChangeException {
        LinkedList<String> pids = new LinkedList<String>();
        pids.add(pid);
        return this.activateConfigurationAreas(pids);
    }

    public ConsistencyCheckResultInterface activateConfigurationAreas(Collection<String> pids) throws ConfigurationChangeException {
        System.out.println("Bereiche werden aktiviert");
        ArrayList<ConfigAreaAndVersion> configurationAreas = new ArrayList<ConfigAreaAndVersion>();
        for (String pid : pids) {
            ConfigurationArea configArea = (ConfigurationArea)((ConfigurationControl)this.getDataModel()).getAllConfigurationAreas().get(pid);
            configurationAreas.add(new ConfigAreaAndVersion(configArea, 0));
        }
        return ((ConfigurationControl)this.getDataModel()).activateConfigurationAreas(configurationAreas);
    }

    public ConsistencyCheckResultInterface activate(String ... pids) throws ConfigurationChangeException {
        return this.activateConfigurationAreas(Arrays.asList(pids));
    }

    public ConsistencyCheckResultInterface releaseConfigurationAreaForActivationWithoutCAActivation(String pid) throws ConfigurationChangeException {
        System.out.println("Bereich wird aktiviert, ohne das dieser vorher durch den KV lokal aktiviert wurde");
        ArrayList<ConfigAreaAndVersion> configurationAreas = new ArrayList<ConfigAreaAndVersion>();
        ConfigurationArea area = this.getDataModel().getConfigurationArea(pid);
        configurationAreas.add(new ConfigAreaAndVersion(area));
        return ((ConfigurationControl)this.getDataModel()).releaseConfigurationAreasForActivationWithoutCAActivation(configurationAreas);
    }

    public void releaseConfigurationAreaForActivation(String pid) throws ConfigurationChangeException {
        ArrayList<String> pids = new ArrayList<String>();
        pids.add(pid);
        this.releaseConfigurationAreasForActivation(pids);
    }

    public void releaseConfigurationAreasForActivation(Collection<String> pids) throws ConfigurationChangeException {
        System.out.println("Bereich(e) f\u00fcr andere zur Aktivierung freigeben");
        ArrayList<ConfigAreaAndVersion> configurationAreas = new ArrayList<ConfigAreaAndVersion>();
        for (String pid : pids) {
            ConfigurationArea area = this.getDataModel().getConfigurationArea(pid);
            configurationAreas.add(new ConfigAreaAndVersion(area));
        }
        ((ConfigurationControl)this.getDataModel()).releaseConfigurationAreasForActivation(configurationAreas);
    }

    public void releaseConfigurationAreaForTransfer(String pid) throws ConfigurationChangeException {
        ArrayList<String> helper = new ArrayList<String>();
        helper.add(pid);
        this.releaseConfigurationAreasForTransfer(helper);
    }

    public void releaseConfigurationAreasForTransfer(Collection<String> pids) throws ConfigurationChangeException {
        ArrayList<ConfigAreaAndVersion> configurationAreas = new ArrayList<ConfigAreaAndVersion>();
        for (String pid : pids) {
            ConfigurationArea area = this.getDataModel().getConfigurationArea(pid);
            configurationAreas.add(new ConfigAreaAndVersion(area));
        }
        ((ConfigurationControl)this.getDataModel()).releaseConfigurationAreasForTransfer(configurationAreas);
    }

    public void importConfigurationAreas(Collection<String> pids) throws ConfigurationChangeException {
        this.importConfigurationAreas(this.getImportPath(), pids);
    }

    public void importConfigurationAreas(File importPath, Collection<String> pids) throws ConfigurationChangeException {
        ((ConfigurationControl)this.getDataModel()).importConfigurationAreas(importPath, pids);
    }

    public void importConfigurationArea(String areaPid) throws ConfigurationChangeException {
        ArrayList<String> pids = new ArrayList<String>();
        pids.add(areaPid);
        this.importConfigurationAreas(this.getImportPath(), pids);
    }

    @NotNull
    public List<String> importConfigurationAreasWithVersion(Collection<String> pidsWithVersion) throws ConfigurationChangeException {
        ArrayList<String> pids = new ArrayList<String>();
        for (String pid : pidsWithVersion) {
            int version = -1;
            Matcher matcher = AREA_AND_VERSION_PATTERN.matcher(pid);
            if (matcher.matches()) {
                version = Integer.parseInt(matcher.group(2));
                pid = matcher.group(1);
            }
            this.copyImportFile(pid, version);
            pids.add(pid);
        }
        this.importConfigurationAreas(pids);
        return pids;
    }

    public synchronized DaVStarter getDaVStarter() {
        this.closeConfiguration();
        if (this._davStarter == null) {
            this._davStarter = new DaVStarter(this.getConfigurationPath(), true);
        }
        return this._davStarter;
    }

    public synchronized DaVStarter getDaVStarter(String _configurationDebugLevel, String _transmitterDebugLevel, String _paramDebugLevel) {
        this.closeConfiguration();
        if (this._davStarter == null) {
            this._davStarter = new DaVStarter(this.getConfigurationPath(), true, _configurationDebugLevel, _transmitterDebugLevel, _paramDebugLevel);
        }
        return this._davStarter;
    }

    public synchronized DaVStarter getDaVStarter(String configurationDebugLevel, String transmitterDebugLevel, String paramDebugLevel, int appPort, int davPort, long davId, @Nullable String remoteConf, AccessControlMode accessControlType, String ... accessControlPlugIns) {
        this.closeConfiguration();
        if (this._davStarter == null) {
            this._davStarter = new DaVStarter(this.getConfigurationPath(), new File(this.getConfigurationPath(), "benutzerverwaltung.xml"), true, appPort, davPort, davId, remoteConf, configurationDebugLevel, transmitterDebugLevel, paramDebugLevel, accessControlType, accessControlPlugIns);
        }
        return this._davStarter;
    }

    public void importConfigurationArea(File importPath, String areaPid) throws ConfigurationChangeException {
        ArrayList<String> pids = new ArrayList<String>();
        pids.add(areaPid);
        this.importConfigurationAreas(importPath, pids);
    }

    public void exportConfigurationAreas(Collection<String> pids) throws ConfigurationTaskException {
        ((ConfigurationControl)this.getDataModel()).exportConfigurationAreas(this.getExportPath(), pids);
    }

    public void exportConfigurationAreas(File exportPath, Collection<String> pids) throws ConfigurationTaskException {
        ((ConfigurationControl)this.getDataModel()).exportConfigurationAreas(exportPath, pids);
    }

    public void exportConfigurationArea(String areaPid) throws ConfigurationTaskException {
        ArrayList<String> pids = new ArrayList<String>();
        pids.add(areaPid);
        this.exportConfigurationAreas(this.getExportPath(), pids);
    }

    public void exportConfigurationArea(File exportPath, String areaPid) throws ConfigurationTaskException {
        ArrayList<String> pids = new ArrayList<String>();
        pids.add(areaPid);
        this.exportConfigurationAreas(exportPath, pids);
    }

    public ConsistencyCheckResultInterface checkConsistency(Collection<String> pids) {
        ConfigurationControl control = (ConfigurationControl)this.getDataModel();
        ArrayList<ConfigAreaAndVersion> areas = new ArrayList<ConfigAreaAndVersion>();
        for (String pid : pids) {
            ConfigurationArea area = (ConfigurationArea)control.getAllConfigurationAreas().get(pid);
            short version = area.getModifiableVersion();
            areas.add(new ConfigAreaAndVersion(area, version));
        }
        return control.checkConsistency(areas);
    }

    public void importVariant(int variant, String ... pids) throws ConfigurationChangeException {
        this.copyVariant(variant, pids);
        this.importConfigurationAreas(this.getImportPath(), Arrays.asList(pids));
    }

    public DataModel importActivateAndReloadVariant(int variant, String ... pids) throws ConfigurationChangeException {
        this.importVariant(variant, pids);
        return this.activateAndReload(pids);
    }

    public DataModel activateAndReload(String ... pids) throws ConfigurationChangeException {
        ConsistencyCheckResultInterface consistencyCheckResult = this.activate(pids);
        if (!consistencyCheckResult.getLocalErrors().isEmpty()) {
            throw new ConfigurationChangeException("Lokale Fehler bei der Konsistenzpr\u00fcfung");
        }
        if (!consistencyCheckResult.getInterferenceErrors().isEmpty()) {
            throw new ConfigurationChangeException("Interferenzfehler bei der Konsistenzpr\u00fcfung");
        }
        this.reloadConfiguration();
        return this.getDataModel();
    }

    public DataModel importAndActivateAreas(Collection<String> pids) throws ConfigurationChangeException {
        this.copyImportFiles(pids);
        this.importConfigurationAreas(pids);
        this.activateConfigurationAreas(pids);
        this.reloadConfiguration();
        return this.getDataModel();
    }

    public DataModel importAndActivateArea(String pid) throws ConfigurationChangeException {
        ArrayList<String> pidList = new ArrayList<String>();
        pidList.add(pid);
        return this.importAndActivateAreas(pidList);
    }

    public File getPathBase() {
        return this._pathBase;
    }

    public File getAdminFile() {
        return this._adminFile;
    }

    public File getConfigurationPath() {
        return this._adminFile.getParentFile();
    }

    public File getImportPath() {
        return this._importPath;
    }

    public void setImportPath(File importPath) {
        try {
            this._importPath = importPath.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (!this._importPath.exists()) {
            this._importPath.mkdirs();
        }
        if (!this._importPath.isDirectory()) {
            throw new IllegalArgumentException("Das angegebene Objekt ist kein Verzeichnis.");
        }
    }

    public File getExportPath() {
        return this._exportPath;
    }

    public void setExportPath(File exportPath) {
        try {
            this._exportPath = exportPath.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        if (!this._exportPath.exists()) {
            this._exportPath.mkdirs();
        }
        if (!this._exportPath.isDirectory()) {
            throw new IllegalArgumentException("Das angegebene Objekt ist kein Verzeichnis.");
        }
    }

    public void copyImportFile(String pid) {
        try {
            String sourceName = pid + ".xml";
            URL resource = this._testClass.getResource(sourceName);
            if (resource == null || this._importPath == null) {
                throw new IllegalStateException("Kopieren der Datei " + sourceName + ": Import-Verzeichnis (" + String.valueOf(this._importPath) + ") oder Versorgungsdatei (" + String.valueOf(resource) + ") nicht vorhanden.");
            }
            File targetFile = new File(this._importPath, sourceName);
            FileCopy.copyFile(resource.openStream(), targetFile, true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Die Versorgungsdatei konnte nicht kopiert werden", ex);
        }
    }

    public void createConfigurationFile(String pid, String content) {
        this.createConfigurationFile(pid, new ByteArrayInputStream(content.getBytes(Charset.forName("ISO-8859-1"))));
    }

    public void createConfigurationFile(String pid, ByteArrayInputStream inputStream) {
        try {
            String fileName = pid + ".xml";
            File targetFile = new File(this._importPath, fileName);
            FileCopy.copyFile(inputStream, targetFile, true);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Die Versorgungsdatei konnte nicht erstellt werden", ex);
        }
    }

    public void copyImportFile(String pid, int version) {
        try {
            String sourceName = version >= 0 ? pid + version + ".xml" : pid + ".xml";
            URL resource = this._testClass.getResource(sourceName);
            if (resource != null) {
                File targetFile = new File(this.getImportPath(), pid + ".xml");
                FileCopy.copyFile(resource.openStream(), targetFile, true);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Die Versorgungsdatei konnte nicht kopiert werden.", e);
        }
    }

    public void copyImportFiles(Collection<String> pids, int version) {
        for (String pid : pids) {
            this.copyImportFile(pid, version);
        }
    }

    public void copyVariant(int variant, String ... pids) {
        for (String pid : pids) {
            this.copyImportFile(pid, variant);
        }
    }

    public void copyImportFiles(Collection<String> pids) {
        for (String pid : pids) {
            this.copyImportFile(pid);
        }
    }
}

