/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.main.ApplicationCloseActionHandler;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.NormalCloser;
import de.bsvrz.dav.daf.main.authentication.ClientCredentials;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.testumg.util.DaVStarter;

public class CreateClientDavConnection {
    private final int _maxWaitCycles = 20;
    private ClientDavInterface _connection;

    @Deprecated
    public CreateClientDavConnection(String applicationName) {
        this("Tester", "geheim", applicationName);
    }

    @Deprecated
    public CreateClientDavConnection() {
        this(null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, String password) {
        this(user, password, null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, String password, String applicationName) {
        this(user, password, applicationName, null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, ClientCredentials clientCredentials) {
        this(user, clientCredentials, null);
    }

    @Deprecated
    public CreateClientDavConnection(String user, ClientCredentials clientCredentials, String applicationName) {
        this(user, clientCredentials, applicationName, null);
    }

    public CreateClientDavConnection(String user, String password, String applicationName, ClientDavParameters clientDavParameters) {
        this(user, ClientCredentials.ofString((String)password), applicationName, clientDavParameters);
    }

    public CreateClientDavConnection(String user, ClientCredentials clientCredentials, String applicationName, ClientDavParameters clientDavParameters) {
        this(user, clientCredentials, applicationName, clientDavParameters, null, 0);
    }

    public CreateClientDavConnection(String user, ClientCredentials clientCredentials, @Nullable String applicationName, @Nullable ClientDavParameters clientDavParameters, String davHostname, int davTcpPort) {
        try {
            clientDavParameters = clientDavParameters == null ? new ClientDavParameters() : clientDavParameters.clone();
            if (clientDavParameters.getDavCommunicationSubAddress() == 8083) {
                clientDavParameters.setDavCommunicationSubAddress(8083 + DaVStarter.getDavPortNumberOffset());
            }
            if (davHostname != null) {
                clientDavParameters.setDavCommunicationAddress(davHostname);
            }
            if (davTcpPort != 0) {
                clientDavParameters.setDavCommunicationSubAddress(davTcpPort);
            }
            if (applicationName != null) {
                clientDavParameters.setApplicationName(applicationName);
            }
            this._connection = new ClientDavConnection(clientDavParameters);
            this._connection.setCloseHandler((ApplicationCloseActionHandler)new NormalCloser());
            this._connection.connect();
            this._connection.login(user, clientCredentials);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex);
        }
    }

    @Deprecated
    public static ClientDavInterface createConnection(String applicationName) {
        return new CreateClientDavConnection(applicationName).getConnection();
    }

    public synchronized ClientDavInterface getConnection() {
        for (int nr = 0; nr < 20; ++nr) {
            if (this._connection != null) {
                return this._connection;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Verbindung konnte nicht aufgebaut werden");
    }

    private class NormalCloserForTest
    implements ApplicationCloseActionHandler {
        private final String _applicationName;

        public NormalCloserForTest(String applicationName) {
            this._applicationName = applicationName;
        }

        public final void close(String error) {
            if (System.out != null) {
                System.out.println("Der CloseHandler wird f\u00fcr folgende Applikation gestartet: " + this._applicationName);
                Thread.dumpStack();
                System.out.flush();
            }
        }
    }
}

