/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import com.google.common.collect.ImmutableList;
import de.bsvrz.dav.daf.accessControl.AccessControlMode;
import de.bsvrz.dav.daf.communication.lowLevel.ServerConnectionInterface;
import de.bsvrz.dav.daf.main.ApplicationCloseActionHandler;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.NormalCloser;
import de.bsvrz.dav.daf.main.authentication.ClientCredentials;
import de.bsvrz.dav.dav.main.Transmitter;
import de.kappich.pat.testumg.util.CreateClientDavConnection;
import de.kappich.pat.testumg.util.FakeParamApp;
import de.kappich.pat.testumg.util.FileCopy;
import de.kappich.pat.testumg.util.ParamAppType;
import de.kappich.pat.testumg.util.ReleaseVersion;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;

public class DaVStarter {
    public static final String DEFAULT_CONFIGURATION_DEBUG = "WARNING";
    public static final String DEFAULT_TRANSMITTER_DEBUG = "WARNING";
    public static final String DEFAULT_PARAM_DEBUG = "WARNING";
    private final File _userFile;
    private final int _davAppPort;
    private final int _davDavPort;
    private final long _davID;
    private final String _remoteConfiguration;
    private final String _configurationDebugLevel;
    private final String _transmitterDebugLevel;
    private final String _paramDebugLevel;
    private final AccessControlMode _accessControlType;
    private final String[] _accessControlPlugIns;
    private final File _passwd;
    private final File _configurationManagementFile;
    private final File _paramDirectory;
    private final File _workingDirectory;
    private ReleaseVersion _releaseVersion = ReleaseVersion.Current;
    private Process _transmitter;
    private Process _configuration;
    private Process _param;
    private Process _operatingMessageManagement;
    private String _name = "";
    private int _davDavConnectDelay;
    private int _davDavReconnectDelay = 1000;
    private Class<? extends ServerConnectionInterface> _protocolClass;
    private String[] _additionalTransmitterArgs = new String[0];
    private Transmitter _transmitterObject;
    private String _debugName = "Datenverteiler";
    private volatile FakeParamApp _fakeParamApp = new FakeParamApp();
    private String[] _classPathOverride;
    private Object _protocolParameter;
    private String _userNameParam;
    private String _userNameConfiguration;
    private String _userNameTransmitter;
    private int _passivePort;
    private ImmutableList<Integer> _activePorts = ImmutableList.of();

    public DaVStarter(File workingDirectory, File userFile) {
        this(workingDirectory, userFile, false, 8083 + DaVStarter.getDavPortNumberOffset(), -1, 10001L, null);
    }

    public DaVStarter(File workingDirectory) {
        this(workingDirectory, false);
    }

    public DaVStarter(File workingDirectory, boolean containsDaVFiles) {
        this(workingDirectory, new File(workingDirectory, "benutzerverwaltung.xml"), containsDaVFiles, 8083 + DaVStarter.getDavPortNumberOffset(), -1, 10001L, null);
    }

    public DaVStarter(File workingDirectory, boolean containsDaVFiles, String configurationDebugLevel, String transmitterDebugLevel, String paramDebugLevel) {
        this(workingDirectory, new File(workingDirectory, "benutzerverwaltung.xml"), containsDaVFiles, 8083 + DaVStarter.getDavPortNumberOffset(), -1, 10001L, null, configurationDebugLevel, transmitterDebugLevel, paramDebugLevel, AccessControlMode.Disabled, new String[0]);
    }

    public DaVStarter(File workingDirectory, boolean containsDaVFiles, String configurationDebugLevel, String transmitterDebugLevel, String paramDebugLevel, AccessControlMode accessControlType, String[] accessControlPlugIns) {
        this(workingDirectory, new File(workingDirectory, "benutzerverwaltung.xml"), containsDaVFiles, 8083 + DaVStarter.getDavPortNumberOffset(), -1, 10001L, null, configurationDebugLevel, transmitterDebugLevel, paramDebugLevel, accessControlType, accessControlPlugIns);
    }

    public DaVStarter(File workingDirectory, int davAppPort, long davId, String remoteConfiguration) {
        this(workingDirectory, new File(workingDirectory, "benutzerverwaltung.xml"), true, davAppPort, -1, davId, remoteConfiguration);
    }

    public DaVStarter(File workingDirectory, int davAppPort, int davDavPort, long davId, String remoteConfiguration) {
        this(workingDirectory, new File(workingDirectory, "benutzerverwaltung.xml"), true, davAppPort, davDavPort, davId, remoteConfiguration);
    }

    public DaVStarter(File workingDirectory, File userFile, boolean containsDaVFiles, int davAppPort, int davDavPort, long davId, String remoteConfiguration) {
        this(workingDirectory, userFile, containsDaVFiles, davAppPort, davDavPort, davId, remoteConfiguration, "WARNING", "WARNING", "WARNING", AccessControlMode.Disabled, new String[0]);
    }

    public DaVStarter(File workingDirectory, File userFile, boolean containsDaVFiles, int davAppPort, int davDavPort, long davId, String remoteConfiguration, String configurationDebugLevel, String transmitterDebugLevel, String paramDebugLevel, AccessControlMode accessControlType, String[] accessControlPlugIns) {
        this.addRuntimeExitHandler();
        this._davAppPort = davAppPort;
        this._davDavPort = davDavPort;
        this._davID = davId;
        this._remoteConfiguration = remoteConfiguration;
        this._configurationDebugLevel = configurationDebugLevel;
        this._transmitterDebugLevel = transmitterDebugLevel;
        this._paramDebugLevel = paramDebugLevel;
        this._accessControlType = accessControlType;
        this._accessControlPlugIns = accessControlPlugIns;
        try {
            this.testPort();
            if (!workingDirectory.exists() && !containsDaVFiles) {
                workingDirectory.mkdirs();
            }
            this._workingDirectory = workingDirectory;
            if (!containsDaVFiles) {
                FileCopy.copyTestConfigurationAreaFiles(this._workingDirectory);
            }
            this._userNameTransmitter = "Tester";
            this._userNameParam = "parameter";
            this._passwd = new File(this._workingDirectory, "passwd.properties");
            this._paramDirectory = new File(this._workingDirectory, "Parametrierung");
            this._paramDirectory.mkdir();
            this._configurationManagementFile = new File(this._workingDirectory, "verwaltungsdaten.xml");
            this._userNameConfiguration = "configuration";
            this._userFile = userFile;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Der Datenverteiler konnte nicht gestartet werden", ex);
        }
    }

    public static int getDavPortNumberOffset() {
        String defaultOffset = System.getProperty("agent.name") == null ? "10000" : "20000";
        return Integer.parseInt(System.getProperty("de.kappich.dav.testTcpPortNumberOffset", defaultOffset));
    }

    public static String join(String[] s, String delimiter) {
        if (s.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(s[0]);
        int i = 1;
        while (i < s.length) {
            buffer.append(delimiter).append(s[i]);
        }
        return buffer.toString();
    }

    private static String[] createDefaultCommandArray(String className, int xmxSize) {
        return DaVStarter.createDefaultCommandArray(className, xmxSize, null);
    }

    public static String[] createDefaultCommandArray(String className, int xmxSize, String[] classPathOverride) {
        String classPath;
        String fileSeparator = System.getProperty("file.separator");
        String javaHome = System.getProperty("java.home");
        if (classPathOverride == null || classPathOverride.length == 0) {
            classPath = System.getProperty("java.class.path");
        } else {
            String delim = System.getProperty("path.separator");
            StringBuilder stringBuilder = new StringBuilder(classPathOverride[0]);
            for (int i = 1; i < classPathOverride.length; ++i) {
                String s = classPathOverride[i];
                stringBuilder.append(delim);
                stringBuilder.append(s);
            }
            stringBuilder.append(delim).append(System.getProperty("java.class.path"));
            classPath = stringBuilder.toString();
        }
        LinkedList<Object> commandList = new LinkedList<Object>();
        commandList.add(javaHome + fileSeparator + "bin" + fileSeparator + "java");
        commandList.add("-Dfile.encoding=ISO-8859-1");
        commandList.add("-Xmx" + xmxSize + "m");
        commandList.add("-cp");
        commandList.add(classPath);
        commandList.add(className);
        return commandList.toArray(new String[0]);
    }

    public static String[] mergeArrays(String[] array1, String[] array2) {
        ArrayList mergedList = new ArrayList();
        Collections.addAll(mergedList, array1);
        Collections.addAll(mergedList, array2);
        return mergedList.toArray(new String[0]);
    }

    private static void waitForProcessExit(String name, final Process process, int timeout) {
        long start = System.currentTimeMillis();
        try {
            final Thread mainThread = Thread.currentThread();
            Timer timer = new Timer("Prozess " + name + " beenden - Timeout");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    mainThread.interrupt();
                    process.destroy();
                }
            }, timeout);
            process.waitFor();
            timer.cancel();
            long delay = System.currentTimeMillis() - start;
            System.out.println(name + " in " + delay + "ms beendet");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(name + " hat sich nicht rechtzeitig in " + timeout + "ms beendet");
        }
    }

    public static Process createProcess(String[] commandArray, String outputPrefix, String errorOutputPrefix, File workingDirectory) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(commandArray);
        processBuilder.directory(workingDirectory);
        Process process = processBuilder.start();
        InputStreamReader inputStreamReaderError = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
        InputStreamReader inputStreamReaderInput = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
        Thread threadError = new Thread(new OutputThread(inputStreamReaderError, errorOutputPrefix));
        Thread threadInput = new Thread(new OutputThread(inputStreamReaderInput, outputPrefix));
        threadError.setDaemon(true);
        threadError.setName("ErrorOutput");
        threadInput.setDaemon(true);
        threadInput.setName("InputOutput");
        threadError.start();
        threadInput.start();
        return process;
    }

    public void setDavDavConnectDelay(int davDavConnectDelay) {
        this._davDavConnectDelay = davDavConnectDelay;
    }

    public void setDavDavReconnectDelay(int davDavReconnectDelay) {
        this._davDavReconnectDelay = davDavReconnectDelay;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDebugName() {
        return this._debugName;
    }

    public void setDebugName(String debugName) {
        this._debugName = debugName;
    }

    public ClientDavInterface getConnection() {
        return new CreateClientDavConnection("Tester", ClientCredentials.ofString((String)"geheim"), null, null, "localhost", this._davAppPort).getConnection();
    }

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    private void testPort() {
        boolean printed = false;
        for (int i = 0; i < 10; ++i) {
            try (Socket ignored = new Socket(InetAddress.getLocalHost(), this._davAppPort);){
                if (!printed) {
                    System.out.print("Pr\u00fcfe freien Port");
                    printed = true;
                }
                System.out.print(".");
                System.out.flush();
                continue;
            }
            catch (IOException ignore) {
                return;
            }
        }
        throw new IllegalStateException("Der Datenverteiler konnte nicht gestartet werden: Es l\u00e4uft bereits eine Applikation auf Port " + this._davAppPort);
    }

    private void addRuntimeExitHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (DaVStarter.this._transmitter != null) {
                    try {
                        DaVStarter.this._transmitter.exitValue();
                        return;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        System.err.println("Datenverteiler wurde von den Tests nicht korrekt beendet.");
                        System.err.println("Der Prozess wird daher jetzt get\u00f6tet.");
                        DaVStarter.this.stopDavWithoutFileDeletion();
                    }
                }
            }
        });
    }

    public int getDavAppPort() {
        return this._davAppPort;
    }

    private String[] createConfigCommandArray(File configurationManagementFile, File userFile, String userNameConfiguration, File passwordFileConfiguration, int xmxSize) {
        String[] defaultConfiguration = new String[]{"-datenverteiler=localhost:" + this._davAppPort, "-verwaltung=" + configurationManagementFile.getAbsolutePath(), "-benutzerverwaltung=" + userFile.getAbsolutePath(), "-benutzer=" + userNameConfiguration, "-authentifizierung=" + passwordFileConfiguration.getAbsolutePath(), "-debugLevelStdErrText=" + this._configurationDebugLevel, "-debugLevelFileText=INFO", "-debugFilePath=" + String.valueOf(this._workingDirectory)};
        String[] defaultJavaCommandArray = DaVStarter.createDefaultCommandArray(this._releaseVersion.getConfigurationClass(), xmxSize, this._classPathOverride);
        return DaVStarter.mergeArrays(defaultJavaCommandArray, defaultConfiguration);
    }

    private String[] createParamCommandArray(String usernameParam, File passwordFile, File paramDirectory, int xmxSize) {
        String[] defaultParam = new String[]{"-datenverteiler=localhost:" + this._davAppPort, "-benutzer=" + usernameParam, "-authentifizierung=" + passwordFile.getAbsolutePath(), "-parameterVerzeichnis=" + paramDirectory.getAbsolutePath(), "-sleep=9000", "-debugLevelStdErrText=" + this._paramDebugLevel, "-debugLevelFileText=INFO", "-debugFilePath=" + String.valueOf(this._workingDirectory)};
        String[] defaultJavaCommandArray = DaVStarter.createDefaultCommandArray(this._releaseVersion.getParamClass(), xmxSize, this._classPathOverride);
        return DaVStarter.mergeArrays(defaultJavaCommandArray, defaultParam);
    }

    private String[] createTransmitterCommandArray(int xmxSize, boolean waitForParamApp) {
        String[] defaultTransmitter = this.createTransmitterArgs(waitForParamApp);
        String[] defaultJavaCommandArray = DaVStarter.createDefaultCommandArray(this._releaseVersion.getTransmitterClass(), xmxSize, this._classPathOverride);
        return DaVStarter.mergeArrays(defaultJavaCommandArray, defaultTransmitter);
    }

    private String[] createTransmitterArgs() {
        return this.createTransmitterArgs(false);
    }

    private String[] createTransmitterArgs(boolean waitForParamApp) {
        File passwd = new File(this._workingDirectory, "passwd.properties");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("-benutzer=" + this._userNameTransmitter, "-konfigurationsBenutzer=" + this._userNameConfiguration, "-parametrierungsBenutzer=" + this._userNameParam, "-authentifizierung=" + passwd.getAbsolutePath(), "-davAppPort=" + this._davAppPort, "-datenverteilerId=" + this._davID, "-debugLevelStdErrText=" + this._transmitterDebugLevel, "-debugLevelFileText=INFO", "-debugFilePath=" + String.valueOf(this._workingDirectory)));
        if (this._releaseVersion.min(ReleaseVersion.V3_5_5)) {
            list.add("-warteAufParametrierung=" + (waitForParamApp ? "ja" : "nein"));
        }
        if (this._releaseVersion.min(ReleaseVersion.V3_6_5)) {
            list.add("-debugName=" + this._debugName);
        }
        if (this._remoteConfiguration != null) {
            list.add("-remoteKonfiguration=" + this._remoteConfiguration);
        }
        switch (this._accessControlType) {
            case Disabled: {
                list.add("-rechtePruefung=nein");
                break;
            }
            case OldDataModel: {
                list.add("-rechtePruefung=alt");
                break;
            }
            case NewDataModel: {
                list.add("-rechtePruefung=neu");
            }
        }
        if (this._accessControlPlugIns.length > 0) {
            list.add("-zugriffsRechtePlugins=" + DaVStarter.join(this._accessControlPlugIns, ","));
        }
        if (this._davDavPort != -1) {
            list.add("-davDavPort=" + this._davDavPort);
        } else {
            list.add("-davDavPortOffset=" + DaVStarter.getDavPortNumberOffset());
        }
        if (this._passivePort > 0) {
            list.add("-passiv=" + this._passivePort);
        }
        if (!this._activePorts.isEmpty()) {
            list.add("-aktiv=" + this._activePorts.stream().map(it -> "127.0.0.1:" + it).collect(Collectors.joining(",")));
        }
        if (this._protocolClass != null && this._releaseVersion.min(ReleaseVersion.V3_6_5)) {
            list.add("-tcpKommunikationsModul=" + this._protocolClass.getName() + (String)(this._protocolParameter == null ? "" : ":" + String.valueOf(this._protocolParameter)));
        }
        list.add("-verzoegerungFuerAndereDatenverteiler=" + this._davDavConnectDelay + "ms");
        if (this._releaseVersion.min(ReleaseVersion.V3_6_5)) {
            list.add("-wiederverbindungsWartezeit=" + this._davDavReconnectDelay + "ms");
        }
        list.addAll(Arrays.asList(this._additionalTransmitterArgs));
        return list.toArray(new String[0]);
    }

    public Class<? extends ServerConnectionInterface> getProtocolClass() {
        return this._protocolClass;
    }

    public void setProtocolClass(Class<? extends ServerConnectionInterface> protocolClass) {
        this._protocolClass = protocolClass;
    }

    public Object getProtocolParameter() {
        return this._protocolParameter;
    }

    public void setProtocolParameter(Object protocolParameter) {
        this._protocolParameter = protocolParameter;
    }

    public Process getTransmitter() {
        return this._transmitter;
    }

    public Process getConfiguration() {
        return this._configuration;
    }

    public Process getOperatingMessageManagement() {
        return this._operatingMessageManagement;
    }

    public synchronized void startDaV(ParamAppType paramAppType) throws IOException {
        this.stopDavWithoutFileDeletion();
        this.startTransmitter();
        this.startConfiguration();
        this.startParam(paramAppType);
    }

    public synchronized void startParam(ParamAppType paramAppType) throws IOException {
        switch (paramAppType) {
            case NoParamApp: {
                break;
            }
            case DefaultParamApp: {
                this.startDefaultParam();
                break;
            }
            case FakeParamApp: {
                try {
                    Thread.sleep(3000L);
                    this._fakeParamApp.connect(this);
                    break;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }

    public synchronized void startDaV() throws IOException {
        this.startDaV(ParamAppType.DefaultParamApp);
    }

    public synchronized void startDaVWithDummyParam() throws IOException {
        this.startDaV(ParamAppType.FakeParamApp);
    }

    public synchronized void startDaVWithoutParam() throws IOException {
        this.startDaV(ParamAppType.NoParamApp);
    }

    public synchronized void startTransmitterInSameProcess(boolean withConfiguration, ParamAppType paramAppType) throws Exception {
        this.startTransmitterInSameProcess(withConfiguration, paramAppType, paramAppType != ParamAppType.NoParamApp);
    }

    public synchronized void startTransmitterInSameProcess(boolean withConfiguration, ParamAppType paramAppType, boolean waitForParamApp) throws Exception {
        this.stopDavWithoutFileDeletion();
        TransmitterThread helper = new TransmitterThread(waitForParamApp);
        Thread transmitterThread = new Thread(helper);
        transmitterThread.start();
        Thread.sleep(10000L);
        if (withConfiguration) {
            this.startConfiguration();
        }
        Thread.sleep(10000L);
        this.startParam(paramAppType);
        this._transmitterObject = helper.getTransmitter();
        this._transmitterObject.setCloseHandler((ApplicationCloseActionHandler)new NormalCloser());
        System.out.println("Transmitter gestartet");
    }

    public Transmitter getTransmitterObject() {
        return this._transmitterObject;
    }

    public void startOperatingMessageManagement() throws IOException {
        if (this._operatingMessageManagement != null) {
            System.out.println("Betriebsmeldungsverwaltung wurde bereits gestartet");
            return;
        }
        String[] defaultParam = new String[]{"-datenverteiler=localhost:" + this._davAppPort, "-benutzer=Tester", "-authentifizierung=" + new File(this._workingDirectory, "passwd.properties").getAbsolutePath(), "-debugLevelStdErrText=CONFIG", "-debugLevelFileText=INFO"};
        String[] defaultJavaCommandArray = DaVStarter.createDefaultCommandArray("de.kappich.vew.bmvew.main.SimpleMessageManager", 64, this._classPathOverride);
        String[] commandArrayOperatingMessageManagement = DaVStarter.mergeArrays(defaultJavaCommandArray, defaultParam);
        this._operatingMessageManagement = DaVStarter.createProcess(commandArrayOperatingMessageManagement, "bmv> ", "BMV> ", null);
        System.out.println("Betriebsmeldungsverwaltung gestartet");
    }

    public void setAdditionalTransmitterArgs(String ... additionalTransmitterArgs) {
        this._additionalTransmitterArgs = additionalTransmitterArgs;
    }

    public void setClassPath(String ... classPathOverride) {
        this._classPathOverride = classPathOverride;
    }

    public ReleaseVersion getReleaseVersion() {
        return this._releaseVersion;
    }

    public void setReleaseVersion(ReleaseVersion releaseVersion) {
        this._releaseVersion = releaseVersion;
    }

    public int getPassivePort() {
        return this._passivePort;
    }

    public void setPassivePort(int passivePort) {
        this._passivePort = passivePort;
    }

    public synchronized void stopDavWithoutWaiting() {
        if (this._transmitter != null) {
            this._transmitter.destroy();
            this._transmitter = null;
            System.out.println("Prozess - Transmitter - gestoppt");
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this._operatingMessageManagement != null) {
            this._operatingMessageManagement.destroy();
            this._operatingMessageManagement = null;
            System.out.println("Prozess - Betriebsmeldungsverwaltung - gestoppt");
        }
        if (this._configuration != null) {
            this._configuration.destroy();
            this._configuration = null;
            System.out.println("Prozess - Konfiguration - gestoppt");
        }
        if (this._param != null) {
            this._param.destroy();
            this._param = null;
            System.out.println("Prozess - Parametrierung - gestoppt");
        }
    }

    public synchronized void stopDaV() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stopDavWithoutFileDeletion();
        if (this._workingDirectory != null) {
            FileCopy.deleteDirectoryOrFile(this._workingDirectory);
        }
    }

    public synchronized void stopDavWithoutSleep(boolean withFileDeletion) {
        this.stopDavWithoutFileDeletion();
        if (withFileDeletion && this._workingDirectory != null) {
            FileCopy.deleteDirectoryOrFile(this._workingDirectory);
        }
    }

    public synchronized void stopDavWithoutFileDeletion() {
        if (this._transmitterObject != null) {
            System.out.println("Datenverteiler wird beendet.");
            this._transmitterObject.shutdown(false, "Ende des Tests");
            System.out.println("Datenverteiler beendet.");
            this._transmitterObject = null;
        }
        if (this._transmitter != null) {
            System.out.println("Datenverteiler wird beendet.");
            this._transmitter.destroy();
            try {
                this._transmitter.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Datenverteiler beendet.");
            this._transmitter = null;
        }
        if (this._operatingMessageManagement != null) {
            DaVStarter.waitForProcessExit("Betriebsmeldungsverwaltung", this._operatingMessageManagement, 10000);
            this._operatingMessageManagement = null;
        }
        if (this._configuration != null) {
            DaVStarter.waitForProcessExit("Konfiguration", this._configuration, 60000);
            this._configuration = null;
        }
        if (this._param != null) {
            DaVStarter.waitForProcessExit("Parametrierung", this._param, 60000);
            this._param = null;
        }
        System.out.println("Alle Prozesse gestoppt");
    }

    public synchronized void startConfiguration() throws IOException {
        if (this._configuration != null) {
            this._configuration.destroy();
        }
        this._configuration = DaVStarter.createProcess(this.createConfigCommandArray(this._configurationManagementFile, this._userFile, this._userNameConfiguration, this._passwd, 2000), "kon" + this.getPrefixString() + "> ", "KON" + this.getPrefixString() + "> ", null);
        System.out.println("Konfiguration gestartet");
    }

    private String getPrefixString() {
        if (this._name.isEmpty()) {
            return "";
        }
        return "." + this._name;
    }

    public synchronized void startDefaultParam() throws IOException {
        if (this._param != null) {
            this._param.destroy();
        }
        this._param = DaVStarter.createProcess(this.createParamCommandArray(this._userNameParam, this._passwd, this._paramDirectory, 1000), "par" + this.getPrefixString() + "> ", "PAR" + this.getPrefixString() + "> ", null);
        System.out.println("Parametrierung gestartet");
    }

    public FakeParamApp getFakeParamApp() {
        return this._fakeParamApp;
    }

    public void setFakeParamApp(FakeParamApp fakeParamApp) {
        this._fakeParamApp = fakeParamApp;
    }

    public String getUserNameParam() {
        return this._userNameParam;
    }

    public void setUserNameParam(String userNameParam) {
        this._userNameParam = userNameParam;
    }

    public String getUserNameConfiguration() {
        return this._userNameConfiguration;
    }

    public void setUserNameConfiguration(String userNameConfiguration) {
        this._userNameConfiguration = userNameConfiguration;
    }

    public String getUserNameTransmitter() {
        return this._userNameTransmitter;
    }

    public void setUserNameTransmitter(String userNameTransmitter) {
        this._userNameTransmitter = userNameTransmitter;
    }

    public void startTransmitter() throws IOException {
        this.startTransmitter(false);
    }

    public void startTransmitter(boolean waitForParamApp) throws IOException {
        if (this._transmitter != null) {
            this._transmitter.destroy();
        }
        this._transmitter = DaVStarter.createProcess(this.createTransmitterCommandArray(256, waitForParamApp), "dav" + this.getPrefixString() + "> ", "DAV" + this.getPrefixString() + "> ", null);
        System.out.print("Starte Datenverteiler");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ImmutableList<Integer> getActivePorts() {
        return this._activePorts;
    }

    public void setActivePorts(Collection<Integer> activePorts) {
        this._activePorts = ImmutableList.copyOf(activePorts);
    }

    private static class OutputThread
    implements Runnable {
        private final BufferedReader _reader;
        private final String _outputPrefix;

        public OutputThread(InputStreamReader inputReader, String outputPrefix) {
            this._reader = new BufferedReader(inputReader);
            this._outputPrefix = outputPrefix;
        }

        @Override
        public void run() {
            try {
                String line;
                while (!Thread.interrupted() && (line = this._reader.readLine()) != null) {
                    System.out.println(this._outputPrefix + line);
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class TransmitterThread
    implements Runnable {
        private final Object _lockObject = new Object();
        private final boolean _waitForParamApp;
        private Transmitter _transmitter;
        private boolean _failed;

        public TransmitterThread(boolean waitForParamApp) {
            this._waitForParamApp = waitForParamApp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this._lockObject;
                synchronized (object) {
                    this._transmitter = new Transmitter(DaVStarter.this.createTransmitterArgs(this._waitForParamApp));
                    this._lockObject.notifyAll();
                }
            }
            catch (Exception e) {
                Object object = this._lockObject;
                synchronized (object) {
                    this._failed = true;
                    this._lockObject.notifyAll();
                }
                e.printStackTrace();
                DaVStarter.this.stopDaV();
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transmitter getTransmitter() {
            Object object = this._lockObject;
            synchronized (object) {
                long timeOut = System.currentTimeMillis() + 300000L;
                while (this._transmitter == null && !this._failed) {
                    try {
                        long remaining = timeOut - System.currentTimeMillis();
                        if (remaining <= 0L) {
                            throw new RuntimeException("Transmitter konnte nicht gestartet werden");
                        }
                        this._lockObject.wait(remaining);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (this._transmitter == null) {
                    throw new RuntimeException("Transmitter konnte nicht gestartet werden");
                }
                return this._transmitter;
            }
        }
    }
}

