/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import com.google.common.collect.ImmutableList;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ClientApplication;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.dav.main.TerminateConnection;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.kappich.pat.testumg.util.DafApplicationEnvironment;
import de.kappich.pat.testumg.util.FakeParamApp;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;

public class DafApplication<T> {
    private final DafApplicationEnvironment _dafApplicationEnvironment;
    private final Function<String[], T> _creator;
    private final List<String> _args;
    private final String _user;
    private final String _id;
    private ClientDavInterface _managementConnection;
    private T _instance;

    protected DafApplication(DafApplicationEnvironment dafApplicationEnvironment, Function<String[], T> creator, List<String> args, String user) {
        this._dafApplicationEnvironment = dafApplicationEnvironment;
        this._creator = creator;
        this._args = new ArrayList<String>(args);
        this._user = user;
        this._id = UUID.randomUUID().toString();
    }

    @Deprecated
    protected DafApplication(DafApplicationEnvironment dafApplicationEnvironment, Function<String[], T> creator, List<String> args, String debugLevel, String user) {
        this._dafApplicationEnvironment = dafApplicationEnvironment;
        this._creator = creator;
        this._args = new ArrayList<String>(args);
        this._user = user;
        this._id = UUID.randomUUID().toString();
    }

    public T start() {
        this._managementConnection = this._dafApplicationEnvironment.connect();
        this._instance = this._creator.apply(this.getArguments());
        return this._instance;
    }

    public ClientApplication getClientApplication() {
        try {
            List applications = this._managementConnection.getLocalApplicationObject().getType().getObjects();
            DataModel dataModel = this._managementConnection.getDataModel();
            AttributeGroup atg = dataModel.getAttributeGroup("atg.applikationsFertigmeldung");
            Aspect asp = dataModel.getAspect("asp.standard");
            DataDescription dataDescription = new DataDescription(atg, asp);
            while (true) {
                ResultData[] data;
                for (ResultData datum : data = this._managementConnection.getData(applications.toArray(new SystemObject[0]), dataDescription, 10000L)) {
                    String id;
                    if (!datum.hasData() || !(id = datum.getData().getTextValue("Inkarnationsname").getText()).equals(this._id)) continue;
                    return (ClientApplication)datum.getObject();
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public ClientApplication waitUntilReady() {
        try {
            DataModel dataModel = this._managementConnection.getDataModel();
            AttributeGroup atg = dataModel.getAttributeGroup("atg.applikationsFertigmeldung");
            Aspect asp = dataModel.getAspect("asp.standard");
            DataDescription dataDescription = new DataDescription(atg, asp);
            ClientApplication clientApplication = this.getClientApplication();
            while (true) {
                String ready;
                ResultData datum;
                if ((datum = this._managementConnection.getData((SystemObject)clientApplication, dataDescription, 10000L)).hasData() && (ready = datum.getData().getTextValue("InitialisierungFertig").getText()).equals("Ja")) {
                    return (ClientApplication)datum.getObject();
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void startAndWait() {
        this.start();
        this.getClientApplication();
    }

    public void startAndWaitUntilReady() {
        this.start();
        this.waitUntilReady();
    }

    public T getInstance() {
        return this._instance;
    }

    public final void terminate() {
        this.sendTerminationSignal();
        this._instance = null;
    }

    protected void sendTerminationSignal() {
        try {
            TerminateConnection.sendTerminationData((ClientDavInterface)this._managementConnection, Collections.singletonList(this.getClientApplication()));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final Path getRootDir() {
        return this._dafApplicationEnvironment.getRootDir();
    }

    public void addArguments(String ... arguments) {
        this._args.addAll(Arrays.asList(arguments));
    }

    private String[] getArguments() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.addConnectionArgs((ImmutableList.Builder<String>)builder);
        this.addCustomArgs((ImmutableList.Builder<String>)builder);
        builder.addAll(this._args);
        return (String[])builder.build().toArray((Object[])new String[0]);
    }

    protected void addCustomArgs(ImmutableList.Builder<String> builder) {
    }

    private void addConnectionArgs(ImmutableList.Builder<String> builder) {
        builder.add((Object)("-benutzer=" + this._user));
        builder.add((Object)("-inkarnationsName=" + this._id));
        builder.add((Object)("-authentifizierung=" + String.valueOf(this.getPasswordFilePath())));
        builder.add((Object)("-datenverteiler=localhost:" + this._dafApplicationEnvironment.getAppPort()));
    }

    @NotNull
    private Path getPasswordFilePath() {
        return this._dafApplicationEnvironment.getWorkingDirectory().resolve("passwd.properties");
    }

    public FakeParamApp getFakeParamApp() {
        return this._dafApplicationEnvironment.getFakeParamApp();
    }

    public ClientDavInterface getManagementConnection() {
        return this._managementConnection;
    }

    public List<String> getParameters() {
        return Arrays.asList(this.getArguments());
    }

    public String toString() {
        return String.valueOf(this._instance);
    }
}

