/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.main.Data;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;

public final class DataUtil {
    private DataUtil() {
    }

    public static String serializeData(Data dataObject) {
        StringWriter writer = new StringWriter();
        DataUtil.serializeData(writer, dataObject);
        return writer.toString();
    }

    public static void serializeData(StringWriter data, Data dataObject) {
        if (dataObject.isPlain()) {
            String valueText = dataObject.asTextValue().getValueText();
            if (dataObject instanceof Data.NumberValue) {
                valueText = valueText.replace('.', ',');
            }
            if (valueText.contains("'")) {
                data.write("\"");
                data.write(valueText);
                data.write("\"");
            } else {
                data.write("'");
                data.write(valueText);
                data.write("'");
            }
        } else if (dataObject.isList()) {
            data.write("{");
            Iterator iterator = dataObject.iterator();
            while (iterator.hasNext()) {
                Data subData = (Data)iterator.next();
                data.write(subData.getName());
                data.write(":");
                DataUtil.serializeData(data, subData);
                if (!iterator.hasNext()) continue;
                data.write(",");
            }
            data.write("}");
        } else if (dataObject.isArray()) {
            Data.Array array = dataObject.asArray();
            if (array.getLength() == 1) {
                DataUtil.serializeData(data, array.getItem(0));
            } else {
                data.write("[");
                Iterator iterator = dataObject.iterator();
                while (iterator.hasNext()) {
                    Data subData = (Data)iterator.next();
                    DataUtil.serializeData(data, subData);
                    if (!iterator.hasNext()) continue;
                    data.write(",");
                }
                data.write("]");
            }
        }
    }

    public static void deserializeData(String s, Data dataObject) throws IOException {
        DataUtil.deserializeData(new StringReader(s), dataObject);
    }

    public static void deserializeData(StringReader data, Data dataObject) throws IOException {
        if (dataObject.isPlain()) {
            char read = DataUtil.read(data, '\"', '\'');
            String value = DataUtil.readUntil(data, read);
            DataUtil.read(data, read);
            dataObject.asTextValue().setText(value);
        } else if (dataObject.isList()) {
            char c;
            boolean cont;
            DataUtil.read(data, '{');
            if (DataUtil.peek(data) == '}') {
                data.skip(1L);
                return;
            }
            do {
                String att = DataUtil.readUntil(data, ':');
                DataUtil.read(data, ':');
                DataUtil.deserializeData(data, dataObject.getItem(att));
            } while (cont = (c = DataUtil.read(data, ',', '}')) == ',');
        } else if (dataObject.isArray()) {
            Data.Array array = dataObject.asArray();
            if (DataUtil.peek(data) == '[') {
                char c;
                boolean cont;
                DataUtil.read(data, '[');
                if (DataUtil.peek(data) == ']') {
                    array.setLength(0);
                    data.skip(1L);
                    return;
                }
                int i = 0;
                do {
                    array.setLength(i + 1);
                    DataUtil.deserializeData(data, array.getItem(i));
                    ++i;
                } while (cont = (c = DataUtil.read(data, ',', ']')) == ',');
            } else {
                array.setLength(1);
                DataUtil.deserializeData(data, array.getItem(0));
            }
        }
    }

    private static char read(StringReader data, char ... expected) throws IOException {
        String s = DataUtil.readUntil(data, expected);
        if (!s.trim().isEmpty()) {
            throw new IllegalArgumentException("Erwartet: " + new String(expected) + " Gefunden: " + s);
        }
        return (char)data.read();
    }

    private static char peek(StringReader data) throws IOException {
        int c = data.read();
        data.skip(-1L);
        return (char)c;
    }

    private static String readUntil(StringReader data, char ... expected) throws IOException {
        StringBuilder result = new StringBuilder();
        while (true) {
            int c = data.read();
            for (char exp : expected) {
                if (exp != c) continue;
                data.skip(-1L);
                return result.toString();
            }
            if (c == -1) {
                throw new IllegalArgumentException("Erwartet: " + new String(expected) + " Gefunden: " + String.valueOf(result));
            }
            result.append((char)c);
        }
    }
}

