/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.accessControl.AccessControlMode;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.DavConnectionListener;
import de.bsvrz.dav.daf.main.authentication.ClientCredentials;
import de.bsvrz.dav.daf.main.config.management.consistenycheck.ConsistencyCheckResultInterface;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.kappich.pat.testumg.util.ConfigurationController;
import de.kappich.pat.testumg.util.CreateClientDavConnection;
import de.kappich.pat.testumg.util.DaVStarter;
import de.kappich.pat.testumg.util.DafApplicationEnvironment;
import de.kappich.pat.testumg.util.FakeParamApp;
import de.kappich.pat.testumg.util.FileCopy;
import de.kappich.pat.testumg.util.MultiDavTestEnvironment;
import de.kappich.pat.testumg.util.ParamAppType;
import de.kappich.pat.testumg.util.TempDirectoryCreator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.junit.Assert;

public class DavTestEnvironment
implements DafApplicationEnvironment {
    private final String _applicationName;
    private final Debug _debug;
    private final Map<ClientDavInterface, ConnectionListener> _connectionsWithListeners = new HashMap<ClientDavInterface, ConnectionListener>();
    private final FakeParamApp _fakeParamApp = new FakeParamApp();
    private String _applicationClassName;
    private DaVStarter _davStarter;
    private String _davHostname;
    private int _davTcpPort;
    private File _temporaryDirectory;
    private String _configurationDebugLevel = "WARNING";
    private String _transmitterDebugLevel = "WARNING";
    private String _paramDebugLevel = "WARNING";
    private ConfigurationController _configurationController;
    private String[] _additionalTransmitterArgs = new String[0];
    private boolean _startDavInSameProcess;
    private ParamAppType _paramAppType = ParamAppType.DefaultParamApp;

    public DavTestEnvironment(String debugLevel) {
        this(debugLevel, null);
    }

    public DavTestEnvironment(String debugLevelStdErr, String debugLevelFile) {
        try {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            this._applicationClassName = DavTestEnvironment.class.getName();
            for (int i = stackTraceElements.length - 1; i >= 0; --i) {
                StackTraceElement stackTraceElement = stackTraceElements[i];
                String stackTraceElementClassName = stackTraceElements[i].getClassName();
                if (stackTraceElementClassName.equals(DavTestEnvironment.class.getName())) break;
                this._applicationClassName = stackTraceElementClassName;
            }
            String[] strings = this._applicationClassName.split("\\.");
            this._applicationName = strings[strings.length - 1];
            String[] argumentStrings = debugLevelFile == null || debugLevelFile.isEmpty() ? new String[]{"-debugLevelStdErrText=" + debugLevelStdErr} : new String[]{"-debugLevelStdErrText=" + debugLevelStdErr, "-debugLevelFileText=" + debugLevelFile};
            Debug.init((String)this._applicationName, (ArgumentList)new ArgumentList(argumentStrings));
            this._debug = Debug.getLogger();
            System.out.println(this._applicationName + ": Testumgebung mit Debug-Level " + debugLevelStdErr + " erzeugt");
        }
        catch (Exception e) {
            String message = "Fehler beim Erzeugen der Datenverteiler-Testumgebung";
            System.out.println("Fehler beim Erzeugen der Datenverteiler-Testumgebung: " + String.valueOf(e));
            e.printStackTrace();
            throw new RuntimeException("Fehler beim Erzeugen der Datenverteiler-Testumgebung", e);
        }
    }

    private static void addResourceNames(ArrayList<String> resourceNames, Path directory, String resourceNamePrefix) {
        Stream<Path> files;
        try {
            files = Files.list(directory);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        files.forEach(subFile -> {
            String resourceName = resourceNamePrefix + "/" + String.valueOf(subFile.getFileName());
            if (Files.isDirectory(subFile, new LinkOption[0])) {
                DavTestEnvironment.addResourceNames(resourceNames, subFile, resourceName);
            } else {
                resourceNames.add(resourceName);
            }
        });
    }

    public File getTemporaryDirectory() {
        if (this._temporaryDirectory == null) {
            this._temporaryDirectory = TempDirectoryCreator.createTemporaryDirectory().toFile();
        }
        return this._temporaryDirectory;
    }

    public void deleteTemporaryDirectory() {
        if (this._temporaryDirectory != null) {
            try {
                this._debug.info("Tempor\u00e4re Dateien werden gel\u00f6scht");
                FileCopy.deleteDirectoryOrFile(this._temporaryDirectory);
                this._temporaryDirectory = null;
            }
            catch (Exception e) {
                String message = "Fehler beim L\u00f6schen von tempor\u00e4ren Dateien";
                this._debug.error("Fehler beim L\u00f6schen von tempor\u00e4ren Dateien", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public void useDav(String davHostname, int davTcpPort) {
        this._davHostname = davHostname;
        this._davTcpPort = davTcpPort;
    }

    public void setConfigurationDebugLevel(String configurationDebugLevel) {
        this._configurationDebugLevel = configurationDebugLevel;
    }

    public void setTransmitterDebugLevel(String transmitterDebugLevel) {
        this._transmitterDebugLevel = transmitterDebugLevel;
    }

    public void setParamDebugLevel(String paramDebugLevel) {
        this._paramDebugLevel = paramDebugLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDav(String ... configurationAreaPids) {
        try {
            DaVStarter davStarter;
            if (this._davStarter != null) {
                throw new RuntimeException("Datenverteiler soll gestartet werden, obwohl er bereits gestartet wurde.");
            }
            if (this._configurationController != null) {
                throw new RuntimeException("Datenverteiler soll gestartet werden, obwohl die Konfiguration bereits geladen wurde.");
            }
            if (configurationAreaPids == null || configurationAreaPids.length == 0) {
                davStarter = new DaVStarter(new File(this.getTemporaryDirectory(), "konfiguration"), false, this._configurationDebugLevel, this._transmitterDebugLevel, this._paramDebugLevel);
            } else {
                ConfigurationController configurationController = new ConfigurationController(this._applicationClassName, this.getTemporaryDirectory());
                ArrayList<String> pidsWithVersion = new ArrayList<String>();
                for (int i = 0; i < configurationAreaPids.length; ++i) {
                    String configurationAreaPid = configurationAreaPids[i];
                    if (configurationAreaPid != null) {
                        pidsWithVersion.add(configurationAreaPid);
                    }
                    if (configurationAreaPid == null || i == configurationAreaPids.length - 1 && !pidsWithVersion.isEmpty()) {
                        try {
                            System.out.println("Konfigurationsbereiche werden importiert und aktiviert: " + String.valueOf(pidsWithVersion));
                            configurationController.startConfigurationWithTestAuthority();
                            ArrayList<String> pids = new ArrayList<String>();
                            for (String pid : pidsWithVersion) {
                                int version = -1;
                                if (pid.matches(".*:[0-9]*")) {
                                    version = Integer.parseInt(pid.replaceFirst(".*:", ""));
                                    System.out.println("version = " + version);
                                    pid = pid.replaceFirst(":[0-9]*$", "");
                                    System.out.println("pid = " + pid);
                                }
                                configurationController.copyImportFile(pid, version);
                                pids.add(pid);
                            }
                            configurationController.importConfigurationAreas(pids);
                            ConsistencyCheckResultInterface result = configurationController.activateConfigurationAreas(pids);
                            if (result.interferenceErrors() || result.localError()) {
                                Assert.fail((String)("Fehler beim aktivieren der Konfigurationsbereiche:\n" + result.toString()));
                            }
                        }
                        finally {
                            configurationController.closeConfiguration();
                        }
                    }
                    if (configurationAreaPid != null) continue;
                    pidsWithVersion.clear();
                }
                davStarter = configurationController.getDaVStarter(this._configurationDebugLevel, this._transmitterDebugLevel, this._paramDebugLevel);
            }
            davStarter.setDebugName(this._applicationName);
            davStarter.setAdditionalTransmitterArgs(this._additionalTransmitterArgs);
            this._debug.info("Datenverteiler wird gestartet");
            this._davStarter = davStarter;
            this._davTcpPort = davStarter.getDavAppPort();
            this._davHostname = "127.0.0.1";
            if (this._fakeParamApp != null) {
                davStarter.setFakeParamApp(this._fakeParamApp);
            }
            if (this._startDavInSameProcess) {
                davStarter.startTransmitterInSameProcess(true, this._paramAppType);
            } else {
                davStarter.startDaV(this._paramAppType);
            }
        }
        catch (Exception e) {
            String message = "Fehler beim Start des Datenverteilers";
            this._debug.error("Fehler beim Start des Datenverteilers", (Throwable)e);
            e.printStackTrace();
            MultiDavTestEnvironment.dumpThreads(System.err);
            throw new RuntimeException("Fehler beim Start des Datenverteilers", e);
        }
    }

    public void startDavWithAccessControl(AccessControlMode accessControlType, boolean containsDaVFiles, String ... accessControlPlugins) {
        try {
            if (this._davStarter != null) {
                throw new RuntimeException("Datenverteiler soll gestartet werden, obwohl er bereits gestartet wurde.");
            }
            if (this._configurationController != null) {
                throw new RuntimeException("Datenverteiler soll gestartet werden, obwohl die Konfiguration bereits geladen wurde.");
            }
            File workingDirectory = this.getTemporaryDirectory();
            File[] temporaryFiles = workingDirectory.listFiles();
            if (temporaryFiles != null) {
                for (File temporaryFile : temporaryFiles) {
                    if (!temporaryFile.getName().equals("konfiguration") || !temporaryFile.isDirectory()) continue;
                    workingDirectory = temporaryFile;
                }
            }
            DaVStarter davStarter = new DaVStarter(workingDirectory, containsDaVFiles, this._configurationDebugLevel, this._transmitterDebugLevel, this._paramDebugLevel, accessControlType, accessControlPlugins);
            if (this._fakeParamApp != null) {
                davStarter.setFakeParamApp(this._fakeParamApp);
            }
            this._debug.info("Datenverteiler wird gestartet");
            this._davStarter = davStarter;
            this._davTcpPort = davStarter.getDavAppPort();
            this._davHostname = "127.0.0.1";
            if (this._startDavInSameProcess) {
                davStarter.startTransmitterInSameProcess(true, this._paramAppType);
            } else {
                davStarter.startDaV();
            }
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            String message = "Fehler beim Start des Datenverteilers";
            this._debug.error("Fehler beim Start des Datenverteilers", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException("Fehler beim Start des Datenverteilers", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationController startConfig(String ... configurationAreaPids) {
        try {
            if (this._davStarter != null) {
                throw new RuntimeException("Konfiguration soll geladen werden, obwohl der Datenverteiler bereits gestartet wurde.");
            }
            if (this._configurationController != null) {
                throw new RuntimeException("Konfiguration soll geladen werden, obwohl sie bereits geladen wurde.");
            }
            ConfigurationController configurationController = new ConfigurationController(this._applicationClassName, this.getTemporaryDirectory());
            if (configurationAreaPids != null && configurationAreaPids.length != 0) {
                ArrayList<String> pids = new ArrayList<String>();
                for (int i = 0; i < configurationAreaPids.length; ++i) {
                    String configurationAreaPid = configurationAreaPids[i];
                    if (configurationAreaPid != null) {
                        pids.add(configurationAreaPid);
                    }
                    if (configurationAreaPid == null || i == configurationAreaPids.length - 1 && !pids.isEmpty()) {
                        try {
                            System.out.println("Konfigurationsbereiche werden importiert und aktiviert: " + String.valueOf(pids));
                            configurationController.startConfigurationWithTestAuthority();
                            configurationController.copyImportFiles(pids);
                            configurationController.importConfigurationAreas(pids);
                            configurationController.activateConfigurationAreas(pids);
                        }
                        finally {
                            configurationController.closeConfiguration();
                        }
                    }
                    if (configurationAreaPid != null) continue;
                    pids.clear();
                }
            }
            configurationController.startConfigurationWithTestAuthority();
            this._debug.info("Konfiguration geladen");
            this._configurationController = configurationController;
            return this._configurationController;
        }
        catch (Exception e) {
            String message = "Fehler beim Laden der Konfiguration";
            this._debug.error("Fehler beim Laden der Konfiguration", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException("Fehler beim Laden der Konfiguration", e);
        }
    }

    public void stopConfig(boolean withFileDeletion) {
        try {
            if (this._configurationController == null) {
                this._debug.warning("Konfiguration soll geschlossen werden, obwohl sie nicht geladen wurde.");
            } else {
                ConfigurationController configurationController = this._configurationController;
                this._configurationController = null;
                configurationController.closeConfiguration();
            }
        }
        catch (Exception e) {
            String message = "Fehler beim Schlie\u00dfen der Konfiguration";
            this._debug.error("Fehler beim Schlie\u00dfen der Konfiguration", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException("Fehler beim Schlie\u00dfen der Konfiguration", e);
        }
        if (withFileDeletion) {
            this.deleteTemporaryDirectory();
        }
    }

    public void startOperatingMessageManagement() {
        if (this._davStarter == null) {
            this._debug.warning("Betriebsmeldungsverwaltung soll gestartet werden, obwohl Datenverteiler noch nicht gestartet wurde.");
        } else {
            try {
                this._davStarter.startOperatingMessageManagement();
            }
            catch (IOException e) {
                this._debug.warning("Fehler beim Start der Betriebsmeldungsverwaltung", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void stopDav(boolean withFileDeletion) {
        try {
            if (this._davStarter == null) {
                this._debug.warning("Datenverteiler soll gestoppt werden, obwohl er nicht gestartet wurde.");
            } else {
                this.stopAllConnections();
                this._debug.info("Datenverteiler wird gestoppt");
                DaVStarter davStarter = this._davStarter;
                this._davStarter = null;
                davStarter.stopDavWithoutFileDeletion();
            }
        }
        catch (Exception e) {
            String message = "Fehler beim Beenden des Datenverteilers";
            this._debug.error("Fehler beim Beenden des Datenverteilers", (Throwable)e);
            e.printStackTrace();
        }
        if (withFileDeletion) {
            this.deleteTemporaryDirectory();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopAll(boolean withFileDeletion) {
        this._debug.info("Alles wird gestoppt");
        if (this._davStarter != null) {
            this.stopDav(withFileDeletion);
        }
        if (this._configurationController != null) {
            this.stopConfig(withFileDeletion);
        }
        if (withFileDeletion) {
            this.deleteTemporaryDirectory();
        }
    }

    public ClientDavInterface startDavConnection() {
        return this.startDavConnection(null);
    }

    public ClientDavInterface startDavConnection(String user, ClientCredentials clientCredentials) {
        return this.startDavConnection(null, user, clientCredentials);
    }

    public ClientDavInterface startDavConnection(ClientDavParameters clientDavParameters) {
        return this.startDavConnection(clientDavParameters, "Tester", ClientCredentials.ofString((String)"geheim"));
    }

    public ClientDavInterface startDavConnection(ClientDavParameters clientDavParameters, String user, ClientCredentials clientCredentials) {
        this._debug.info("Datenverteiler-Verbindung wird gestartet");
        try {
            CreateClientDavConnection createClientDavConnection = new CreateClientDavConnection(user, clientCredentials, this._applicationName, clientDavParameters, this._davHostname, this._davTcpPort);
            ClientDavInterface connection = createClientDavConnection.getConnection();
            MessageSender.getInstance().init(connection, this._applicationName, this._applicationName);
            ConnectionListener connectionListener = new ConnectionListener();
            connection.addConnectionListener((DavConnectionListener)connectionListener);
            this._connectionsWithListeners.put(connection, connectionListener);
            return connection;
        }
        catch (Exception e) {
            String message = "Fehler beim Erzeugen einer Datenverteiler-Verbindung";
            this._debug.error("Fehler beim Erzeugen einer Datenverteiler-Verbindung", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException("Fehler beim Erzeugen einer Datenverteiler-Verbindung", e);
        }
    }

    public void stopDavConnection(ClientDavInterface connection) {
        try {
            if (connection == null) {
                this._debug.warning("Datenverteiler-Verbindung zum Datenverteiler sollte gestoppt werden, ist aber null");
                return;
            }
            ConnectionListener connectionListener = this._connectionsWithListeners.remove(connection);
            if (connectionListener == null) {
                this._debug.warning("Datenverteiler-Verbindung sollte gestoppt werden, ist aber bereits gestoppt worden oder wurde anders erzeugt");
            } else if (connectionListener.isClosed()) {
                this._debug.warning("Datenverteiler-Verbindung sollte gestoppt werden, ist aber bereits vom Datenverteiler terminiert worden");
            } else {
                this._debug.info("Datenverteiler-Verbindung wird gestoppt");
                connection.disconnect(false, "");
                if (connectionListener.waitForClosed(5000L)) {
                    this._debug.info("Datenverteiler-Verbindung wurde erfolgreich gestoppt");
                } else {
                    this._debug.info("Datenverteiler-Verbindung konnte nicht gestoppt werden");
                }
                connection.removeConnectionListener((DavConnectionListener)connectionListener);
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            String message = "Fehler beim Stoppen einer Datenverteiler-Verbindung";
            this._debug.error("Fehler beim Stoppen einer Datenverteiler-Verbindung", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void stopAllConnections() {
        ClientDavInterface[] connections;
        this._debug.info("Alle Datenverteiler-Verbindungen werden gestoppt");
        for (ClientDavInterface connection : connections = this._connectionsWithListeners.keySet().toArray(new ClientDavInterface[0])) {
            this.stopDavConnection(connection);
        }
    }

    public Process startJavaProcessAsDavClient(String outputPrefix, String errorOutputPrefix, String className, String debugLevel, int maxHeapMegaBytes, String ... arguments) {
        LinkedList<Object> javaArguments = new LinkedList<Object>();
        javaArguments.add("-datenverteiler=localhost:" + (8083 + DaVStarter.getDavPortNumberOffset()));
        javaArguments.add("-benutzer=Tester");
        javaArguments.add("-authentifizierung=" + this._davStarter.getWorkingDirectory().getAbsolutePath() + File.separator + "passwd.properties");
        javaArguments.add("-debugLevelStdErrText=" + debugLevel);
        Collections.addAll(javaArguments, arguments);
        Process process = this.startJavaProcess(outputPrefix, errorOutputPrefix, className, maxHeapMegaBytes, javaArguments.toArray(new String[0]));
        System.out.println(className + " gestartet");
        System.out.println("javaArguments = " + String.valueOf(javaArguments));
        return process;
    }

    public Process startJavaProcess(String outputPrefix, String errorOutputPrefix, String className, int maxHeapMegaBytes, String ... arguments) {
        String fileSeparator = System.getProperty("file.separator");
        String javaHome = System.getProperty("java.home");
        String classPath = System.getProperty("java.class.path");
        LinkedList<Object> javaArguments = new LinkedList<Object>();
        javaArguments.add(javaHome + fileSeparator + "bin" + fileSeparator + "java");
        javaArguments.add("-Xmx" + maxHeapMegaBytes + "m");
        javaArguments.add("-cp");
        javaArguments.add(classPath);
        javaArguments.add(className);
        Collections.addAll(javaArguments, arguments);
        return this.startProcess(outputPrefix, errorOutputPrefix, javaArguments.toArray(new String[0]));
    }

    private Process startProcess(String outputPrefix, String errorOutputPrefix, String ... arguments) {
        try {
            return DaVStarter.createProcess(arguments, outputPrefix, errorOutputPrefix, this.getTemporaryDirectory());
        }
        catch (IOException e) {
            String message = "Fehler beim Starten eines Prozesses, Argumente: " + Arrays.toString(arguments);
            this._debug.error(message, (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(message, e);
        }
    }

    public void setStartDavInSameProcess(boolean startDavInSameProcess) {
        this._startDavInSameProcess = startDavInSameProcess;
    }

    public FakeParamApp createFakeParamApp() {
        this.setParamAppType(ParamAppType.FakeParamApp);
        return this._fakeParamApp;
    }

    public void setAdditionalTransmitterArgs(String ... additionalTransmitterArgs) {
        this._additionalTransmitterArgs = additionalTransmitterArgs;
    }

    public String getDavHostname() {
        return this._davHostname;
    }

    public int getDavTcpPort() {
        return this._davTcpPort;
    }

    @Override
    public ClientDavInterface connect() {
        return this.startDavConnection();
    }

    @Override
    public Path getRootDir() {
        return this.getTemporaryDirectory().toPath();
    }

    @Override
    public Path getWorkingDirectory() {
        return this.getTemporaryDirectory().toPath().resolve("konfiguration");
    }

    @Override
    public int getAppPort() {
        return this._davStarter.getDavAppPort();
    }

    @Override
    public FakeParamApp getFakeParamApp() {
        return this._fakeParamApp;
    }

    @Override
    public String getConfigurationAuthority() {
        return "kv.testKonfiguration";
    }

    @Override
    public void setParamAppType(ParamAppType paramAppType) {
        this._paramAppType = Objects.requireNonNull(paramAppType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File copyResources(String resourceNamePrefix, String destinationDirectoryName) {
        try {
            File destinationDirectory = new File(this.getTemporaryDirectory(), destinationDirectoryName);
            ArrayList<String> resourceNames = new ArrayList<String>();
            URL startResource = DavTestEnvironment.class.getClassLoader().getResource(resourceNamePrefix);
            Path path = null;
            try {
                path = Paths.get(startResource.toURI());
            }
            catch (FileSystemNotFoundException fileSystemNotFoundException) {
                // empty catch block
            }
            if (path != null && Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) throw new IllegalArgumentException("Kopieren von Resourcen nicht m\u00f6glich, da die angegebenen Resource '" + resourceNamePrefix + "' kein Verzeichnis ist.");
                DavTestEnvironment.addResourceNames(resourceNames, path, resourceNamePrefix);
            } else {
                URLConnection connection = startResource.openConnection();
                if (!(connection instanceof JarURLConnection)) throw new IllegalArgumentException("Kopieren von Resourcen nicht m\u00f6glich, da '" + String.valueOf(connection) + "' keine JarURLConnection ist.");
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String entryname = entry.getName();
                    if (entry.isDirectory() || !entryname.startsWith(resourceNamePrefix)) continue;
                    resourceNames.add(entryname);
                }
            }
            int resourceNamePrefixLength = resourceNamePrefix.length();
            for (String resourceName : resourceNames) {
                URL resource = DavTestEnvironment.class.getClassLoader().getResource(resourceName);
                InputStream sourceInput = resource.openStream();
                try {
                    String localName = resourceName.substring(resourceNamePrefixLength, resourceName.length());
                    File destinationFile = new File((destinationDirectory.getAbsolutePath() + localName).replace('/', File.separatorChar));
                    FileCopy.copyFile(sourceInput, destinationFile, true);
                }
                finally {
                    if (sourceInput == null) continue;
                    sourceInput.close();
                }
            }
            return destinationDirectory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ConnectionListener
    implements DavConnectionListener {
        private boolean _closed;

        private ConnectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ClientDavInterface connection) {
            ConnectionListener connectionListener = this;
            synchronized (connectionListener) {
                this._closed = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosed() {
            ConnectionListener connectionListener = this;
            synchronized (connectionListener) {
                return this._closed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForClosed(long timeout) {
            long timeoutTime = System.currentTimeMillis() + timeout;
            ConnectionListener connectionListener = this;
            synchronized (connectionListener) {
                try {
                    long delta;
                    while (!this._closed && (delta = timeoutTime - System.currentTimeMillis()) > 0L) {
                        this.wait(delta);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this._closed;
            }
        }
    }
}

