/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.main.ApplicationSubscriptionInfo;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.ClientSubscriptionInfo;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.SubscriptionState;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.AttributeGroupUsage;
import de.bsvrz.dav.daf.main.config.ClientApplication;
import de.bsvrz.dav.daf.main.config.DavApplication;
import de.bsvrz.dav.daf.main.config.MutableSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.impl.config.DafDataModel;
import de.bsvrz.dav.dav.subscriptions.ReceivingSubscription;
import de.bsvrz.dav.dav.subscriptions.SendingSubscription;
import de.bsvrz.dav.dav.subscriptions.Subscription;
import de.bsvrz.dav.dav.subscriptions.SubscriptionInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public final class DavTestUtil {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private static final Map<DataId, LinkedBlockingQueue<ResultData>> _dataQueues = new ConcurrentHashMap<DataId, LinkedBlockingQueue<ResultData>>();
    private static final ClientReceiverInterface _receiver = new ClientReceiverInterface(){

        public void update(ResultData[] results) {
            for (ResultData result : results) {
                DataId dataId = new DataId(result.getObject(), result.getDataDescription());
                LinkedBlockingQueue<ResultData> queue = DavTestUtil.getQueue(dataId);
                queue.add(result);
            }
        }
    };

    private static LinkedBlockingQueue<ResultData> getQueue(DataId description) {
        if (!_dataQueues.containsKey(description)) {
            _dataQueues.putIfAbsent(description, new LinkedBlockingQueue());
            DavTestUtil.getConnection(description._object).subscribeReceiver(_receiver, description._object, description._dataDescription, ReceiveOptions.normal(), ReceiverRole.receiver());
        }
        return _dataQueues.get(description);
    }

    public static void sendData(ResultData dataset) throws OneSubscriptionPerSendData {
        DavTestUtil.sendData(dataset, SenderRole.sender());
    }

    public static void sendData(ResultData dataset, SenderRole senderRole) throws OneSubscriptionPerSendData {
        DavTestUtil.getConnection(dataset.getObject()).subscribeSender((ClientSenderInterface)new DummySender(dataset), dataset.getObject(), dataset.getDataDescription(), senderRole);
    }

    public static ResultData readData(SystemObject systemObject, DataDescription dataDescription) throws InterruptedException {
        return DavTestUtil.readData(systemObject, dataDescription, 5000L);
    }

    public static ResultData readData(SystemObject systemObject, DataDescription dataDescription, long timeout) throws InterruptedException {
        DataId description = new DataId(systemObject, dataDescription);
        LinkedBlockingQueue<ResultData> linkedBlockingQueue = DavTestUtil.getQueue(description);
        ResultData poll = linkedBlockingQueue.poll(timeout, TimeUnit.MILLISECONDS);
        if (poll == null) {
            throw new AssertionError((Object)("Timeout beim Warten auf " + String.valueOf(description)));
        }
        return poll;
    }

    public static void startRead(SystemObject systemObject, DataDescription dataDescription) throws InterruptedException {
        DataId description = new DataId(systemObject, dataDescription);
        DavTestUtil.getQueue(description);
    }

    public static ApplicationSubscriptionInfo getSubscriptionState(ClientApplication application) throws IOException {
        return DavTestUtil.getConnection((SystemObject)application).getSubscriptionInfo(DavTestUtil.findDav(application), application);
    }

    private static DavApplication findDav(ClientApplication application) {
        List davs = application.getDataModel().getType("typ.datenverteiler").getObjects();
        for (SystemObject dav : davs) {
            DavApplication davApplication;
            MutableSet clientApplicationSet;
            if (!(dav instanceof DavApplication) || !(clientApplicationSet = (davApplication = (DavApplication)dav).getClientApplicationSet()).getElements().contains(application)) continue;
            return davApplication;
        }
        return DavTestUtil.getConnection((SystemObject)application).getLocalDav();
    }

    public static ClientSubscriptionInfo getSubscriptionInfo(SystemObject object, AttributeGroup atg, Aspect asp, DavApplication dav) throws IOException {
        return DavTestUtil.getSubscriptionInfo(object, atg, asp, (short)0, dav);
    }

    public static ClientSubscriptionInfo getSubscriptionInfo(SystemObject object, AttributeGroup atg, Aspect asp, short simVar, DavApplication dav) throws IOException {
        AttributeGroupUsage attributeGroupUsage = atg.getAttributeGroupUsage(asp);
        if (attributeGroupUsage == null) {
            throw new IllegalArgumentException("attributeGroupUsage ist nicht vorhanden");
        }
        return DavTestUtil.getConnection(object).getSubscriptionInfo(dav, object, attributeGroupUsage, simVar);
    }

    public static ClientSubscriptionInfo getSubscriptionInfo(SystemObject object, DataDescription dataDescription, DavApplication dav) throws IOException {
        return DavTestUtil.getSubscriptionInfo(object, dataDescription.getAttributeGroup(), dataDescription.getAspect(), dataDescription.getSimulationVariant(), dav);
    }

    public static ClientSubscriptionInfo.ClientReceivingSubscription getReceivingInfo(ClientApplication application, SystemObject object, DataDescription dataDescription) throws IOException {
        ClientSubscriptionInfo subscriptionState = DavTestUtil.getSubscriptionInfo(object, dataDescription, DavTestUtil.findDav(application));
        for (ClientSubscriptionInfo.ClientReceivingSubscription receivingSubscription : subscriptionState.getReceiverSubscriptions()) {
            if (receivingSubscription.getApplicationId() != application.getId()) continue;
            return receivingSubscription;
        }
        return null;
    }

    public static ClientSubscriptionInfo.ClientSendingSubscription getSendingInfo(ClientApplication application, SystemObject object, DataDescription dataDescription) throws IOException {
        ClientSubscriptionInfo subscriptionState = DavTestUtil.getSubscriptionInfo(object, dataDescription, DavTestUtil.findDav(application));
        for (ClientSubscriptionInfo.ClientSendingSubscription sendingSubscription : subscriptionState.getSenderSubscriptions()) {
            if (sendingSubscription.getApplicationId() != application.getId()) continue;
            return sendingSubscription;
        }
        return null;
    }

    public static SubscriptionState getReceivingState(ClientApplication application, SystemObject object, DataDescription dataDescription) throws IOException {
        ClientSubscriptionInfo subscriptionState = DavTestUtil.getSubscriptionInfo(object, dataDescription, DavTestUtil.findDav(application));
        for (ClientSubscriptionInfo.ClientReceivingSubscription receivingSubscription : subscriptionState.getReceiverSubscriptions()) {
            if (receivingSubscription.getApplicationId() != application.getId()) continue;
            return receivingSubscription.getState();
        }
        return null;
    }

    public static SubscriptionState getSendingState(ClientApplication application, SystemObject object, DataDescription dataDescription) throws IOException {
        ClientSubscriptionInfo subscriptionState = DavTestUtil.getSubscriptionInfo(object, dataDescription, DavTestUtil.findDav(application));
        for (ClientSubscriptionInfo.ClientSendingSubscription sendingSubscription : subscriptionState.getSenderSubscriptions()) {
            if (sendingSubscription.getApplicationId() != application.getId()) continue;
            return sendingSubscription.getState();
        }
        return null;
    }

    private static ClientDavConnection getConnection(SystemObject systemObject) {
        return (ClientDavConnection)((DafDataModel)systemObject.getDataModel()).getConnection();
    }

    public static String getDebugString(Subscription subscription) {
        StringBuilder result = new StringBuilder();
        switch (subscription.getConnectionState()) {
            case FROM_LOCAL_OK: {
                result.append("Lokal_");
                break;
            }
            case FROM_REMOTE_OK: {
                result.append("Ein_");
                break;
            }
            case TO_REMOTE_WAITING: {
                result.append("Wartend_");
                break;
            }
            case TO_REMOTE_OK: {
                result.append("Positiv_");
                break;
            }
            case TO_REMOTE_NOT_RESPONSIBLE: {
                result.append("Negativ_");
                break;
            }
            case TO_REMOTE_NOT_ALLOWED: {
                result.append("KeineRechte_");
                break;
            }
            case TO_REMOTE_MULTIPLE: {
                result.append("Mehrere_");
            }
        }
        if (subscription instanceof SendingSubscription) {
            SendingSubscription sendingSubscription = (SendingSubscription)subscription;
            switch (sendingSubscription.getState()) {
                case RECEIVERS_AVAILABLE: {
                    result.append("Bereit_");
                    break;
                }
                case NO_RECEIVERS: {
                    result.append("KeineEmpf\u00e4nger_");
                    break;
                }
                case WAITING: {
                    result.append("Wartend_");
                    break;
                }
                case NOT_ALLOWED: {
                    result.append("KeineRechte_");
                    break;
                }
                case INVALID_SUBSCRIPTION: {
                    result.append("Ung\u00fcltig_");
                    break;
                }
                case NO_REMOTE_SOURCE: {
                    result.append("NichtZust\u00e4ndig_");
                    break;
                }
                case MULTIPLE_REMOTE_LOCK: {
                    result.append("Gesperrt_");
                }
            }
            if (sendingSubscription.isSource()) {
                result.append("Quelle_");
            }
            if (sendingSubscription.isRequestSupported()) {
                result.append("SendeSteuerung_");
            }
        } else if (subscription instanceof ReceivingSubscription) {
            ReceivingSubscription receivingSubscription = (ReceivingSubscription)subscription;
            switch (receivingSubscription.getState()) {
                case SENDERS_AVAILABLE: {
                    result.append("Bereit_");
                    break;
                }
                case NO_SENDERS: {
                    result.append("KeineSender_");
                    break;
                }
                case WAITING: {
                    result.append("Wartend_");
                    break;
                }
                case NOT_ALLOWED: {
                    result.append("KeineRechte_");
                    break;
                }
                case INVALID_SUBSCRIPTION: {
                    result.append("Ung\u00fcltig_");
                    break;
                }
                case NO_REMOTE_DRAIN: {
                    result.append("NichtZust\u00e4ndig_");
                    break;
                }
                case MULTIPLE_REMOTE_LOCK: {
                    result.append("Gesperrt_");
                }
            }
            if (receivingSubscription.isDrain()) {
                result.append("Senke_");
            }
            if (receivingSubscription.getReceiveOptions().withDelayed()) {
                result.append("Nachgeliefert_");
            }
            if (receivingSubscription.getReceiveOptions().withDelta()) {
                result.append("Delta_");
            }
        }
        result.append(subscription.getCommunication());
        return result.toString();
    }

    public static void compareSenders(SubscriptionInfo subscriptionInfo, String ... expected) {
        if (subscriptionInfo == null) {
            Assert.assertTrue((expected.length == 0 ? 1 : 0) != 0);
            return;
        }
        TreeSet<String> expectedSet = new TreeSet<String>(Arrays.asList(expected));
        TreeSet<String> actual = new TreeSet<String>();
        for (SendingSubscription sendingSubscription : subscriptionInfo.getSendingSubscriptions()) {
            actual.add(DavTestUtil.getDebugString((Subscription)sendingSubscription));
        }
        Assert.assertEquals((String)"Sender stimmen nicht \u00fcberein", expectedSet, actual);
    }

    public static void compareReceivers(SubscriptionInfo subscriptionInfo, String ... expected) {
        if (subscriptionInfo == null) {
            Assert.assertTrue((expected.length == 0 ? 1 : 0) != 0);
            return;
        }
        TreeSet<String> expectedSet = new TreeSet<String>(Arrays.asList(expected));
        TreeSet<String> actual = new TreeSet<String>();
        for (ReceivingSubscription receivingSubscription : subscriptionInfo.getReceivingSubscriptions()) {
            actual.add(DavTestUtil.getDebugString((Subscription)receivingSubscription));
        }
        Assert.assertEquals((String)"Empf\u00e4nger stimmen nicht \u00fcberein", expectedSet, actual);
    }

    private static class DataId {
        final SystemObject _object;
        final DataDescription _dataDescription;

        public DataId(SystemObject object, DataDescription dataDescription) {
            this._object = object;
            this._dataDescription = dataDescription;
        }

        public String toString() {
            return this._object.getPidOrId() + ":" + this._dataDescription.getAttributeGroup().getPidOrId() + ":" + this._dataDescription.getAspect().getPidOrId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataId)) {
                return false;
            }
            DataId that = (DataId)o;
            if (this._object != that._object) {
                return false;
            }
            return this._dataDescription.equals((Object)that._dataDescription);
        }

        public int hashCode() {
            int result = this._object.hashCode();
            result = 31 * result + this._dataDescription.hashCode();
            return result;
        }
    }

    private static class DummySender
    implements ClientSenderInterface {
        private final ResultData _dataset;

        public DummySender(ResultData dataset) {
            this._dataset = dataset;
        }

        public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
            if (state == 0) {
                try {
                    DavTestUtil.getConnection(object).sendData(this._dataset);
                    DavTestUtil.getConnection(object).unsubscribeSender((ClientSenderInterface)this, object, dataDescription);
                }
                catch (SendSubscriptionNotConfirmed sendSubscriptionNotConfirmed) {
                    sendSubscriptionNotConfirmed.printStackTrace();
                }
            }
        }

        public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
            return true;
        }
    }
}

