/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import de.bsvrz.dav.daf.main.ApplicationCloseActionHandler;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.CommunicationError;
import de.bsvrz.dav.daf.main.ConnectionException;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.InconsistentLoginException;
import de.bsvrz.dav.daf.main.MissingParameterException;
import de.bsvrz.dav.daf.main.NormalCloser;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.dataIdentificationSettings.DataIdentification;
import de.bsvrz.sys.funclib.debug.Debug;
import de.kappich.pat.testumg.util.DaVStarter;
import de.kappich.pat.testumg.util.DataUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FakeParamApp
implements ClientSenderInterface {
    private static final Debug _debug = Debug.getLogger();
    private final Map<StringDataIdent, String> _savedParameters = new ConcurrentHashMap<StringDataIdent, String>();
    private final HashSet<DataIdentification> _dataIdentifications = new HashSet();
    private ClientDavConnection _connection;
    private Aspect _paramAspect;

    public void connect(DaVStarter davStarter) throws MissingParameterException, CommunicationError, ConnectionException, InconsistentLoginException {
        ClientDavParameters clientDavParameters = new ClientDavParameters();
        clientDavParameters.setApplicationTypePid("typ.parametrierungsApplikation");
        clientDavParameters.setApplicationName("FakeParameterApplikation");
        clientDavParameters.setDavCommunicationSubAddress(davStarter.getDavAppPort());
        this._connection = new ClientDavConnection(clientDavParameters);
        this._connection.enableExplicitApplicationReadyMessage();
        this._connection.setCloseHandler((ApplicationCloseActionHandler)new NormalCloser());
        this._connection.connect();
        this._connection.login("parameter", "parameter");
        this._paramAspect = this._connection.getDataModel().getAspect("asp.parameterSoll");
        if (this._paramAspect == null) {
            throw new IllegalArgumentException("_paramAspect ist null");
        }
        for (Map.Entry<StringDataIdent, String> entry : this._savedParameters.entrySet()) {
            this.publishParam(entry.getKey().objectPid, entry.getKey().atgPid, entry.getValue());
        }
        this._connection.sendApplicationReadyMessage();
    }

    public void clear() {
        this._savedParameters.clear();
        for (DataIdentification dataIdentification : this._dataIdentifications) {
            this._connection.unsubscribeSender((ClientSenderInterface)this, dataIdentification.getObject(), dataIdentification.getDataDescription());
        }
    }

    public void publishParam(SystemObject object, AttributeGroup attributeGroup, Data data) {
        this.publishParam(object.getPid(), attributeGroup.getPid(), DataUtil.serializeData(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishParam(String objPid, String atgPid, String data) {
        if (data != null) {
            this._savedParameters.put(new StringDataIdent(objPid, atgPid), data);
        } else {
            this._savedParameters.remove(new StringDataIdent(objPid, atgPid));
        }
        if (this._paramAspect == null) {
            return;
        }
        AttributeGroup attributeGroup = this._connection.getDataModel().getAttributeGroup(atgPid);
        SystemObject object = this._connection.getDataModel().getObject(objPid);
        if (attributeGroup == null) {
            _debug.error("Unbekannte Attributgruppe: " + atgPid);
            return;
        }
        if (object == null) {
            _debug.error("Unbekanntes Objekt: " + objPid);
            return;
        }
        Data dataObject = null;
        if (data != null) {
            dataObject = this._connection.createData(attributeGroup);
            try {
                DataUtil.deserializeData(new StringReader(data), dataObject);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            dataObject = dataObject.createUnmodifiableCopy();
        }
        DataDescription dataDescription = new DataDescription(attributeGroup, this._paramAspect);
        final ResultData resultData = new ResultData(object, dataDescription, System.currentTimeMillis(), dataObject);
        this._dataIdentifications.add(new DataIdentification(resultData.getObject(), resultData.getDataDescription()));
        try {
            this._connection.subscribeSource((ClientSenderInterface)this, resultData);
        }
        catch (OneSubscriptionPerSendData ignored) {
            try {
                this._connection.sendData(resultData);
            }
            catch (SendSubscriptionNotConfirmed sendSubscriptionNotConfirmed) {
                throw new IllegalStateException(sendSubscriptionNotConfirmed);
            }
        }
        final AtomicBoolean hasData = new AtomicBoolean();
        this._connection.subscribeReceiver(new ClientReceiverInterface(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void update(ResultData[] results) {
                for (ResultData result : results) {
                    if (result.getDataTime() != resultData.getDataTime() || !String.valueOf(result.getData()).equals(String.valueOf(resultData.getData()))) continue;
                    FakeParamApp fakeParamApp = FakeParamApp.this;
                    synchronized (fakeParamApp) {
                        hasData.set(true);
                        FakeParamApp.this.notifyAll();
                    }
                }
            }
        }, object, dataDescription, ReceiveOptions.normal(), ReceiverRole.receiver());
        FakeParamApp fakeParamApp = this;
        synchronized (fakeParamApp) {
            try {
                while (!hasData.get() && this._connection.isConnected()) {
                    this.wait(1000L);
                }
                this.wait(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ClientDavConnection getConnection() {
        return this._connection;
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return false;
    }

    static class StringDataIdent {
        final String objectPid;
        final String atgPid;

        public StringDataIdent(String objPid, String atgPid) {
            this.objectPid = objPid;
            this.atgPid = atgPid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringDataIdent)) {
                return false;
            }
            StringDataIdent that = (StringDataIdent)o;
            if (!this.objectPid.equals(that.objectPid)) {
                return false;
            }
            return this.atgPid.equals(that.atgPid);
        }

        public int hashCode() {
            int result = this.objectPid.hashCode();
            result = 31 * result + this.atgPid.hashCode();
            return result;
        }
    }
}

