/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import de.kappich.pat.testumg.essentialconfigareafiles.Helper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class FileCopy {
    public static void copyFile(File sourceFile, File destinationFile, boolean overwriteDestinationAllowed) throws IOException {
        FileInputStream in = new FileInputStream(sourceFile);
        FileCopy.copyFile(in, destinationFile, overwriteDestinationAllowed);
    }

    public static void copyFile(InputStream sourceFile, File destinationFile, boolean overwriteDestinationAllowed) throws IOException {
        if (overwriteDestinationAllowed || !destinationFile.exists()) {
            File parent;
            if (destinationFile.exists() && destinationFile.isFile()) {
                destinationFile.delete();
            }
            if (!(parent = new File(destinationFile.getParent())).exists()) {
                parent.mkdirs();
            }
            try (BufferedInputStream in = new BufferedInputStream(sourceFile);
                 FileOutputStream out = new FileOutputStream(destinationFile);){
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            }
        }
    }

    public static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IllegalArgumentException, IOException {
        System.out.println("zu kopierendes Verzeichnis: " + sourceDirectory.getAbsolutePath());
        if (!sourceDirectory.exists()) {
            throw new IllegalStateException("Das zu kopierende Verzeichnis ist nicht vorhanden: " + sourceDirectory.getAbsolutePath());
        }
        if (!sourceDirectory.isDirectory()) {
            throw new IllegalStateException("Das zu kopierende Verzeichnis ist kein Verzeichnis sondern eine Datei: " + sourceDirectory.getAbsolutePath());
        }
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        } else {
            if (!destinationDirectory.isDirectory()) {
                throw new IllegalStateException("Es wurde kein Verzeichnis \u00fcbergeben: " + destinationDirectory.getAbsolutePath());
            }
            File[] emptyDirectory = destinationDirectory.listFiles();
            if (emptyDirectory.length > 0) {
                throw new IllegalArgumentException("Das Verzeichnis " + destinationDirectory.getAbsolutePath() + " enth\u00e4lt Dateien/Verzeichnisse");
            }
        }
        FileCopy.copyAll(sourceDirectory, destinationDirectory);
    }

    private static void copyAll(File sourceDirectory, File destinationDirectory) throws IOException {
        File[] filesAndDirectories;
        if (sourceDirectory.isFile()) {
            FileCopy.copyFile(sourceDirectory, destinationDirectory, true);
            return;
        }
        for (File file : filesAndDirectories = sourceDirectory.listFiles()) {
            if (file.equals(destinationDirectory)) continue;
            String fileOrDirectoryName = file.getName();
            File expandedDestinationDirectory = new File(destinationDirectory, fileOrDirectoryName);
            FileCopy.copyAll(file, expandedDestinationDirectory);
        }
    }

    public static void deleteDirectoryOrFile(File directoryOrFile) {
        File[] files;
        if (directoryOrFile.isDirectory() && (files = directoryOrFile.listFiles()).length > 0) {
            for (File file : files) {
                FileCopy.deleteDirectoryOrFile(file);
            }
        }
        directoryOrFile.delete();
    }

    public static void copyTestConfigurationAreaFiles(File destinationDirectory) throws IOException {
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        } else {
            File[] emptyDirectory = destinationDirectory.listFiles();
            if (emptyDirectory.length > 0) {
                throw new IllegalArgumentException("Das Verzeichnis " + destinationDirectory.getAbsolutePath() + " enth\u00e4lt Dateien/Verzeichnisse");
            }
        }
        List<String> allFiles = FileCopy.getAllFileNames();
        for (String fileName : allFiles) {
            URL resource = Helper.class.getResource(fileName);
            if (resource == null) {
                throw new IllegalStateException("Resource mit dem Namen " + fileName + " konnte nicht gefunden werden");
            }
            InputStream original = resource.openStream();
            File copyOfFile = new File(destinationDirectory, fileName);
            FileCopy.copyFile(original, copyOfFile, true);
        }
    }

    public static void copyTestConfigurationAreaFilesWithDeleting(File destinationDirectory) throws IOException {
        if (destinationDirectory.exists()) {
            FileCopy.deleteDirectoryOrFile(destinationDirectory);
        }
        FileCopy.copyTestConfigurationAreaFiles(destinationDirectory);
    }

    private static final List<String> getAllFileNames() throws IOException {
        ArrayList<String> allFiles = new ArrayList<String>();
        URL filePathAsURL = Helper.class.getResource("allfiles.properties");
        try (InputStream inputStreamAllFiles = filePathAsURL.openStream();){
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(inputStreamAllFiles));
            String fileName = buffReader.readLine();
            while (fileName != null) {
                allFiles.add(fileName);
                fileName = buffReader.readLine();
            }
        }
        return allFiles;
    }

    public static void removeFiles(File directory, final String fileEnding) {
        if (directory.isDirectory()) {
            File[] delteFiles;
            for (File delteFile : delteFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(fileEnding.toLowerCase());
                }
            })) {
                if (!delteFile.isFile()) continue;
                delteFile.delete();
            }
        } else {
            throw new IllegalArgumentException("Es wurde kein Verzeichnis \u00fcbergeben: " + String.valueOf(directory.getAbsoluteFile()));
        }
    }
}

