/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import com.google.common.collect.ImmutableList;
import de.bsvrz.dav.daf.accessControl.AccessControlMode;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.authentication.ClientCredentials;
import de.bsvrz.dav.daf.main.config.ConfigurationChangeException;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.management.consistenycheck.ConsistencyCheckResultInterface;
import de.bsvrz.puk.config.main.managementfile.ManagementFile;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.testumg.util.ConfigurationController;
import de.kappich.pat.testumg.util.DaVStarter;
import de.kappich.pat.testumg.util.FileCopy;
import de.kappich.pat.testumg.util.SingleDavStarter;
import de.kappich.pat.testumg.util.TempDirectoryCreator;
import de.kappich.pat.testumg.util.connections.DavInformation;
import de.kappich.pat.testumg.util.connections.LocalDavDavConnection;
import de.kappich.pat.testumg.util.connections.LocalDavDavConnectionServer;
import de.kappich.pat.testumg.util.connections.MultiDavProtocolParameter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class MultiDavTestEnvironment {
    private final Path workingDir;
    private final Class<?> _testClass;
    private final String _configurationDebugLevel;
    private final String _transmitterDebugLevel;
    private final String _paramDebugLevel;
    private final HashMap<String, MultiDavStarter> _starterMap = new HashMap();
    private final Collection<DavDavConnection> _davConnections = new ArrayList<DavDavConnection>();
    private final List<ClientDavInterface> _connections = new CopyOnWriteArrayList<ClientDavInterface>();
    private int _appPortCounter = 13081;
    private volatile Semaphore _semaphore;
    private ConfigurationController _globalConfigurationController;
    private int _davDavConnectDelay = 500;
    private int _davDavReconnectDelay = 1000;
    private boolean _hasActivated;

    public MultiDavTestEnvironment() {
        this("WARNING", "ERROR", "ERROR");
    }

    public MultiDavTestEnvironment(String transmitterDebugLevel, String configurationDebugLevel, String paramDebugLevel) {
        Debug.init((String)"DAV", (ArgumentList)new ArgumentList(new String[]{"-debugLevelStdErrText=" + transmitterDebugLevel}));
        this._configurationDebugLevel = configurationDebugLevel;
        this._transmitterDebugLevel = transmitterDebugLevel;
        this._paramDebugLevel = paramDebugLevel;
        this._testClass = SingleDavStarter.getTestClass(MultiDavTestEnvironment.class);
        this.workingDir = TempDirectoryCreator.createTemporaryDirectory().resolve(this._testClass.getSimpleName());
        LocalDavDavConnection.enableAll();
    }

    public static void dumpThreads(PrintStream out) {
        out.println();
        out.println(DateFormat.getInstance().format(System.currentTimeMillis()));
        out.println("Full thread dump");
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : allStackTraces.entrySet()) {
            StackTraceElement[] trace;
            out.println();
            Thread thread = entry.getKey();
            out.printf("\"%s@%d\"%s prio=%d tid=0x%x%n", thread.getName(), thread.getId(), thread.isDaemon() ? " daemon" : "", thread.getPriority(), thread.getId());
            for (StackTraceElement traceElement : trace = entry.getValue()) {
                out.println("\t  at " + String.valueOf(traceElement));
            }
        }
    }

    public MultiDavStarter createDavWithLocalConfiguration(String name) throws Exception {
        return this.createDavWithLocalConfiguration(name, AccessControlMode.Disabled, new String[0]);
    }

    public MultiDavStarter createDavWithLocalConfiguration(String name, AccessControlMode accessControlType, String ... accessControlPlugIns) throws Exception {
        if (this._hasActivated) {
            throw new IllegalStateException("Konfiguration bereits aktiviert");
        }
        int nextAppPort = this.nextFreePort();
        MultiDavStarter starter = new MultiDavStarter(name, accessControlType, accessControlPlugIns, nextAppPort, nextAppPort - 1);
        this._starterMap.put(name, starter);
        return starter;
    }

    public MultiDavStarter createDavWithRemoteConfiguration(String name, String remoteDavName) throws Exception {
        return this.createDavWithRemoteConfiguration(name, remoteDavName, AccessControlMode.Disabled, new String[0]);
    }

    public MultiDavStarter createDavWithRemoteConfiguration(String name, String remoteDavName, int passivePort) throws Exception {
        return this.createDavWithRemoteConfiguration(name, remoteDavName, passivePort, AccessControlMode.Disabled, new String[0]);
    }

    public MultiDavStarter createDavWithRemoteConfiguration(String name, String remoteDavName, AccessControlMode accessControlType, String ... accessControlPlugIns) throws Exception {
        return this.createDavWithRemoteConfiguration(name, remoteDavName, 0, accessControlType, accessControlPlugIns);
    }

    public MultiDavStarter createDavWithRemoteConfiguration(String name, String remoteDavName, int passivePort, AccessControlMode accessControlType, String ... accessControlPlugIns) throws Exception {
        if (this._hasActivated) {
            throw new IllegalStateException("Konfiguration bereits aktiviert");
        }
        int nextAppPort = this.nextFreePort();
        MultiDavStarter starter = new MultiDavStarter(name, accessControlType, accessControlPlugIns, nextAppPort, nextAppPort - 1, passivePort, remoteDavName);
        this._starterMap.put(name, starter);
        return starter;
    }

    public void interruptConnection(String name, String name2) {
        int port = this.getExistingDav(name2).getDavPort();
        int port2 = this.getExistingDav(name).getDavPort();
        LocalDavDavConnection.disableConnection(name, port);
        LocalDavDavConnection.disableConnection(name2, port2);
    }

    public void restoreConnection(String name, String name2) {
        int port = this.getExistingDav(name2).getDavPort();
        int port2 = this.getExistingDav(name).getDavPort();
        LocalDavDavConnection.enableConnection(name, port);
        LocalDavDavConnection.enableConnection(name2, port2);
    }

    public void createDavConnection(String name, String name2) {
        this.createDavConnection(name, name2, "AB");
    }

    public void createDavConnection(String name, String name2, String originator) {
        this.createDavConnection(name, name2, originator, 1, new String[0]);
    }

    public void createDavConnection(String name, String name2, String originator, String user1, String user2, String ... replacementConnections) {
        this.createDavConnection(name, name2, originator, user1, user2, 1, replacementConnections);
    }

    public void createDavConnection(String name, String name2, String originator, int weight, String ... replacementConnections) {
        this.createDavConnection(name, name2, originator, "Tester", "Tester", weight, replacementConnections);
    }

    public void createDavConnection(String name, String name2, String originator, String user1, String user2, int weight, String ... replacementConnections) {
        ArrayList<String> repConn;
        if (this._hasActivated) {
            throw new IllegalStateException("Konfiguration bereits aktiviert");
        }
        if (replacementConnections == null) {
            repConn = null;
        } else {
            repConn = new ArrayList<String>();
            for (int i = 0; i < replacementConnections.length; i += 2) {
                repConn.add("davcon.test." + replacementConnections[i] + "." + replacementConnections[i + 1]);
            }
        }
        this._davConnections.add(new DavDavConnection(name, name2, originator, weight, repConn, user1, user2));
    }

    public void createDavConnection(String name, String name2, String originator, int weight, double transmissionDelay, double maxFlowRate, String ... replacementConnections) {
        if (this._hasActivated) {
            throw new IllegalStateException("Konfiguration bereits aktiviert");
        }
        this.createDavConnection(name, name2, originator, weight, replacementConnections);
        int port = this.getExistingDav(name).getDavPort();
        int port2 = this.getExistingDav(name2).getDavPort();
        LocalDavDavConnection.setConnectionDelay(name, port2, (long)(transmissionDelay * 1000000.0), maxFlowRate);
        LocalDavDavConnection.setConnectionDelay(name2, port, (long)(transmissionDelay * 1000000.0), maxFlowRate);
    }

    public void startAllDavWithoutWaiting() {
        this.startAllDavWithoutWaiting(false);
    }

    public void startAllDavWithoutWaiting(boolean staggered) {
        for (MultiDavStarter starter : this._starterMap.values()) {
            starter.startWithoutWaiting();
            if (!staggered) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopAllConnections() {
        for (ClientDavInterface connection : this._connections) {
            connection.disconnect(false, "ende");
        }
        this._connections.clear();
    }

    public void startAll() throws Exception {
        this.startAll(false);
    }

    public void startAll(boolean staggered) throws Exception {
        int size = this._starterMap.size();
        this._semaphore = new Semaphore(size);
        this._semaphore.acquire(size);
        this.startAllDavWithoutWaiting(staggered);
        this._semaphore.acquire(size);
        this._semaphore = null;
    }

    public void stopAll() {
        for (MultiDavStarter starter : this._starterMap.values()) {
            try {
                starter.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public void stopAllWithoutFileDeletion() {
        for (MultiDavStarter starter : this._starterMap.values()) {
            starter.stopWithoutFileDeletion();
        }
    }

    public void addConfigurationAuthority(String targetDav, String sourceDav) throws Exception {
        String pid = "kb.kv." + sourceDav;
        this.copyConfigurationAreas(targetDav, sourceDav, pid);
    }

    public void addImportFile(String dav, String pid) {
        MultiDavStarter starter = this.getExistingDav(dav);
        starter.addImportFile(pid);
    }

    public void activateConfigurationArea(String dav, String pid) throws Exception {
        MultiDavStarter starter = this.getExistingDav(dav);
        starter.activateAndReleaseForActivation(pid);
    }

    public void copyConfigurationAreas(String targetDav, String sourceDav, String ... areaPids) throws Exception {
        Path targetDir = this.getExistingDav(targetDav).getWorkingDirectory();
        Path sourceDir = this.getExistingDav(sourceDav).getWorkingDirectory();
        for (String areaPid : areaPids) {
            Files.copy(sourceDir.resolve(areaPid + ".config"), targetDir.resolve(areaPid + ".config"), StandardCopyOption.REPLACE_EXISTING);
        }
        MultiDavStarter starter = this.getExistingDav(targetDav);
        starter.addConfigurationFiles(areaPids);
    }

    public MultiDavStarter startDav(String name) {
        MultiDavStarter starter = this.getExistingDav(name);
        starter.startWithoutWaiting();
        return starter;
    }

    public ClientDavInterface getConnection(String name) {
        MultiDavStarter starter = this.getExistingDav(name);
        return starter.connect();
    }

    public MultiDavStarter getDav(String name) {
        return this._starterMap.get(name);
    }

    @NotNull
    public MultiDavStarter getExistingDav(String name) {
        MultiDavStarter starter = this.getDav(name);
        if (starter == null) {
            throw new IllegalArgumentException("Es gibt keinen Datenverteiler " + name);
        }
        return starter;
    }

    public MultiDavStarter stopDav(String name) {
        MultiDavStarter starter = this.getExistingDav(name);
        starter.stop();
        return starter;
    }

    @Deprecated
    public MultiDavStarter stopDavWithoutFileDeletion(String name) {
        MultiDavStarter starter = this.getExistingDav(name);
        starter.stopWithoutFileDeletion();
        return starter;
    }

    public void waitUntilRunning(String name) {
        MultiDavStarter starter = this.getExistingDav(name);
        starter.waitUntilReady();
    }

    public void waitUntilConnected(String dav1, String dav2) throws Exception {
        this.waitUntilConnected(this.getConnection(dav1), dav2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilConnected(ClientDavInterface connection, String otherDav) throws Exception {
        Receiver receiver = new Receiver();
        DataModel dataModel = connection.getDataModel();
        Receiver receiver2 = receiver;
        synchronized (receiver2) {
            connection.subscribeReceiver((ClientReceiverInterface)receiver, dataModel.getObject("dav.test." + otherDav), new DataDescription(dataModel.getAttributeGroup("atg.telegrammLaufzeiten"), dataModel.getAspect("asp.messwerte")), ReceiveOptions.normal(), ReceiverRole.receiver());
            long startTime = System.nanoTime();
            while (!receiver._connected) {
                receiver.wait(1000L);
                if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) <= 60L) continue;
                MultiDavTestEnvironment.dumpThreads(System.err);
                throw new AssertionError((Object)"Datenverteiler nicht nach 1 Minute verbunden");
            }
        }
        connection.disconnect(false, "");
    }

    public boolean isConnected(String dav1, String dav2) throws Exception {
        return this.isConnected(this.getConnection(dav1), dav2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected(ClientDavInterface connection, String otherDav) throws Exception {
        try {
            Receiver receiver = new Receiver();
            DataModel dataModel = connection.getDataModel();
            Receiver receiver2 = receiver;
            synchronized (receiver2) {
                connection.subscribeReceiver((ClientReceiverInterface)receiver, dataModel.getObject("dav.test." + otherDav), new DataDescription(dataModel.getAttributeGroup("atg.telegrammLaufzeiten"), dataModel.getAspect("asp.messwerte")), ReceiveOptions.normal(), ReceiverRole.receiver());
                long startTime = System.nanoTime();
                while (!receiver._connected) {
                    receiver.wait(1000L);
                    if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) <= 1L) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            connection.disconnect(false, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDisconnected(String dav1, String dav2) throws Exception {
        ClientDavInterface clientDavInterface = this.getConnection(dav1);
        WaitForNoDataReceiver receiver = new WaitForNoDataReceiver();
        DataModel dataModel = clientDavInterface.getDataModel();
        WaitForNoDataReceiver waitForNoDataReceiver = receiver;
        synchronized (waitForNoDataReceiver) {
            clientDavInterface.subscribeReceiver((ClientReceiverInterface)receiver, dataModel.getObject("dav.test." + dav2), new DataDescription(dataModel.getAttributeGroup("atg.distributionspaketReleaseInfo"), dataModel.getAspect("asp.standard")), ReceiveOptions.normal(), ReceiverRole.receiver());
            long startTime = System.nanoTime();
            while (!receiver._noDataReceived) {
                receiver.wait(1000L);
                if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime) > 60L) {
                    throw new AssertionError((Object)"Datenverteiler nicht nach 1 Minute getrennt");
                }
            }
        }
        clientDavInterface.disconnect(false, "");
    }

    public void setDavDavConnectDelay(int davDavConnectDelay) {
        this._davDavConnectDelay = davDavConnectDelay;
    }

    public void setDavDavReconnectDelay(int davDavReconnectDelay) {
        this._davDavReconnectDelay = davDavReconnectDelay;
    }

    private synchronized File getConfigurationFile() throws Exception {
        if (this._globalConfigurationController == null) {
            this._globalConfigurationController = new ConfigurationController(this._testClass.getName(), this.workingDir.resolve("prepare.tmp").toFile().getCanonicalFile());
            this._globalConfigurationController.createConfigurationFile("kb.multiDavTestKonfiguration", this.getConfiguration());
            this._globalConfigurationController.startConfiguration("kv.testKonfiguration");
            this._globalConfigurationController.importConfigurationArea("kb.multiDavTestKonfiguration");
            this._globalConfigurationController.activateConfigurationArea("kb.multiDavTestKonfiguration");
            this._globalConfigurationController.reloadConfiguration();
            this._globalConfigurationController.releaseConfigurationAreaForActivation("kb.multiDavTestKonfiguration");
            this._globalConfigurationController.closeConfiguration();
        }
        return new File(this._globalConfigurationController.getConfigurationPath(), "kb.multiDavTestKonfiguration.config");
    }

    private String getRemoteString(String remoteName) {
        return "localhost:" + this.getExistingDav(remoteName).getAppPort() + ":Lokale_Konfiguration";
    }

    public int nextFreePort() {
        int appPort = this._appPortCounter;
        this._appPortCounter += 2;
        return appPort;
    }

    private String getConfiguration() {
        StringBuilder b = new StringBuilder();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE konfigurationsBereich PUBLIC \"-//K2S//DTD Dokument//DE\" \"K2S.dtd\"><konfigurationsBereich pid=\"kb.multiDavTestKonfiguration\" name=\"DavTestObjekte\" verantwortlich=\"kv.testKonfiguration\"><info><kurzinfo>test</kurzinfo></info><modell></modell><objekte>");
        for (Map.Entry<String, MultiDavStarter> entry : this._starterMap.entrySet()) {
            b.append("<konfigurationsObjekt pid=\"dav.test.").append(entry.getKey()).append("\" name=\"TestDav.").append(entry.getKey()).append("\" typ=\"typ.datenverteiler\"><datensatz attributgruppe=\"atg.datenverteilerEigenschaften\" aspekt=\"asp.eigenschaften\"><datum name=\"adresse\" wert=\"localhost\"/><datum name=\"subAdresse\" wert=\"").append(entry.getValue().getDavPort()).append("\"/></datensatz><objektMenge name=\"Applikationen\" verwaltung=\"kv.");
            if (entry.getValue().getRemoteConf() == null) {
                b.append(entry.getKey());
            } else {
                b.append(entry.getValue().getRemoteConf());
            }
            b.append("\">").append("</objektMenge>").append("</konfigurationsObjekt>");
        }
        for (DavDavConnection connection : this._davConnections) {
            b.append("<konfigurationsObjekt pid=\"davcon.test.").append(connection.getName()).append(".").append(connection.getName2()).append("\" typ=\"typ.datenverteilerVerbindung\"><datensatz attributgruppe=\"atg.datenverteilerTopologie\" aspekt=\"asp.eigenschaften\"><datum name=\"datenverteilerA\" wert=\"dav.test.").append(connection.getName()).append("\"/><datum name=\"datenverteilerB\" wert=\"dav.test.").append(connection.getName2()).append("\"/><datum name=\"wichtung\" wert=\"").append(connection.getWeight()).append("\"/>").append("<datum name=\"aktiverDatenverteiler\" wert=\"").append(connection.getOriginator()).append("\"/>").append("<datum name=\"ersatzverbindungsWartezeit\" wert=\"10 Sekunden\"/>").append("<datum name=\"benutzer1\" wert=\"" + connection.getUser1() + "\"/>").append("<datum name=\"benutzer2\" wert=\"" + connection.getUser2() + "\"/>").append("<datenliste name=\"durchsatzPr\u00fcfung\">").append("<datum name=\"pufferF\u00fcllgrad\" wert=\"75 %\"/>").append("<datum name=\"pr\u00fcfIntervall\" wert=\"3 Minuten\"/>").append("<datum name=\"mindestDurchsatz\" wert=\"3000 Byte/s\"/>").append("</datenliste>").append("</datensatz>");
            if (connection.getReplacementConnections() != null) {
                b.append("<objektMenge name=\"Ersatzverbindungen\">");
                for (String s : connection.getReplacementConnections()) {
                    b.append("<element pid=\"" + s + "\"/>");
                }
                b.append("</objektMenge>");
            }
            b.append("</konfigurationsObjekt>");
        }
        b.append("\t\t<konfigurationsObjekt typ=\"typ.berechtigungsklasseNeu\" name=\"Test\" pid=\"berechtigungsklasse.test\" />\n\t\t<konfigurationsObjekt typ=\"typ.berechtigungsklasseNeu\" name=\"Test2\" pid=\"berechtigungsklasse.test2\" />\n\t\t<konfigurationsObjekt typ=\"typ.berechtigungsklasseNeu\" name=\"Test3\" pid=\"berechtigungsklasse.test3\" />\n\t\t<konfigurationsObjekt typ=\"typ.berechtigungsklasseNeu\" name=\"Test4\" pid=\"berechtigungsklasse.test4\" />\n\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRolleNeu\" name=\"Testrolle\" pid=\"rolle.test\" />\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRolleNeu\" name=\"Testrolle2\" pid=\"rolle.test2\" />\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRolleNeu\" name=\"Testrolle3\" pid=\"rolle.test3\" />\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRolleNeu\" name=\"Testrolle4\" pid=\"rolle.test4\" />\n\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRegionNeu\" name=\"Testregion\" pid=\"region.test\" />\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRegionNeu\" name=\"Testregion2\" pid=\"region.test2\" />\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRegionNeu\" name=\"Testregion3\" pid=\"region.test3\" />\n\t\t<konfigurationsObjekt typ=\"typ.zugriffsRegionNeu\" name=\"Testregion4\" pid=\"region.test4\" />");
        b.append("\t\t<konfigurationsObjekt pid=\"aktivit\u00e4t.davKopplung.anfrage\" name=\"Basis\" typ=\"typ.zugriffsAktivit\u00e4t\">\t\t\t<info>\t\t\t\t<kurzinfo>Aktivit\u00e4t DavKopplung Anfragen ((gerichtete)\t\t\t\t\tKommunikation \u00fcber dem DaV)</kurzinfo>\t\t\t</info>\t\t\t<datensatz attributgruppe=\"atg.zugriffsRechte\" aspekt=\"asp.eigenschaften\">\t\t\t\t<datum name=\"lesen\" wert=\"Ja\"/>\t\t\t\t<datum name=\"schreiben\" wert=\"Ja\"/>\t\t\t\t<datum name=\"quelleSenke\" wert=\"Ja\"/>\t\t\t</datensatz>\t\t\t<objektMenge name=\"Aspekte\">\t\t\t\t<element pid=\"asp.anfrage\"/>\t\t\t\t<element pid=\"asp.information\"/>\t\t\t</objektMenge>\t\t\t<objektMenge name=\"Attributgruppen\">\t\t\t\t<element pid=\"atg.konfigurationsBenutzerverwaltungsAnfrageSchnittstelle\"/>\t\t\t\t<element pid=\"atg.konfigurationsAnfrageSchnittstelleSchreibend\"/>\t\t\t\t<element pid=\"atg.betriebsMeldung\"/>\t\t\t\t<element pid=\"atg.konfigurationsSchreibAnfrage\"/>\t\t\t\t<element pid=\"atg.konfigurationsAnfrage\"/>\t\t\t\t<element pid=\"atg.konfigurationsAnfrageSchnittstelleLesend\"/>\t\t\t\t<element pid=\"atg.konfigurationsBereichsverwaltungsAnfrageSchnittstelle\"/>\t\t\t</objektMenge>\t\t</konfigurationsObjekt>\t\t<konfigurationsObjekt pid=\"aktivit\u00e4t.davKopplung.antwort\" name=\"Basis\" typ=\"typ.zugriffsAktivit\u00e4t\">\t\t\t<info>\t\t\t\t<kurzinfo>Aktivit\u00e4t DavKopplung Antworten((gerichtete)\t\t\t\t\tKommunikation \u00fcber dem DaV)</kurzinfo>\t\t\t</info>\t\t\t<datensatz attributgruppe=\"atg.zugriffsRechte\" aspekt=\"asp.eigenschaften\">\t\t\t\t<datum name=\"lesen\" wert=\"Ja\"/>\t\t\t\t<datum name=\"schreiben\" wert=\"Ja\"/>\t\t\t\t<datum name=\"quelleSenke\" wert=\"Ja\"/>\t\t\t</datensatz>\t\t\t<objektMenge name=\"Aspekte\">\t\t\t\t<element pid=\"asp.antwort\"/>\t\t\t</objektMenge>\t\t\t<objektMenge name=\"Attributgruppen\">\t\t\t\t<element pid=\"atg.konfigurationsBenutzerverwaltungsAnfrageSchnittstelle\"/>\t\t\t\t<element pid=\"atg.konfigurationsAnfrageSchnittstelleSchreibend\"/>\t\t\t\t<element pid=\"atg.konfigurationsAntwort\"/>\t\t\t\t<element pid=\"atg.konfigurationsAnfrageSchnittstelleLesend\"/>\t\t\t\t<element pid=\"atg.konfigurationsBereichsverwaltungsAnfrageSchnittstelle\"/>\t\t\t\t<element pid=\"atg.konfigurationsSchreibAntwort\"/>\t\t\t</objektMenge>\t\t</konfigurationsObjekt>\t\t<konfigurationsObjekt pid=\"aktivit\u00e4t.davKopplung.dav\" name=\"Basis\" typ=\"typ.zugriffsAktivit\u00e4t\">\t\t\t<info>\t\t\t\t<kurzinfo>Aktivit\u00e4t DavKopplung Datenverteiler ((gerichtete)\t\t\t\t\tKommunikation \u00fcber dem DaV)</kurzinfo>\t\t\t</info>\t\t\t<datensatz attributgruppe=\"atg.zugriffsRechte\" aspekt=\"asp.eigenschaften\">\t\t\t\t<datum name=\"lesen\" wert=\"Ja\"/>\t\t\t\t<datum name=\"schreiben\" wert=\"Ja\"/>\t\t\t\t<datum name=\"quelleSenke\" wert=\"Ja\"/>\t\t\t</datensatz>\t\t\t<objektMenge name=\"Aspekte\">\t\t\t\t<element pid=\"asp.standard\"/>\t\t\t\t<element pid=\"asp.messwerte\"/>\t\t\t</objektMenge>\t\t\t<objektMenge name=\"Attributgruppen\">\t\t\t\t<element pid=\"atg.distributionspaketReleaseInfo\"/>\t\t\t\t<element pid=\"atg.applikationsFertigmeldung\"/>\t\t\t\t<element pid=\"atg.datenverteilerRechtepr\u00fcfung\"/>\t\t\t\t<element pid=\"atg.telegrammLaufzeiten\"/>\t\t\t</objektMenge>\t\t</konfigurationsObjekt>\t\t<konfigurationsObjekt pid=\"berechtigungsklasse.davKopplung\" name=\"Basis\" typ=\"typ.berechtigungsklasse\">\t\t\t<info>\t\t\t\t<kurzinfo>Berechtigungsklasse DavKopplung</kurzinfo>\t\t\t</info>\t\t\t<defaultParameter attributgruppe=\"atg.rollenRegionenPaareParameter\" typ=\"typ.berechtigungsklasse\">\t\t\t\t<datenliste name=\"Urlasser\">\t\t\t\t\t<datum name=\"BenutzerReferenz\" wert=\"undefiniert\"/>\t\t\t\t\t<datum name=\"Ursache\" wert=\"\"/>\t\t\t\t\t<datum name=\"Veranlasser\" wert=\"\"/>\t\t\t\t</datenliste>\t\t\t\t<datenfeld name=\"rollenRegionenPaare\">\t\t\t\t\t<datenliste name=\"-\">\t\t\t\t\t\t<datum name=\"rolle\" wert=\"rolle.davKopplung\"/>\t\t\t\t\t\t<datum name=\"region\" wert=\"region.root\"/>\t\t\t\t\t</datenliste>\t\t\t\t</datenfeld>\t\t\t</defaultParameter>\t\t</konfigurationsObjekt>\t\t<konfigurationsObjekt pid=\"rolle.davKopplung\" name=\"Basis\" typ=\"typ.zugriffsRolle\">\t\t\t<info>\t\t\t\t<kurzinfo>Rolle DavKopplung</kurzinfo>\t\t\t</info>\t\t\t<objektMenge name=\"Aktivit\u00e4ten\">\t\t\t\t<element pid=\"aktivit\u00e4t.davKopplung.dav\"/>\t\t\t\t<element pid=\"aktivit\u00e4t.davKopplung.antwort\"/>\t\t\t\t<element pid=\"aktivit\u00e4t.davKopplung.anfrage\"/>\t\t\t</objektMenge>\t\t</konfigurationsObjekt>");
        b.append("</objekte></konfigurationsBereich>");
        this._hasActivated = true;
        return b.toString();
    }

    private String getEmptyConfigurationArea(String name, int authorityCoding, Set<String> additionalUsers) {
        StringBuilder b = new StringBuilder();
        b.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE konfigurationsBereich PUBLIC \"-//K2S//DTD Dokument//DE\" \"K2S.dtd\"><konfigurationsBereich pid=\"kb.kv.").append(name).append("\" name=\"DavTestObjekte\" verantwortlich=\"kv.").append(name).append("\"><info><kurzinfo>test</kurzinfo></info><modell></modell><objekte>");
        b.append("\t\t<konfigurationsObjekt pid=\"kv.").append(name).append("\" name=\"TestKonfiguration.").append(name).append("\" typ=\"typ.autarkeOrganisationsEinheit\">\n\t\t\t<info>\n\t\t\t\t<kurzinfo>Konfigurationsverantwortlicher zum Test des Systems</kurzinfo>\n\t\t\t</info>\n\t\t\t<datensatz attributgruppe=\"atg.konfigurationsVerantwortlicherEigenschaften\" aspekt=\"asp.eigenschaften\">\n\t\t\t\t<datum name=\"kodierung\" wert=\"").append(authorityCoding).append("\"/>\n\t\t\t\t<datenfeld name=\"defaultBereich\">\n\t\t\t\t\t<datum name=\"0\" wert=\"kb.kv.").append(name).append("\"/>\n\t\t\t\t</datenfeld>\n\t\t\t</datensatz>\n\t\t\t<objektMenge name=\"Ereignisse\">\n\t\t\t</objektMenge>\n\t\t\t<objektMenge name=\"SimulationsStrecken\">\n\t\t\t</objektMenge>\n\t\t\t<objektMenge name=\"PuaSkripte\">\n\t\t\t</objektMenge>\n\t\t\t<objektMenge name=\"Simulationen\">\n\t\t\t</objektMenge>\n\t\t\t<objektMenge name=\"Meldungen\">\n\t\t\t</objektMenge>\n\t\t\t<objektMenge name=\"SystemKalenderEintr\u00e4ge\">\n\t\t\t</objektMenge>\n\t\t\t<objektMenge name=\"EreignisTypen\">\n\t\t\t</objektMenge>\n\t\t</konfigurationsObjekt>");
        for (String additionalUser : additionalUsers) {
            b.append("<konfigurationsObjekt typ=\"typ.benutzer\" name=\"").append(additionalUser).append("\" pid=\"benutzer.").append(additionalUser).append("\" />");
        }
        b.append("</objekte></konfigurationsBereich>");
        return b.toString();
    }

    public String toString() {
        return "MultiDavTestEnvironment{_applicationClassName='" + String.valueOf(this._testClass) + "', _configurationDebugLevel='" + this._configurationDebugLevel + "', _transmitterDebugLevel='" + this._transmitterDebugLevel + "', _paramDebugLevel='" + this._paramDebugLevel + "'}";
    }

    public final class MultiDavStarter
    extends SingleDavStarter {
        private final Set<String> _additionalUsers;
        private final Set<String> _importFiles;
        private final int _authorityCoding;
        private final Map<String, Long> _davIdMap;
        private Long overrideTransmitterId;

        private MultiDavStarter(String name, AccessControlMode accessControlType, String[] accessControlPlugIns, int appPort, int davPort) throws Exception {
            this(name, accessControlType, accessControlPlugIns, appPort, davPort, 0, null);
        }

        private MultiDavStarter(String name, AccessControlMode accessControlType, String[] accessControlPlugIns, int appPort, int davPort, int passivePort, String remoteConf) {
            super(name, remoteConf, accessControlPlugIns, accessControlType, appPort, davPort, passivePort, MultiDavTestEnvironment.this._testClass, MultiDavTestEnvironment.this.workingDir.resolve(name));
            this._additionalUsers = new LinkedHashSet<String>();
            this._importFiles = new HashSet<String>();
            this._davIdMap = new HashMap<String, Long>();
            this._authorityCoding = this.getAppPort() - 7000;
            this.setConfigurationDebugLevel(MultiDavTestEnvironment.this._configurationDebugLevel);
            this.setTransmitterDebugLevel(MultiDavTestEnvironment.this._transmitterDebugLevel);
            this.setParamDebugLevel(MultiDavTestEnvironment.this._paramDebugLevel);
        }

        @Override
        protected DaVStarter createDavStarter() throws Exception {
            if (this.getRemoteConf() == null) {
                FileCopy.copyFile(MultiDavTestEnvironment.this.getConfigurationFile(), new File(this._configurationController.getConfigurationPath(), "kb.multiDavTestKonfiguration.config"), false);
                ManagementFile managementFile = this.getManagementFile();
                if (managementFile.getConfigurationAreaManagementInfo("kb.multiDavTestKonfiguration") == null) {
                    managementFile.addConfigurationAreaManagementInfo("kb.multiDavTestKonfiguration");
                    managementFile.close();
                    this._configurationController.createConfigurationFile("kb.kv." + this.getName(), MultiDavTestEnvironment.this.getEmptyConfigurationArea(this.getName(), this.getAuthorityCoding(), this._additionalUsers));
                    this._configurationController.startConfiguration(this.getConfigurationAuthority());
                    this._configurationController.importConfigurationArea("kb.kv." + this.getName());
                    this._configurationController.activateConfigurationAreas(Arrays.asList("kb.multiDavTestKonfiguration", "kb.kv." + this.getName()));
                    this._configurationController.reloadConfiguration();
                    List<String> pids = this._configurationController.importConfigurationAreasWithVersion(this._importFiles);
                    this._configurationController.activateConfigurationAreas(pids);
                    this._configurationController.reloadConfiguration();
                    this._configurationController.releaseConfigurationAreasForActivation(pids);
                    this._configurationController.releaseConfigurationAreaForActivation("kb.kv." + this.getName());
                    DataModel dataModel = this._configurationController.getDataModel();
                    for (MultiDavStarter multiDavStarter : MultiDavTestEnvironment.this._starterMap.values()) {
                        this._davIdMap.put(multiDavStarter.getName(), dataModel.getObject("dav.test." + multiDavStarter.getName()).getId());
                    }
                } else {
                    managementFile.close();
                }
            } else {
                MultiDavStarter remoteDav = MultiDavTestEnvironment.this.getExistingDav(this.getRemoteConf());
                remoteDav.waitUntilReady();
                this._davIdMap.putAll(remoteDav.getDavIdMap());
            }
            long davId = this.getDavId();
            if (this.overrideTransmitterId != null) {
                davId = this.overrideTransmitterId;
            }
            DaVStarter daVStarter = this._configurationController.getDaVStarter(MultiDavTestEnvironment.this._configurationDebugLevel, MultiDavTestEnvironment.this._transmitterDebugLevel, MultiDavTestEnvironment.this._paramDebugLevel, this.getAppPort(), this.getDavPort(), davId, this.getRemoteConf() == null ? null : MultiDavTestEnvironment.this.getRemoteString(this.getRemoteConf()), this.getAccessControlType(), this.getAccessControlPlugIns());
            daVStarter.setPassivePort(this.getPassivePort());
            daVStarter.setName(this.getName());
            daVStarter.setProtocolClass(LocalDavDavConnectionServer.class);
            ArrayList<MultiDavStarter> values = new ArrayList<MultiDavStarter>();
            for (String s : this._davIdMap.keySet()) {
                MultiDavStarter dav = MultiDavTestEnvironment.this.getExistingDav(s);
                values.add(dav);
            }
            MultiDavProtocolParameter multiDavProtocolParameter = new MultiDavProtocolParameter(values.toArray(new DavInformation[0]), this.getName());
            daVStarter.setProtocolParameter(multiDavProtocolParameter);
            daVStarter.setDavDavConnectDelay(MultiDavTestEnvironment.this._davDavConnectDelay);
            daVStarter.setDavDavReconnectDelay(MultiDavTestEnvironment.this._davDavReconnectDelay);
            daVStarter.setDebugName("");
            daVStarter.setClassPath(this.getClassPath());
            daVStarter.setReleaseVersion(this.getReleaseVersion());
            return this.configureDaVStarter(daVStarter);
        }

        public long getDavId() {
            return this._davIdMap.get(this.getName());
        }

        public int getAuthorityCoding() {
            return this._authorityCoding;
        }

        private Map<String, Long> getDavIdMap() {
            return Collections.unmodifiableMap(this._davIdMap);
        }

        private void addConfigurationFiles(String ... pids) throws IOException, ConfigurationChangeException {
            ManagementFile managementFile = this.getManagementFile();
            for (String pid : pids) {
                if (managementFile.getConfigurationAreaManagementInfo(pid) != null) continue;
                managementFile.addConfigurationAreaManagementInfo(pid);
            }
            managementFile.close();
            this._configurationController.startConfiguration(this.getConfigurationAuthority());
            ConsistencyCheckResultInterface result = this._configurationController.activate(pids);
            if (!result.getLocalErrors().isEmpty()) {
                throw new ConfigurationChangeException("Lokale Fehler bei der Konsistenzpr\u00fcfung");
            }
            if (!result.getInterferenceErrors().isEmpty()) {
                throw new ConfigurationChangeException("Interferenzfehler bei der Konsistenzpr\u00fcfung");
            }
            this._configurationController.closeConfiguration();
        }

        @Override
        public ClientDavInterface connect(String user, ClientCredentials password, ClientDavParameters clientDavParameters) {
            ClientDavInterface connection = super.connect(user, password, clientDavParameters);
            MultiDavTestEnvironment.this._connections.add(connection);
            connection.addConnectionListener(MultiDavTestEnvironment.this._connections::remove);
            return connection;
        }

        @Override
        public String getConfigurationAuthority() {
            return "kv." + this.getName();
        }

        @Override
        public void onSuccessfulStart() {
            if (MultiDavTestEnvironment.this._semaphore != null) {
                MultiDavTestEnvironment.this._semaphore.release();
            }
        }

        public void addUsers(String ... userName) {
            this._additionalUsers.addAll((Collection<String>)ImmutableList.copyOf((Object[])userName));
        }

        public void addImportFile(String pid) {
            this._importFiles.add(pid);
        }

        public void setOverrideTransmitterId(Long overrideTransmitterId) {
            this.overrideTransmitterId = overrideTransmitterId;
        }

        public Long getOverrideTransmitterId() {
            return this.overrideTransmitterId;
        }
    }

    private static class DavDavConnection {
        final List<String> _replacementConnections;
        private final String _name;
        private final String _name2;
        private final String _originator;
        private final int _weight;
        private final String _user1;
        private final String _user2;

        public DavDavConnection(String name, String name2, String originator, int weight, @Nullable List<String> replacementConnections, String user1, String user2) {
            this._name = name;
            this._name2 = name2;
            this._originator = originator;
            this._weight = weight;
            this._replacementConnections = replacementConnections;
            this._user1 = user1;
            this._user2 = user2;
        }

        public String getName() {
            return this._name;
        }

        public String getName2() {
            return this._name2;
        }

        public String getOriginator() {
            return this._originator;
        }

        public String toString() {
            return "DavDavConnection{_name='" + this._name + "', _name2='" + this._name2 + "', _originator='" + this._originator + "'}";
        }

        public int getWeight() {
            return this._weight;
        }

        @Nullable
        public List<String> getReplacementConnections() {
            return this._replacementConnections;
        }

        public String getUser1() {
            return this._user1;
        }

        public String getUser2() {
            return this._user2;
        }
    }

    private static class Receiver
    implements ClientReceiverInterface {
        boolean _connected;

        private Receiver() {
        }

        public synchronized void update(ResultData[] results) {
            if (results[results.length - 1].hasData()) {
                this._connected = true;
            }
            this.notifyAll();
        }
    }

    private static class WaitForNoDataReceiver
    implements ClientReceiverInterface {
        boolean _noDataReceived;

        private WaitForNoDataReceiver() {
        }

        public synchronized void update(ResultData[] results) {
            if (!results[results.length - 1].hasData()) {
                this._noDataReceived = true;
            }
            this.notifyAll();
        }
    }
}

