/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.bsvrz.dav.daf.accessControl.AccessControlMode;
import de.bsvrz.dav.daf.main.ApplicationCloseActionHandler;
import de.bsvrz.dav.daf.main.ClientDavConnection;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientDavParameters;
import de.bsvrz.dav.daf.main.NormalCloser;
import de.bsvrz.dav.daf.main.authentication.ClientCredentials;
import de.bsvrz.dav.daf.main.config.management.consistenycheck.ConsistencyCheckResultInterface;
import de.bsvrz.dav.dav.main.Transmitter;
import de.bsvrz.puk.config.main.managementfile.ManagementFile;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.kappich.pat.testumg.util.ConfigurationController;
import de.kappich.pat.testumg.util.CreateClientDavConnection;
import de.kappich.pat.testumg.util.DaVStarter;
import de.kappich.pat.testumg.util.DafApplication;
import de.kappich.pat.testumg.util.DafApplicationEnvironment;
import de.kappich.pat.testumg.util.DavTestEnvironment;
import de.kappich.pat.testumg.util.FakeParamApp;
import de.kappich.pat.testumg.util.ParamAppType;
import de.kappich.pat.testumg.util.ReleaseVersion;
import de.kappich.pat.testumg.util.TempDirectoryCreator;
import de.kappich.pat.testumg.util.UserAccount;
import de.kappich.pat.testumg.util.connections.DavInformation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.junit.Assert;

public class SingleDavStarter
implements DavInformation,
DafApplicationEnvironment {
    protected final ConfigurationController _configurationController;
    private final int _appPort;
    private final int _davPort;
    private final int _passivePort;
    private final String _remoteConf;
    private final String _name;
    private final AccessControlMode _accessControlType;
    private final String[] _accessControlPlugIns;
    private final Object _lock = new Object();
    private int[] _activePorts = new int[0];
    private String[] _classPath;
    private ReleaseVersion _releaseVersion = ReleaseVersion.Current;
    private ImmutableMap<String, ClientCredentials> _authenticationFile;
    private ImmutableList<UserAccount> _userAccounts;
    private String _davUser = "Tester";
    private String _configUser = "configuration";
    private volatile DaVStarter _davStarter;
    private ParamAppType _paramAppType = ParamAppType.NoParamApp;
    private volatile boolean _running;
    private String _configurationDebugLevel = "WARNING";
    private String _transmitterDebugLevel = "WARNING";
    private String _paramDebugLevel = "WARNING";

    public SingleDavStarter() {
        this(AccessControlMode.Disabled, new String[0]);
    }

    public SingleDavStarter(AccessControlMode accessControlType, String ... accessControlPlugIns) {
        this("", null, accessControlPlugIns, accessControlType, 8083 + DaVStarter.getDavPortNumberOffset(), -1, 0);
    }

    public SingleDavStarter(String name, @Nullable String remoteConf, String[] accessControlPlugIns, AccessControlMode accessControlType, int appPort, int davPort, int passivePort) {
        this(name, remoteConf, accessControlPlugIns, accessControlType, appPort, davPort, passivePort, SingleDavStarter.getTestClass(SingleDavStarter.class), TempDirectoryCreator.createTemporaryDirectory().resolve(SingleDavStarter.getTestClass(SingleDavStarter.class).getSimpleName()).resolve(name));
    }

    public SingleDavStarter(String name, @Nullable String remoteConf, String[] accessControlPlugIns, AccessControlMode accessControlType, int appPort, int davPort, int passivePort, Class<?> testClass, Path workingDir) {
        this._name = name;
        this._remoteConf = remoteConf;
        this._accessControlPlugIns = (String[])accessControlPlugIns.clone();
        this._accessControlType = accessControlType;
        this._appPort = appPort;
        this._davPort = davPort;
        this._passivePort = passivePort;
        this._configurationController = new ConfigurationController(testClass.getName(), workingDir.toFile().getAbsoluteFile());
    }

    @NotNull
    public static Class<?> getTestClass(Class<?> testerClass) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        Class<?> testClass = testerClass;
        for (int i = stackTraceElements.length - 1; i >= 0; --i) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            try {
                Class<?> elementClass = Class.forName(stackTraceElement.getClassName());
                if (elementClass.equals(testerClass)) break;
                testClass = elementClass;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return testClass;
    }

    private static InputStream fetchReleaseZip(ReleaseVersion version) throws IOException {
        Path cacheFile = Paths.get("cache", version.toString() + ".zip");
        Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
        if (!Files.exists(cacheFile, new LinkOption[0])) {
            URL url = version.getUrl();
            if (url == null) {
                throw new IllegalArgumentException("ReleaseVersion ohne URL");
            }
            System.out.println("Lade " + String.valueOf(url));
            Files.copy(url.openStream(), cacheFile, new CopyOption[0]);
        } else {
            System.out.println("Verwende gecachte Version von " + String.valueOf((Object)version));
        }
        return Files.newInputStream(cacheFile, new OpenOption[0]);
    }

    private static void addResourceNames(ArrayList<String> resourceNames, Path directory, String resourceNamePrefix) {
        Stream<Path> files;
        try {
            files = Files.list(directory);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        files.forEach(subFile -> {
            String resourceName = resourceNamePrefix + String.valueOf(subFile.getFileName());
            if (Files.isDirectory(subFile, new LinkOption[0])) {
                SingleDavStarter.addResourceNames(resourceNames, subFile, resourceName + "/");
            } else {
                resourceNames.add(resourceName);
            }
        });
    }

    public final String getConfigurationDebugLevel() {
        return this._configurationDebugLevel;
    }

    public final void setConfigurationDebugLevel(String configurationDebugLevel) {
        this._configurationDebugLevel = configurationDebugLevel;
    }

    public final String getTransmitterDebugLevel() {
        return this._transmitterDebugLevel;
    }

    public final void setTransmitterDebugLevel(String transmitterDebugLevel) {
        this._transmitterDebugLevel = transmitterDebugLevel;
    }

    public final String getParamDebugLevel() {
        return this._paramDebugLevel;
    }

    public final void setParamDebugLevel(String paramDebugLevel) {
        this._paramDebugLevel = paramDebugLevel;
    }

    public final boolean isRunning() {
        return this._running;
    }

    private DaVStarter getDavStarter() {
        if (this._davStarter == null) {
            try {
                this._davStarter = this.createDavStarter();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        return this._davStarter;
    }

    protected DaVStarter createDavStarter() throws Exception {
        DaVStarter daVStarter = this._configurationController.getDaVStarter(this._configurationDebugLevel, this._transmitterDebugLevel, this._paramDebugLevel, this._appPort, this._davPort, 10001L, null, this.getAccessControlType(), this.getAccessControlPlugIns());
        daVStarter.setPassivePort(this._passivePort);
        daVStarter.setName(this.getName());
        daVStarter.setDebugName("");
        daVStarter.setClassPath(this.getClassPath());
        daVStarter.setReleaseVersion(this.getReleaseVersion());
        return this.configureDaVStarter(daVStarter);
    }

    @NotNull
    protected final DaVStarter configureDaVStarter(DaVStarter daVStarter) throws IOException {
        if (this.getReleaseVersion() != ReleaseVersion.Current) {
            this.prepareClassPath(daVStarter);
        }
        if (this._authenticationFile != null) {
            Properties properties = new Properties();
            for (Map.Entry entry : this._authenticationFile.entrySet()) {
                properties.setProperty((String)entry.getKey(), ((ClientCredentials)entry.getValue()).toString());
            }
            properties.store(Files.newBufferedWriter(daVStarter.getWorkingDirectory().toPath().resolve("passwd.properties"), new OpenOption[0]), null);
        }
        if (this._userAccounts != null) {
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(daVStarter.getWorkingDirectory().toPath().resolve("benutzerverwaltung.xml"), StandardCharsets.ISO_8859_1, new OpenOption[0]);){
                bufferedWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\"?>\n");
                bufferedWriter.write("<!DOCTYPE benutzerkonten PUBLIC \"-//K2S//DTD Authentifizierung//DE\" \"authentication.dtd\">\n");
                bufferedWriter.write("<benutzerkonten>\n");
                for (UserAccount account : this._userAccounts) {
                    bufferedWriter.write("    <benutzeridentifikation admin=\"" + (account.isAdmin() ? "ja" : "nein") + "\" name=\"" + account.getName() + "\" passwort=\"" + account.getPassword() + "\">\n");
                    List<String> oneTimePasswords = account.getOneTimePasswords();
                    for (int i = 0; i < oneTimePasswords.size(); ++i) {
                        String s = oneTimePasswords.get(i);
                        bufferedWriter.write("        <autorisierungspasswort passwort=\"" + s + "\" passwortindex=\"" + i + "\" gueltig=\"ja\" />\n");
                    }
                    bufferedWriter.write("    </benutzeridentifikation>\n");
                }
                bufferedWriter.write("</benutzerkonten>\n");
            }
        }
        daVStarter.setUserNameTransmitter(this._davUser);
        daVStarter.setUserNameConfiguration(this._configUser);
        daVStarter.setActivePorts(Arrays.stream(this.getActivePorts()).boxed().collect(Collectors.toList()));
        return daVStarter;
    }

    private void prepareClassPath(DaVStarter daVStarter) throws IOException {
        ArrayList<String> paths;
        Path releaseDir = Files.createDirectories(Paths.get("releases", this.getReleaseVersion().toString()), new FileAttribute[0]);
        try (ZipInputStream outerStream = new ZipInputStream(SingleDavStarter.fetchReleaseZip(this.getReleaseVersion()));){
            ZipEntry outerEntry;
            paths = new ArrayList<String>();
            if (this.getClassPath() != null) {
                Collections.addAll(paths, this.getClassPath());
            }
            while ((outerEntry = outerStream.getNextEntry()) != null) {
                ZipEntry innerEntry;
                if (outerEntry.isDirectory()) continue;
                ZipInputStream innerStream = new ZipInputStream(outerStream);
                while ((innerEntry = innerStream.getNextEntry()) != null) {
                    Path innerFilePath = releaseDir.resolve(innerEntry.getName());
                    if (innerEntry.isDirectory()) {
                        Files.createDirectories(innerFilePath, new FileAttribute[0]);
                        continue;
                    }
                    Files.copy(innerStream, innerFilePath, StandardCopyOption.REPLACE_EXISTING);
                    if (!innerFilePath.toString().endsWith("runtime.jar")) continue;
                    paths.add(innerFilePath.toString());
                }
            }
        }
        daVStarter.setClassPath(paths.toArray(new String[0]));
    }

    public <T> DafApplication<T> createApplication(Function<String[], T> creator, List<String> args) {
        return this.createApplication(creator, args, "Tester");
    }

    public <T> DafApplication<T> createApplication(Function<String[], T> creator, List<String> args, String user) {
        return new DafApplication<T>(this, creator, args, user);
    }

    public <T extends StandardApplication> DafApplication<T> createStandardApplication(T application, List<String> args) {
        return this.createStandardApplication(application, args, "Tester");
    }

    public <T extends StandardApplication> DafApplication<T> createStandardApplication(T application, List<String> args, String user) {
        return this.createApplication(strings -> {
            try {
                ArgumentList argumentList = new ArgumentList(strings);
                ClientDavParameters parameters = new ClientDavParameters(argumentList);
                parameters.setApplicationTypePid("typ.applikation");
                parameters.setApplicationName("");
                application.parseArguments(argumentList);
                argumentList.ensureAllArgumentsUsed();
                ClientDavConnection connection = new ClientDavConnection(parameters);
                connection.setCloseHandler((ApplicationCloseActionHandler)new NormalCloser());
                connection.enableExplicitApplicationReadyMessage();
                connection.connect();
                connection.login();
                MessageSender.getInstance().init((ClientDavInterface)connection, "", "");
                application.initialize((ClientDavInterface)connection);
                connection.sendApplicationReadyMessage();
                return application;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }, args, user);
    }

    @Override
    public String getAddress() {
        return "localhost.localdomain";
    }

    @Override
    public final int getPort() {
        return this.getDavPort();
    }

    @Override
    public final int getAppPort() {
        return this._appPort;
    }

    public int getDavPort() {
        return this._davPort;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void startWithoutWaiting() {
        if (this._running) {
            throw new IllegalStateException("Datenverteiler l\u00e4uft bereits");
        }
        final Thread callingThread = Thread.currentThread();
        Thread thread = new Thread(this._name + "_starter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = SingleDavStarter.this._lock;
                    synchronized (object) {
                        SingleDavStarter.this._running = true;
                        SingleDavStarter.this._lock.notifyAll();
                        if (SingleDavStarter.this._davStarter == null) {
                            SingleDavStarter.this._davStarter = SingleDavStarter.this.getDavStarter();
                        }
                        if (SingleDavStarter.this.getClassPath() != null || SingleDavStarter.this.getReleaseVersion() != ReleaseVersion.Current) {
                            SingleDavStarter.this._davStarter.startTransmitter();
                            if (SingleDavStarter.this.getRemoteConf() == null) {
                                SingleDavStarter.this._davStarter.startConfiguration();
                            }
                            SingleDavStarter.this._davStarter.startParam(SingleDavStarter.this._paramAppType);
                        } else {
                            SingleDavStarter.this._davStarter.startTransmitterInSameProcess(SingleDavStarter.this.getRemoteConf() == null, SingleDavStarter.this._paramAppType);
                        }
                        SingleDavStarter.this._lock.notifyAll();
                        SingleDavStarter.this.onSuccessfulStart();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    callingThread.interrupt();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected void onSuccessfulStart() {
    }

    public void stop() {
        this._running = false;
        if (this._davStarter != null) {
            this._davStarter.stopDavWithoutSleep(false);
        }
        this._davStarter = null;
    }

    @Deprecated
    public void stopWithoutFileDeletion() {
        this.stop();
    }

    @Override
    public ClientDavInterface connect() {
        return this.connect("Tester", ClientCredentials.ofString((String)"geheim"));
    }

    public ClientDavInterface connect(ClientDavParameters clientDavParameters) {
        return this.connect("Tester", ClientCredentials.ofString((String)"geheim"), clientDavParameters);
    }

    public ClientDavInterface connect(String user, ClientCredentials password) {
        return this.connect(user, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDavInterface connect(String user, ClientCredentials password, @Nullable ClientDavParameters clientDavParameters) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Datenverteiler wurde noch nicht gestartet.");
        }
        Object object = this._lock;
        synchronized (object) {
            while (this._davStarter == null) {
                try {
                    this._lock.wait();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            return new CreateClientDavConnection(user, password, null, clientDavParameters, "localhost", this._davStarter.getDavAppPort()).getConnection();
        }
    }

    @Nullable
    public Transmitter getTransmitter() {
        if (this._davStarter == null) {
            return null;
        }
        return this._davStarter.getTransmitterObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FakeParamApp getFakeParamApp() {
        Object object = this._lock;
        synchronized (object) {
            return this.getDavStarter().getFakeParamApp();
        }
    }

    @Override
    public String getConfigurationAuthority() {
        return "kv.testKonfiguration";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReady() {
        for (int i = 0; i < 10; ++i) {
            Object object = this._lock;
            synchronized (object) {
                try {
                    this._lock.wait(100L);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                if (this.isRunning()) {
                    break;
                }
                continue;
            }
        }
        if (!this.isRunning()) {
            throw new IllegalStateException("Datenverteiler wurde noch nicht gestartet.");
        }
        Object object = this._lock;
        synchronized (object) {
            while (this._davStarter == null) {
                try {
                    this._lock.wait();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    public String toString() {
        return "SingleDavStarter{}";
    }

    @Override
    public Path getWorkingDirectory() {
        try {
            return this.getDavStarter().getWorkingDirectory().toPath();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Path getRootDir() {
        return this.getWorkingDirectory().getParent();
    }

    @Override
    public void setParamAppType(ParamAppType paramAppType) {
        if (paramAppType == null) {
            throw new IllegalArgumentException("paramAppType ist null");
        }
        this._paramAppType = paramAppType;
    }

    public ManagementFile getManagementFile() {
        return new ManagementFile(this.getAdminFile());
    }

    private File getAdminFile() {
        return this._configurationController.getAdminFile();
    }

    public SingleDavStarter withClassPath(String ... classPath) {
        this._classPath = (String[])classPath.clone();
        return this;
    }

    public SingleDavStarter withReleaseVersion(ReleaseVersion version) {
        Objects.requireNonNull(version, "version == null");
        this._releaseVersion = version;
        return this;
    }

    public SingleDavStarter withParam(ParamAppType paramAppType) {
        if (paramAppType == null) {
            throw new IllegalArgumentException("paramAppType ist null");
        }
        this._paramAppType = paramAppType;
        return this;
    }

    public ImmutableMap<String, ClientCredentials> getAuthenticationFile() {
        return this._authenticationFile;
    }

    public void setAuthenticationFile(Map<String, ClientCredentials> authenticationFile) {
        this._authenticationFile = ImmutableMap.copyOf(authenticationFile);
    }

    public List<UserAccount> getUserAccounts() {
        return this._userAccounts;
    }

    public void setUserAccounts(UserAccount ... userAccounts) {
        this._userAccounts = ImmutableList.copyOf((Object[])userAccounts);
    }

    public String getDavUser() {
        return this._davUser;
    }

    public void setDavUser(String davUser) {
        this._davUser = davUser;
    }

    public String getConfigUser() {
        return this._configUser;
    }

    public void setConfigUser(String configUser) {
        this._configUser = configUser;
    }

    public void start(String ... configurationAreas) {
        this.getDavStarter();
        if (configurationAreas.length > 0) {
            this.activate(configurationAreas);
        }
        this.startWithoutWaiting();
        this.waitUntilReady();
    }

    public void activate(String ... configurationAreaPids) {
        this.activate(false, configurationAreaPids);
    }

    public void activateAndReleaseForActivation(String ... configurationAreaPids) {
        this.activate(true, configurationAreaPids);
    }

    private void activate(boolean release, String ... configurationAreaPids) {
        this.getDavStarter();
        ConfigurationController configurationController = this._configurationController;
        ArrayList<String> pidsWithVersion = new ArrayList<String>();
        for (int i = 0; i < configurationAreaPids.length; ++i) {
            String configurationAreaPid = configurationAreaPids[i];
            if (configurationAreaPid != null) {
                pidsWithVersion.add(configurationAreaPid);
            }
            if (configurationAreaPid == null || i == configurationAreaPids.length - 1 && !pidsWithVersion.isEmpty()) {
                try {
                    System.out.println("Konfigurationsbereiche werden importiert und aktiviert: " + String.valueOf(pidsWithVersion));
                    configurationController.startConfiguration(this.getConfigurationAuthority());
                    List<String> pids = configurationController.importConfigurationAreasWithVersion(pidsWithVersion);
                    ConsistencyCheckResultInterface result = configurationController.activateConfigurationAreas(pids);
                    if (result.interferenceErrors() || result.localError()) {
                        Assert.fail((String)("Fehler beim aktivieren der Konfigurationsbereiche:\n" + result.toString()));
                    }
                    if (release) {
                        configurationController.reloadConfiguration();
                        configurationController.releaseConfigurationAreasForActivation(pids);
                    }
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                finally {
                    configurationController.closeConfiguration();
                }
            }
            if (configurationAreaPid != null) continue;
            pidsWithVersion.clear();
        }
    }

    public String getRemoteConf() {
        return this._remoteConf;
    }

    public AccessControlMode getAccessControlType() {
        return this._accessControlType;
    }

    public String[] getAccessControlPlugIns() {
        return (String[])this._accessControlPlugIns.clone();
    }

    @Nullable
    public String[] getClassPath() {
        return this._classPath == null ? null : (String[])this._classPath.clone();
    }

    public ReleaseVersion getReleaseVersion() {
        return this._releaseVersion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Path copyResources(String resourceNamePrefix, String destinationDirectoryName) {
        if (!((String)resourceNamePrefix).endsWith("/")) {
            resourceNamePrefix = (String)resourceNamePrefix + "/";
        }
        try {
            Path destinationDirectory = this.getWorkingDirectory().resolve(destinationDirectoryName);
            ArrayList<String> resourceNames = new ArrayList<String>();
            URL startResource = DavTestEnvironment.class.getClassLoader().getResource((String)resourceNamePrefix);
            Path path = null;
            try {
                path = Paths.get(startResource.toURI());
            }
            catch (FileSystemNotFoundException fileSystemNotFoundException) {
                // empty catch block
            }
            if (path != null && Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) throw new IllegalArgumentException("Kopieren von Resourcen nicht m\u00f6glich, da die angegebenen Resource '" + (String)resourceNamePrefix + "' kein Verzeichnis ist.");
                SingleDavStarter.addResourceNames(resourceNames, path, (String)resourceNamePrefix);
            } else {
                URLConnection connection = startResource.openConnection();
                if (!(connection instanceof JarURLConnection)) throw new IllegalArgumentException("Kopieren von Resourcen nicht m\u00f6glich, da '" + String.valueOf(connection) + "' keine JarURLConnection ist.");
                JarURLConnection jarURLConnection = (JarURLConnection)connection;
                JarFile jarFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    String entryname = entry.getName();
                    if (entry.isDirectory() || !entryname.startsWith((String)resourceNamePrefix)) continue;
                    resourceNames.add(entryname);
                }
            }
            int resourceNamePrefixLength = ((String)resourceNamePrefix).length();
            for (String resourceName : resourceNames) {
                URL resource = DavTestEnvironment.class.getClassLoader().getResource(resourceName);
                InputStream sourceInput = resource.openStream();
                try {
                    String localName = resourceName.substring(resourceNamePrefixLength);
                    Path destinationFile = destinationDirectory.resolve(localName);
                    Files.createDirectories(destinationFile.getParent(), new FileAttribute[0]);
                    Files.copy(sourceInput, destinationFile, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (sourceInput == null) continue;
                    sourceInput.close();
                }
            }
            return destinationDirectory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._running) {
            this.stop();
            System.err.println(String.valueOf(this) + " wurde nicht korrekt vom Test gestoppt.");
        }
    }

    public int getPassivePort() {
        return this._passivePort;
    }

    public int[] getActivePorts() {
        return (int[])this._activePorts.clone();
    }

    public void setActivePorts(int ... activePorts) {
        this._activePorts = (int[])activePorts.clone();
    }
}

