/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TempDirectoryCreator {
    private static final List<Path> _temporaryDirectories = new CopyOnWriteArrayList<Path>();
    private static final Thread _cleaner = new Thread(){

        @Override
        public void run() {
            for (Path temporaryDirectory : _temporaryDirectories) {
                try {
                    TempDirectoryCreator.deletePath(temporaryDirectory);
                }
                catch (Throwable e) {
                    System.err.println("Konnte " + String.valueOf(temporaryDirectory) + " nicht l\u00f6schen.");
                    e.printStackTrace();
                }
            }
        }
    };

    private TempDirectoryCreator() {
        throw new UnsupportedOperationException();
    }

    public static Path createTemporaryDirectory() {
        Path path = TempDirectoryCreator.createTemporaryDirectoryInternal();
        _temporaryDirectories.add(path);
        return path;
    }

    private static Path createTemporaryDirectoryInternal() {
        try {
            String basePath = System.getProperty("testbasepath", null);
            if (basePath == null) {
                return Files.createTempDirectory("test", new FileAttribute[0]);
            }
            return Files.createTempDirectory(Paths.get(basePath, new String[0]), "test", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void deletePath(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        Runtime.getRuntime().addShutdownHook(_cleaner);
    }
}

