/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util.connections;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DelayOutputStream
extends OutputStream {
    public static volatile boolean DISABLE_DELAY;
    private final OutputStream _inner;
    private final ArrayBlockingQueue<ByteArray> _queue = new ArrayBlockingQueue(128);
    private final int _maxPacketSize;
    private final long _transmissionDelayNanos;
    private long _minPacketDelayMillis;
    private Thread _thread;

    public DelayOutputStream(OutputStream outputStream, long transmissionDelayNanos, double maxFlowRate) {
        this._inner = outputStream;
        this._transmissionDelayNanos = transmissionDelayNanos;
        if (maxFlowRate >= 1.0E9) {
            this._minPacketDelayMillis = 0L;
            this._maxPacketSize = Integer.MAX_VALUE;
        } else {
            this._minPacketDelayMillis = Math.max(TimeUnit.NANOSECONDS.toMillis(transmissionDelayNanos), 4L);
            double packetSizeTmp = maxFlowRate * (double)this._minPacketDelayMillis / 1000.0;
            while (packetSizeTmp < 128.0) {
                this._minPacketDelayMillis *= 2L;
                packetSizeTmp = maxFlowRate * (double)this._minPacketDelayMillis / 1000.0;
            }
            this._maxPacketSize = (int)packetSizeTmp;
        }
        this._thread = new Thread("DelayOutputStream[" + String.valueOf(outputStream) + "]"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (!this.isInterrupted()) {
                        ByteArray byteArray = DelayOutputStream.this._queue.take();
                        if (!DISABLE_DELAY) {
                            long d = byteArray.getExpires() - System.nanoTime();
                            while (d > 0L) {
                                Thread.sleep(TimeUnit.NANOSECONDS.toMillis(d));
                                d = byteArray.getExpires() - System.nanoTime();
                            }
                        }
                        DelayOutputStream.this._inner.write(byteArray.getBytes());
                        if (DISABLE_DELAY) continue;
                        Thread.sleep(DelayOutputStream.this._minPacketDelayMillis);
                    }
                }
                catch (IOException | InterruptedException exception) {
                }
                finally {
                    DelayOutputStream.this.close();
                }
            }
        };
        this._thread.start();
    }

    @Override
    public void close() {
        try {
            this._inner.close();
            this._thread.interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.enqueue(bytes);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.enqueue((byte[])b.clone());
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.enqueue(Arrays.copyOfRange(b, off, off + len));
    }

    protected void enqueue(byte[] bytes) throws IOException {
        if (bytes.length < this._maxPacketSize) {
            try {
                this._queue.put(new ByteArray(bytes));
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        } else {
            for (int s = 0; s < bytes.length; s += this._maxPacketSize) {
                try {
                    this._queue.put(new ByteArray(Arrays.copyOfRange(bytes, s, Math.min(s + this._maxPacketSize, bytes.length))));
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    private class ByteArray {
        private final byte[] _bytes;
        private final long _expires;

        public ByteArray(byte[] bytes) {
            this._bytes = bytes;
            this._expires = System.nanoTime() + DelayOutputStream.this._transmissionDelayNanos;
        }

        private byte[] getBytes() {
            return this._bytes;
        }

        private long getExpires() {
            return this._expires;
        }
    }
}

