/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util.connections;

import de.bsvrz.dav.daf.communication.lowLevel.ConnectionInterface;
import de.bsvrz.dav.daf.communication.tcpCommunication.TCP_IP_Communication;
import de.bsvrz.dav.daf.main.ConnectionException;
import de.kappich.pat.testumg.util.connections.DelayOutputStream;
import de.kappich.pat.testumg.util.connections.MultiDavProtocolParameter;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class LocalDavDavConnection
implements ConnectionInterface {
    static final Set<LocalDavDavConnection> _localDavDavConnections = new CopyOnWriteArraySet<LocalDavDavConnection>();
    private static final Set<String> DISABLED_CONNECTIONS = new CopyOnWriteArraySet<String>();
    private static final Map<String, ConnectionDelayInformation> CONNECTION_DELAYS = new ConcurrentHashMap<String, ConnectionDelayInformation>();
    private final TCP_IP_Communication _communication;
    private final MultiDavProtocolParameter _parameters;
    private int _subAdressNumber;

    public LocalDavDavConnection(Socket socket, String parameters) {
        this._parameters = new MultiDavProtocolParameter(parameters);
        this._communication = new TCP_IP_Communication(socket);
        _localDavDavConnections.add(this);
    }

    public LocalDavDavConnection(String parameters) {
        this._parameters = new MultiDavProtocolParameter(parameters);
        this._communication = new TCP_IP_Communication();
        _localDavDavConnections.add(this);
    }

    public LocalDavDavConnection() {
        this._parameters = new MultiDavProtocolParameter("");
        this._communication = new TCP_IP_Communication();
    }

    public static void disableConnection(String davName, int targetPort) {
        DISABLED_CONNECTIONS.add(LocalDavDavConnection.makeAdressKey(davName, targetPort));
        for (LocalDavDavConnection connection : _localDavDavConnections) {
            connection.refreshEnabled();
        }
    }

    public static void enableConnection(String davName, int targetPort) {
        DISABLED_CONNECTIONS.remove(LocalDavDavConnection.makeAdressKey(davName, targetPort));
        for (LocalDavDavConnection connection : _localDavDavConnections) {
            connection.refreshEnabled();
        }
    }

    public static void setConnectionDelay(String fromDav, int toPort, long transmissionDelay, double maxFlowRate) {
        CONNECTION_DELAYS.put(fromDav + ":" + toPort, new ConnectionDelayInformation(maxFlowRate, transmissionDelay));
    }

    private static String makeAdressKey(String davName, int targetPort) {
        return davName + ":" + targetPort;
    }

    public static void enableAll() {
        DISABLED_CONNECTIONS.clear();
        for (LocalDavDavConnection connection : _localDavDavConnections) {
            connection.refreshEnabled();
        }
        _localDavDavConnections.clear();
    }

    public String getMainAdress() {
        return this._communication.getMainAdress();
    }

    public int getSubAdressNumber() {
        return this._communication.getSubAdressNumber();
    }

    public OutputStream getOutputStream() {
        ConnectionDelayInformation delayInformation = CONNECTION_DELAYS.get(this._parameters.getMyName() + ":" + this._communication.getSubAdressNumber());
        if (delayInformation == null) {
            return this._communication.getOutputStream();
        }
        return new DelayOutputStream(this._communication.getOutputStream(), delayInformation.getTransmissionDelay(), delayInformation.getMaxFlowRate());
    }

    public String toString() {
        return this._parameters.getMyName() + ">" + this._parameters.getOtherName(this._communication.getMainAdress(), this._communication.getSubAdressNumber());
    }

    public InputStream getInputStream() {
        return this._communication.getInputStream();
    }

    public void connect(String mainAddress, int subAddressNumber) throws ConnectionException {
        this._subAdressNumber = subAddressNumber;
        if (DISABLED_CONNECTIONS.contains(LocalDavDavConnection.makeAdressKey(this._parameters.getMyName(), subAddressNumber))) {
            throw new ConnectionException("Verbindung derzeit deaktiviert");
        }
        this._communication.connect(mainAddress, subAddressNumber);
    }

    public void disconnect() {
        this._communication.disconnect();
    }

    public boolean isConnected() {
        return this._communication.isConnected();
    }

    public boolean isLoopback() {
        return this._communication.isLoopback();
    }

    private void refreshEnabled() {
        boolean disabled = DISABLED_CONNECTIONS.contains(LocalDavDavConnection.makeAdressKey(this._parameters.getMyName(), this._subAdressNumber));
        if (disabled && this._communication.isConnected()) {
            this._communication.disconnect();
        }
    }

    private static final class ConnectionDelayInformation {
        private final long _transmissionDelay;
        private final double _maxFlowRate;

        private ConnectionDelayInformation(double maxFlowRate, long transmissionDelay) {
            this._maxFlowRate = maxFlowRate;
            this._transmissionDelay = transmissionDelay;
        }

        private long getTransmissionDelay() {
            return this._transmissionDelay;
        }

        private double getMaxFlowRate() {
            return this._maxFlowRate;
        }
    }
}

