/*
 * Decompiled with CFR 0.152.
 */
package de.kappich.pat.testumg.util.connections;

import de.kappich.pat.testumg.util.connections.DavInformation;
import java.util.ArrayList;

public class MultiDavProtocolParameter {
    private final DavInformation[] _davInformations;
    private final String _myName;

    public MultiDavProtocolParameter(DavInformation[] davInformations, String myName) {
        this._davInformations = davInformations;
        this._myName = myName;
    }

    public MultiDavProtocolParameter(String s) {
        int start = 0;
        int end = s.indexOf(35, start);
        if (end == -1) {
            this._myName = "";
            this._davInformations = new DavInformation[0];
            return;
        }
        this._myName = s.substring(0, end);
        start = end + 1;
        ArrayList<MyDavInformation> result = new ArrayList<MyDavInformation>();
        while ((end = s.indexOf(35, start)) != -1) {
            result.add(new MyDavInformation(s.substring(start, end)));
            start = end + 1;
        }
        this._davInformations = result.toArray(new DavInformation[0]);
    }

    public String getMyName() {
        return this._myName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._myName).append("#");
        for (DavInformation davInformation : this._davInformations) {
            stringBuilder.append(davInformation.getName()).append(":");
            stringBuilder.append(davInformation.getAddress()).append(":");
            stringBuilder.append(davInformation.getPort()).append("#");
        }
        return stringBuilder.toString();
    }

    public String getOtherName(String address, int port) {
        for (DavInformation davInformation : this._davInformations) {
            if (!davInformation.getAddress().equals(address) || davInformation.getPort() != port) continue;
            return davInformation.getName();
        }
        return address + ":" + port;
    }

    public boolean has(String address, int port) {
        for (DavInformation davInformation : this._davInformations) {
            if (!davInformation.getAddress().equals(address) || davInformation.getPort() != port) continue;
            return true;
        }
        return false;
    }

    public static class MyDavInformation
    implements DavInformation {
        private int _port;
        private String _address;
        private String _name;

        public MyDavInformation(String s) {
            String[] split = s.split(":");
            this._name = split[0];
            this._address = split[1];
            this._port = Integer.parseInt(split[2]);
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getAddress() {
            return this._address;
        }

        @Override
        public int getPort() {
            return this._port;
        }
    }
}

