/*
 * Copyright 2013-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.sys.funclib.csv.
 *
 * de.kappich.sys.funclib.csv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.sys.funclib.csv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.kappich.sys.funclib.csv; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.sys.funclib.csv;

/**
 * Interface für Formate, die aus CSV-Einträgen geparst werden können. Ein String wird aus einer Csv-Datei eingelesen und in das mit T spezifizierte
 * Format umgewandelt.
 *
 * @author Kappich Systemberatung
 * @see CsvIntegerParser
 * @see CsvStringParser
 */
public interface CsvParser<T> {

    /**
     * Wandelt den übergebenen String in das Format T um
     *
     * @param s String aus der Csv-Datei
     *
     * @return Wert, der geparst wurde
     *
     * @throws IllegalArgumentException Falls der String ein ungültiges Format hat
     */
    public T parseString(String s) throws IllegalArgumentException;

}
