/*
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.areaPlugin;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.colorManagement.ColorManager;
import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.displayObjectToolkit.DynamicDOTItem;
import de.kappich.pat.gnd.displayObjectToolkit.PrimitiveFormPropertyPair;
import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType.DisplayObjectTypeItem;
import de.kappich.pat.gnd.properties.ColorProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;

/**
 * Der Painter für Flächenobjekte.
 *
 * @author Kappich Systemberatung
 */
@SuppressWarnings("serial")
public class DOTAreaPainter extends JPanel implements DisplayObjectPainter {

    @Override
    public void paintDisplayObject(MapPane mapPane, Graphics2D g2D, DisplayObject displayObject, boolean selected) {
        DisplayObjectType dot = displayObject.getDOTCollection().getDisplayObjectType(mapPane.getMapScale().intValue());
	    if (!(dot instanceof DOTArea dotArea)) {
            return;
        }
        final Color color;
        if (dotArea.isPropertyStatic(null, ColorProperty.getInstance())) {
            Object propertyValue = dotArea.getValueOfStaticProperty(null, ColorProperty.getInstance());
            if (propertyValue != null && propertyValue instanceof String) {
                color = ColorManager.getInstance().getColor((String) propertyValue);
            } else {
                color = ColorManager.getInstance().getColor("keine");
            }
        } else {
            final PrimitiveFormPropertyPair primitiveFormPropertyPair = new PrimitiveFormPropertyPair(null, ColorProperty.getInstance());
            final DisplayObjectTypeItem displayObjectTypeItem = displayObject.getDisplayObjectTypeItem(primitiveFormPropertyPair);
            if (displayObjectTypeItem == null) {
                return;
            }
            final Object propertyValue = displayObjectTypeItem.getPropertyValue();
            if (propertyValue != null && propertyValue instanceof String) {
                color = ColorManager.getInstance().getColor((String) propertyValue);
            } else if (Objects.equals(displayObjectTypeItem, DynamicDOTItem.NO_DATA_ITEM)) {
                color = ColorManager.getInstance().getColor("keine");
            } else if (Objects.equals(displayObjectTypeItem, DynamicDOTItem.NO_SOURCE_ITEM)) {
                color = ColorManager.getInstance().getColor("keine");
            } else {
                color = ColorManager.getInstance().getColor("keine");
            }
            // Die letzten drei Fälle werden noch gleichbehandelt, aber bei einer kommenden
            // Erweiterung muss hier unterschieden werden.
        }

        if (!selected) {
            g2D.setColor(color);
            g2D.setStroke(new BasicStroke(1.f));
        } else {
            if (color != null) {
                g2D.setColor(color.darker());
            }
            g2D.setStroke(new BasicStroke(3.f));
        }
        for (Object o : displayObject.getCoordinates(0)) {
	        if (o instanceof Polygon polygon) {
                g2D.fill(polygon);
            }
        }
        displayObject.setDefaultType(0);
    }

    @Override
    @Nullable
    public Rectangle getBoundingRectangle(DisplayObject displayObject, int type) {
        Rectangle rect = null;
        for (Object o : displayObject.getCoordinates(type)) {
	        if (o instanceof Polygon polygon) {
                if (rect == null) {
                    rect = polygon.getBounds();
                } else {
                    rect.add(polygon.getBounds());
                }
            }
        }
        return rect;
    }

    @Override
    public List<Object> getCoordinates(List<Object> coordinates, int type) {
        return coordinates;
    }
}
