/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.choose;

import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.documentation.GndHelp;
import de.kappich.pat.gnd.gnd.GenericNetDisplay;
import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.utils.view.GndDialog;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

/**
 * Dieser Dialog gestattet es dem Benutzer {@link DisplayObject DisplayObjects} auszuwählen, die dann an die {@link GenericNetDisplay}-Instanz
 * übergeben werden.
 *
 * @author Kappich Systemberatung
 */
public class ChooseFromDialog extends GndDialog {

    private final GenericNetDisplay _genericNetDisplay;
    private final JButton _chooseButton = new JButton("Gehe zu");
    private final JButton _helpButton = new JButton("Hilfe");
    private DisplayObjectSelectionList _selectionList;

    public ChooseFromDialog(final GenericNetDisplay genericNetDisplay, final Collection<DisplayObject> displayObjects) {
        super("ChooseFromDialog", genericNetDisplay.getFrame(), false);
        _genericNetDisplay = genericNetDisplay;
        initSelectionList(displayObjects);
        initLayout();
        initLogic();
        setPositionAndSize();
    }

    public void giveFocusAway() {
        _chooseButton.requestFocusInWindow();
    }

    private void initSelectionList(final Collection<DisplayObject> displayObjects) {
        List<DisplayObject> displayObjectList = new ArrayList<>(displayObjects);
        _selectionList = new DisplayObjectSelectionList("Suche", "Objekte", Comparator.comparing(DisplayObject::getName));
        // Reihenfolge der kommenden 2 Statements ist wichtig:
        _selectionList.setListRenderer(new DisplayObjectListRenderer());
        _selectionList.setElements(displayObjectList);
    }

    private void initLayout() {
        setTitle("Gehe zu");
        JPanel allPanel = new JPanel();
        allPanel.setLayout(new BoxLayout(allPanel, BoxLayout.Y_AXIS));
        add(allPanel);

        JLabel label = new JLabel("Bitte Objekte auswählen:");
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, BoxLayout.X_AXIS));
        labelPanel.add(label);
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        allPanel.add(labelPanel);

        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.X_AXIS));
        allPanel.add(mainPanel);

        mainPanel.add(_selectionList);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.Y_AXIS));
        buttonPanel.add(Box.createVerticalGlue());
        buttonPanel.add(_chooseButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(0, 30)));
        buttonPanel.add(_helpButton);
        buttonPanel.setBorder(new EmptyBorder(10, 10, 10, 10));

        mainPanel.add(buttonPanel);
    }

    private void initLogic() {
        _chooseButton.addActionListener(e -> {
            List<DisplayObject> selectedDisplayObjects = _selectionList.getSelectedValues();
            MapPane mapPane = _genericNetDisplay.getMapPane();
            mapPane.setSelectedObjects(selectedDisplayObjects);
            mapPane.focusOnObjects(selectedDisplayObjects);
        });

        _helpButton.addActionListener(e -> GndHelp.openHelp("#gotoForLayers"));
    }

    private void setPositionAndSize() {
        _selectionList.setPreferredSize(new Dimension(_selectionList.getPreferredSize().width, 550));
        setPositionAndSize(0, 0, 0, 0, true, 0, 0);
    }

    @Override
    public String toString() {
        return "ChooseFromDialog{}";
    }
}
