/*
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.complexPlugin;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.pluginInterfaces.DOTDefinitionPanel;
import de.kappich.pat.gnd.pluginInterfaces.DefaultDOTDefinitionPanel;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectTypePlugin;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectsInitializer;
import de.kappich.pat.gnd.properties.ColorProperty;
import de.kappich.pat.gnd.properties.Property;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Die Selbstbeschreibung des Plugins für komplexe Objekte.
 *
 * @author Kappich Systemberatung
 */
@SuppressWarnings("RedundantNoArgConstructor")
public class DOTComplexPlugin implements DisplayObjectTypePlugin {

    private static Set<String> _supportedSystemObjectTypePIDs;

    /**
     * Konstruiert eine Selbstbeschreibung des Plugins.
     */
    public DOTComplexPlugin() {
        super();
    }

    private static void initSupportedSystemObjectTypePIDs(DataModel configuration) {
        final List<SystemObjectType> geoReferenceObjectTypes = new ArrayList<>();
        final SystemObjectType geoReferenceObjectType = configuration.getType("typ.komplex");
        geoReferenceObjectTypes.add(geoReferenceObjectType);
        for (int i = 0; i < geoReferenceObjectTypes.size(); i++) {
            geoReferenceObjectTypes.addAll(geoReferenceObjectTypes.get(i).getSubTypes());
        }
        _supportedSystemObjectTypePIDs = new HashSet<>();
        for (SystemObjectType systemObjectType : geoReferenceObjectTypes) {
            _supportedSystemObjectTypePIDs.add(systemObjectType.getPid());
        }
    }
//	public DOTDefinitionPanel getPanel(de.kappich.pat.gnd.displayObjectToolkit.DOTDefinitionDialog dotDefinitionDialog) {
//		return new DOTComplexPanel(dotDefinitionDialog);
//	}

    @Override
    public String getName() {
        return "Komplex";
    }

    @Override
    public DOTDefinitionPanel getPanel(de.kappich.pat.gnd.displayObjectToolkit.DOTDefinitionDialog dotDefinitionDialog) {
        return new DefaultDOTDefinitionPanel(new DOTComplexPlugin(), dotDefinitionDialog);
    }

    @Override
    public DisplayObjectType getDisplayObjectType() {
        return new DOTComplex();
    }

    @Override
    public DisplayObjectsInitializer getInitializer() {
        return new ComplexInitializer();
    }

    @Override
    public DisplayObjectPainter getPainter() {
        return new DOTComplexPainter();
    }

    @Override
    public String[] getPrimitiveFormTypes() {
        return new String[0];
    }

    @Nullable
    @Override
    public Property[] getProperties(Object o) {
        Property[] properties = null;
        if (o == null) {
            properties = new Property[] {ColorProperty.getInstance()};
        }
        return properties;
    }

    @Override
    public String getGeometryType() {
        return "typ.geoReferenzObject";
    }

    @Override
    public boolean isSystemObjectTypeSupported(DataModel configuration, SystemObjectType systemObjectType) {
        if (_supportedSystemObjectTypePIDs == null) {
            initSupportedSystemObjectTypePIDs(configuration);
        }
        return _supportedSystemObjectTypePIDs.contains(systemObjectType.getPid());
    }

    @Override
    public boolean isDynamicsPossible() {
        return true;
    }

    @Override
    public boolean isMapScaleListeningNecessary() {
        return true;
    }

}
