/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.configBrowser;

import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.properties.PropertyClass;
import de.bsvrz.sys.funclib.kappich.properties.PropertyName;
import de.kappich.pat.gnd.csvPlugin.CsvDisplayObject;
import java.util.Map;

/**
 * {@code CsvObjectProperties} ist eine Klasse, die alle Informationen über ein {@code CsvDisplayObject}  zusammenstellt.
 *
 * @author Kappich Systemberatung
 */
@PropertyClass
public class CsvObjectProperties {

    final CsvDisplayObject _csvObject;

    /*
     * Die Klasse <code>CsvObjectProperties</code> ist eine <code>PropertyClass</code>,
     * die bestimmt wie die Properties eines <code>CsvDisplayObject</code> aussehen.
     *
     * @param csvObject ein <code>CsvDisplayObject</code>
     */
    protected CsvObjectProperties(@NotNull final CsvDisplayObject csvObject) {
        _csvObject = csvObject;
    }

    /**
     * Diese Methode liefert falls möglich ein spezifisches, andernfalls ein unspezifisches Objekt zurück
     *
     * @param csvObject ein SystemObject
     *
     * @return ein ConfigObjectProperties-Objekt
     */
    public static CsvObjectProperties createCsvObjectProperties(@NotNull final CsvDisplayObject csvObject) {
        return new CsvObjectProperties(csvObject);
    }

    /**
     * Der Getter des {@code CsvDisplayObject}.
     *
     * @return das {@code CsvDisplayObject}
     */
    public CsvDisplayObject getCsvDisplayObject() {
        return _csvObject;
    }

    /**
     * Diese Methode bestimmt, wie die CSV-Daten dargestellt werden.
     *
     * @return eine LinkedHashMap
     */
    @PropertyName(name = "CSV-Daten")
    public Map<String, Object> getElementProperties() {
        return _csvObject.getCsvRowValues();
    }

    @Override
    public final String toString() {
        return _csvObject.getName();
    }
}
