/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.configBrowser;

import de.bsvrz.dav.daf.main.config.ConfigurationObject;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.ObjectSet;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.kappich.properties.PropertyClass;
import de.bsvrz.sys.funclib.kappich.properties.PropertyName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * {@code InnerSegmentProperties} ist eine Klasse, die {@link ConfigObjectProperties} um die Informationen für Objekte vom Typ {@code
 * InneresStraßenSegment} erweitert.
 *
 * @author Kappich Systemberatung
 */
@PropertyClass
public class InnerSegmentProperties extends ConfigObjectProperties {

    private static final Object _configurationAccess = new Object();
    private static final Map<SystemObject, List<Object>> _segmentToNodesMap = new HashMap<>();
    private static boolean _segmentToNodesMapInitialized;

    /**
     * Der Konstruktor.
     *
     * @param systemObject ein SystemObject
     */
    public InnerSegmentProperties(@NotNull final SystemObject systemObject) {
        super(systemObject);
    }

    /**
     * Diese Methode bestimmt, welche Straßenknoten-Eigenschaften für innere Straßensegmente angezeigt werden.
     *
     * @return ein ConfigObjectProperties-Objekt oder eine Liste davon
     */
    @SuppressWarnings("SynchronizationOnStaticField")
    @PropertyName(name = "Straßenknoten", sortKey = 10)
    public Object getSegmentProperties() {
        synchronized (_configurationAccess) {
            if (!_segmentToNodesMapInitialized) {
                initializeLookup();
            }
        }
        List<Object> list = _segmentToNodesMap.get(_systemObject);
        if (null == list) {
            return Collections.EMPTY_LIST;
        } else if (list.size() == 1) {
            return list.get(0);
        } else {
            return list;
        }
    }

    private void initializeLookup() {
        _segmentToNodesMap.clear();

        DataModel configuration = _systemObject.getDataModel();
        SystemObjectType intersectionNodeType = configuration.getType("typ.straßenKnoten");
        List<SystemObject> intersectionNodes = intersectionNodeType.getElements();
        for (SystemObject intersectionNode : intersectionNodes) {
            ConfigurationObject configurationObject = (ConfigurationObject) intersectionNode;
            ObjectSet objectSet = configurationObject.getObjectSet("InnereStraßenSegmente");
            List<SystemObject> elements = objectSet.getElements();
            for (SystemObject element : elements) {
                if (_segmentToNodesMap.containsKey(element)) {
                    _segmentToNodesMap.get(element).add(createConfigObjectProperties(intersectionNode));
                } else {
                    List<Object> newList = new ArrayList<>(1);
                    newList.add(createConfigObjectProperties(intersectionNode));
                    _segmentToNodesMap.put(element, newList);
                }
            }
        }
        _segmentToNodesMapInitialized = true;
    }
}
