/*
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.displayObjectToolkit;

/**
 * Ein DOTSubscriptionData kapselt die für eine Anmeldung auf dynamische Daten notwendige Informationen, also Attributgrupope und Aspekt.
 *
 * @author Kappich Systemberatung
 */
public class DOTSubscriptionData implements Comparable<DOTSubscriptionData> {

    private final String _attributeGroup;
    private final String _aspect;

    /**
     * Ein DOTSubscriptionData kapselt die für eine Anmeldung auf dynamische Daten notwendige Informationen, d.h. Attributgrupope und Aspekt.
     *
     * @param attributeGroup
     * @param aspect
     */
    public DOTSubscriptionData(String attributeGroup, String aspect) {
        super();
        _attributeGroup = attributeGroup;
        _aspect = aspect;
    }

    /**
     * Gibt die Attributgruppe zurück.
     *
     * @return die Attributgruppe
     */
    public String getAttributeGroup() {
        return _attributeGroup;
    }

    /**
     * Gibt den Aspekt zurück.
     *
     * @return der Aspekt
     */
    public String getAspect() {
        return _aspect;
    }

    /**
     * Vergleicht Attributgruppe und Aspekt mit String.equals().
     *
     * @return {@code true} genau dann, wenn Attributgruppe und Aspekt gleich sind
     */
    @Override
    public boolean equals(Object o) {
	    if (!(o instanceof DOTSubscriptionData d)) {
            return false;
        }
        return _attributeGroup.equals(d._attributeGroup) && _aspect.equals(d._aspect);
    }

    /**
     * Addiert die Hashcodes von Attributgruppe und Aspekt.
     *
     * @return Summe der Hashcodes
     */
    @Override
    public int hashCode() {
        return _attributeGroup.hashCode() + _aspect.hashCode();
    }

    /**
     * Eine einfache Selbstbeschreibung.
     *
     * @return die Selbstbeschreibung
     */
    @Override
    public String toString() {
        return "DOTSubscriptionData[AttributeGroup=" + _attributeGroup + ", Aspect=" + _aspect + "]";
    }

    @Override
    public int compareTo(DOTSubscriptionData d) {
        int atgHash = _attributeGroup.compareTo(d._attributeGroup);
        if (atgHash != 0) {
            return atgHash;
        } else {
            return _aspect.compareTo(d._aspect);
        }
    }
}
