/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.extLocRef;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.util.prefs.Preferences;

/**
 * Das Interface verkapselt die Association zweier {@link SystemObjectType SystemObjectTypes}
 *
 * @author Kappich Systemberatung
 */
public interface SimpleReference {

    /**
     * Gibt den ersten beteiligten {@link SystemObjectType} zurück.
     *
     * @return der erste SystemObjectType
     */
    SystemObjectType getFirstType();

    /**
     * Gibt den zweiten beteiligten {@link SystemObjectType} zurück.
     *
     * @return der erste SystemObjectType
     */

    SystemObjectType getSecondType();

    /**
     * Speichert sich in den übergabenen {@link Preferences}.
     *
     * @param prefs die Preferences
     */
    void putPreferences(Preferences prefs);

    /**
     * Initialisiert das Objekt aus den übergabenen {@link Preferences}.
     *
     * @param prefs die Preferences
     */
    boolean initializeFromPreferences(Preferences prefs, DataModel configuration);

    /**
     * Gibt eine (tiefe) Kopie des Objekts zurück.
     *
     * @return die Kopie
     */
    SimpleReference getCopy();
}
