/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.extLocRef;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import java.util.prefs.Preferences;

/**
 * Diese Klasse implentiert das Interface {@link SimpleReference} für durch Mengen gegebene Referenzen.
 *
 * @author Kappich Systemberatung
 */
public class SimpleSetReference implements SimpleReference {

    private static final String FIRST_TYPE = "firstType";
    private static final String SECOND_TYPE = "secondType";
    private static final String SET_NAME = "setName";

    private SystemObjectType _firstType;
    private SystemObjectType _secondType;
    private String _setName;

    /*
    Dieser Konstruktor wird tatsächlich gebraucht, und zwar in DirectedReference.initializeFromPreferences!
    Dort wird newInstance von Class aufgerufen.
     */
    @SuppressWarnings("unused")
    SimpleSetReference() {
        _firstType = null;
        _secondType = null;
        _setName = "";
    }

    SimpleSetReference(SystemObjectType firstType, SystemObjectType secondType, String setName) {
        _firstType = firstType;
        _secondType = secondType;
        _setName = setName;
    }

    @Override
    public SystemObjectType getFirstType() {
        return _firstType;
    }

    @Override
    public SystemObjectType getSecondType() {
        return _secondType;
    }

    @Override
    public void putPreferences(final Preferences prefs) {
        prefs.put(FIRST_TYPE, _firstType.getPid());
        prefs.put(SECOND_TYPE, _secondType.getPid());
        prefs.put(SET_NAME, _setName);
    }

    @Override
    public boolean initializeFromPreferences(final Preferences prefs, DataModel configuration) {
        String firstTypePid = prefs.get(FIRST_TYPE, null);
        String secondTypePid = prefs.get(SECOND_TYPE, null);
        if (null == firstTypePid || null == secondTypePid) {
            return false;
        }
        _firstType = configuration.getType(firstTypePid);
        _secondType = configuration.getType(secondTypePid);
        _setName = prefs.get(SET_NAME, "");
        return !(null == _firstType || null == _secondType || null == _setName);
    }

    @Override
    public SimpleReference getCopy() {
        return new SimpleSetReference(_firstType, _secondType, _setName);
    }

    public String getSetName() {
        return _setName;
    }

    @Override
    public String toString() {
        return "1: " + _firstType.getNameOrPidOrId() + ", 2: " + _secondType.getNameOrPidOrId() + ", Menge: " + _setName;
    }

    @SuppressWarnings("NonFinalFieldReferenceInEquals")
    @Override
    public boolean equals(Object o) {
	    if (!(o instanceof SimpleSetReference other)) {
            return false;
        }
        return _firstType.equals(other._firstType) && _secondType.equals(other._secondType) && _setName.equals(other._setName);
    }

    @SuppressWarnings("NonFinalFieldReferencedInHashCode")
    @Override
    public int hashCode() {
        int result = _firstType.hashCode();
        result = 31 * result + _secondType.hashCode();
        result = 31 * result + _setName.hashCode();
        return result;
    }
}
