/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.extLocRef.view;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.Attribute;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.kappich.pat.gnd.documentation.GndHelp;
import de.kappich.pat.gnd.extLocRef.DirectedReference;
import de.kappich.pat.gnd.extLocRef.SimpleReference;
import de.kappich.pat.gnd.extLocRef.SimpleReferenceManager;
import de.kappich.pat.gnd.utils.SpringUtilities;
import de.kappich.pat.gnd.utils.view.GndDialog;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

/**
 * Der Dialog zur Auswahl und {@link DirectedReference gerichteter Assoziationen}.
 *
 * @author Kappich Systemberatung
 */
public class DRSelectionDialog extends GndDialog {

    private final ClientDavInterface _connection;
    private final CrDefinitionDialog _owner;

    DRSelectionDialog(ClientDavInterface connection, CrDefinitionDialog owner, boolean modal) {
        super("DRSelectionDialog", owner.getFrame(), modal);
        _connection = connection;
        _owner = owner;
        setTitle("Festlegen einer Objekttypen-Referenz");
        initTabs();
        setPositionAndSize();
    }

    private void initTabs() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("über eine Attributgruppe", getAttributeGroupPanel());
        tabbedPane.addTab("über eine Menge", getSetPanel());
        tabbedPane.addTab("Andere", new JPanel());
        tabbedPane.setEnabledAt(2, false);
        add(tabbedPane, BorderLayout.CENTER);
    }

    @SuppressWarnings("OverlyLongMethod")
    private JPanel getAttributeGroupPanel() {
        JPanel attributeGroupPanel = new JPanel();
        attributeGroupPanel.setLayout(new BorderLayout());

        // Oberer Teil mit Labeln
        JLabel labelDesc = new JLabel("Beschreibung");
        JTextField textFieldDesc = new JTextField(50);
        textFieldDesc.setMaximumSize(textFieldDesc.getPreferredSize());

        JLabel labelO1 = new JLabel("Objekttyp 1");
        JComboBox<Object> comboBoxO1 = new JComboBox<>(SimpleReferenceManager.getInstance(_connection).getSystemObjectTypesForAttributes());
        comboBoxO1.setMaximumSize(comboBoxO1.getPreferredSize());
        SystemObjectType prototype = _connection.getDataModel().getType("typ.anzeigeQuerschnittLoehne");
        comboBoxO1.setPrototypeDisplayValue(prototype);
        comboBoxO1.setEnabled(true);
        comboBoxO1.setSelectedIndex(-1);

        JLabel labelAtg = new JLabel("Attributgruppe");
        JComboBox<Object> comboBoxAtg = new JComboBox<>();
        comboBoxAtg.setMaximumSize(comboBoxAtg.getPreferredSize());
        comboBoxAtg.setEnabled(false);

        JLabel labelAttr = new JLabel("Attribut");
        JComboBox<Object> comboBoxAttr = new JComboBox<>();
        comboBoxAttr.setMaximumSize(comboBoxAttr.getPreferredSize());
        comboBoxAttr.setEnabled(false);

        JLabel labelO2 = new JLabel("Objekttyp 2");
        JComboBox<Object> comboBoxO2 = new JComboBox<>();
        comboBoxO2.setMaximumSize(comboBoxO2.getPreferredSize());
        comboBoxO2.setPrototypeDisplayValue(prototype);
        comboBoxO2.setEnabled(false);

        JLabel labelUse = new JLabel("Verwendung");
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, BoxLayout.X_AXIS));
        JRadioButton forwardButton = new JRadioButton("vorwärts");
        JRadioButton backwardButton = new JRadioButton("rückwärts");
        radioButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        radioButtonPanel.add(forwardButton);
        radioButtonPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        radioButtonPanel.add(backwardButton);
        ButtonGroup bg = new ButtonGroup();
        bg.add(forwardButton);
        bg.add(backwardButton);

        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new SpringLayout());
        upperPanel.add(labelDesc);
        upperPanel.add(textFieldDesc);
        upperPanel.add(labelO1);
        upperPanel.add(comboBoxO1);
        upperPanel.add(labelAtg);
        upperPanel.add(comboBoxAtg);
        upperPanel.add(labelAttr);
        upperPanel.add(comboBoxAttr);
        upperPanel.add(labelO2);
        upperPanel.add(comboBoxO2);
        upperPanel.add(labelUse);
        upperPanel.add(radioButtonPanel);

        upperPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        SpringUtilities.makeCompactGrid(upperPanel, 2, 5, 5);
        attributeGroupPanel.add(upperPanel, BorderLayout.WEST);

        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new SpringLayout());
        JButton okayButton = new JButton("Übernehmen");
        lowerPanel.add(okayButton);
        JButton closeButton = new JButton("Schließen");
        lowerPanel.add(closeButton);
        JButton helpButton = new JButton("Hilfe");
        lowerPanel.add(helpButton);
        lowerPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        SpringUtilities.makeCompactGrid(lowerPanel, 3, 20, 5);
        attributeGroupPanel.add(lowerPanel, BorderLayout.SOUTH);

        setAtgPanelActionListener(comboBoxO1, comboBoxAtg, comboBoxAttr, comboBoxO2);
        setAtgButtonActionListeners(okayButton, closeButton, helpButton, textFieldDesc, comboBoxO1, comboBoxAtg, comboBoxAttr, comboBoxO2,
                                    forwardButton, backwardButton);

        return attributeGroupPanel;
    }

    private void setAtgPanelActionListener(JComboBox<Object> comboBoxO1, JComboBox<Object> comboBoxAtg, JComboBox<Object> comboBoxAttr,
                                           JComboBox<Object> comboBoxO2) {
        comboBoxO1.addActionListener(e -> {
            SystemObjectType type = (SystemObjectType) comboBoxO1.getSelectedItem();
            if (null != type) {
                Object[] atgs = SimpleReferenceManager.getInstance(_connection).getAttributeGroups(type);
                if (0 != atgs.length) {
                    comboBoxAtg.setModel(new DefaultComboBoxModel<>(atgs));
                    comboBoxAtg.setEnabled(true);
                    comboBoxAtg.setSelectedIndex(-1);
                } else {
                    comboBoxAtg.setModel(new DefaultComboBoxModel<>());
                    comboBoxAtg.setEnabled(false);
                }
                comboBoxAttr.setModel(new DefaultComboBoxModel<>());
                comboBoxAttr.setEnabled(false);
                comboBoxO2.setModel(new DefaultComboBoxModel<>());
                comboBoxO2.setEnabled(false);
            } else {
                comboBoxAtg.setModel(new DefaultComboBoxModel<>());
                comboBoxAtg.setEnabled(false);
                comboBoxAttr.setModel(new DefaultComboBoxModel<>());
                comboBoxAttr.setEnabled(false);
                comboBoxO2.setModel(new DefaultComboBoxModel<>());
                comboBoxO2.setEnabled(false);
            }
        });

        comboBoxAtg.addActionListener(e -> {
            SystemObjectType type = (SystemObjectType) comboBoxO1.getSelectedItem();
            AttributeGroup atg = (AttributeGroup) comboBoxAtg.getSelectedItem();
            if (null != type && null != atg) {
                Object[] attrs = SimpleReferenceManager.getInstance(_connection).getAttributes(type, atg);
                if (0 != attrs.length) {
                    comboBoxAttr.setModel(new DefaultComboBoxModel<>(attrs));
                    comboBoxAttr.setEnabled(true);
                    comboBoxAttr.setSelectedIndex(-1);
                } else {
                    comboBoxAttr.setModel(new DefaultComboBoxModel<>());
                    comboBoxAttr.setEnabled(false);
                }
                comboBoxO2.setModel(new DefaultComboBoxModel<>());
                comboBoxO2.setEnabled(false);
            } else {
                comboBoxAttr.setModel(new DefaultComboBoxModel<>());
                comboBoxAttr.setEnabled(false);
                comboBoxO2.setModel(new DefaultComboBoxModel<>());
                comboBoxO2.setEnabled(false);
            }
        });

        comboBoxAttr.addActionListener(e -> {
            SystemObjectType type = (SystemObjectType) comboBoxO1.getSelectedItem();
            AttributeGroup atg = (AttributeGroup) comboBoxAtg.getSelectedItem();
            Attribute attr = (Attribute) comboBoxAttr.getSelectedItem();
            if (null != type && null != atg && null != attr) {
                SystemObjectType otherType = SimpleReferenceManager.getInstance(_connection).getSystemObjectType(type, atg, attr);
                if (null != otherType) {
                    Object[] array = {otherType};
                    comboBoxO2.setModel(new DefaultComboBoxModel<>(array));
                    comboBoxO2.setEnabled(true);
                    comboBoxO2.setSelectedIndex(0);
                }
            }
        });
    }

    @SuppressWarnings("MethodWithTooManyParameters")
    private void setAtgButtonActionListeners(final JButton okayButton, final JButton closeButton, final JButton helpButton,
                                             final JTextField textFieldDesc, final JComboBox<Object> comboBoxO1, final JComboBox<Object> comboBoxAtg,
                                             final JComboBox<Object> comboBoxAttr, final JComboBox<Object> comboBoxO2,
                                             final JRadioButton forwardButton, final JRadioButton backwardButton) {
        okayButton.addActionListener(e -> {
            String description = textFieldDesc.getText();
            if (null == description || description.isEmpty()) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen geben Sie eine Beschreibung ein.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            SystemObjectType type1 = (SystemObjectType) comboBoxO1.getSelectedItem();
            if (null == type1) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen Sie einen Objekttyp 1 aus.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            AttributeGroup atg = (AttributeGroup) comboBoxAtg.getSelectedItem();
            if (null == atg) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen Sie eine Attributgruppe aus.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            Attribute attr = (Attribute) comboBoxAttr.getSelectedItem();
            if (null == attr) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen Sie ein Attribut aus.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            SystemObjectType type2 = (SystemObjectType) comboBoxO2.getSelectedItem();
            if (null == type2) {
                JOptionPane.showMessageDialog(this.getDialog(), "Kein Objeckttype 2 gefunden.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            if (!forwardButton.isSelected() && !backwardButton.isSelected()) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen Sie eine Verwendung aus.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            SimpleReference simpleReference = SimpleReferenceManager.getInstance(_connection).checkForSimpleReference(type1, atg, attr, type2);
            if (null == simpleReference) {
                JOptionPane.showMessageDialog(this.getDialog(), "Die eingebenen Daten bilden keine gültige Objekttypen-Referenz.", "Fehler",
                                              JOptionPane.ERROR_MESSAGE);
                return;
            }
            _owner.addDirectedReference(new DirectedReference(description, simpleReference, backwardButton.isSelected()));
        });

        closeButton.addActionListener(e -> {
            setVisible(false);
            storePreferenceBounds();
            dispose();
        });

        helpButton.addActionListener(e -> GndHelp.openHelp("#eorDefinitionDialog"));
    }

    @SuppressWarnings("OverlyLongMethod")
    private JPanel getSetPanel() {
        JPanel setPanel = new JPanel();
        setPanel.setLayout(new BorderLayout());

        // Oberer Teil mit Labeln
        JLabel labelDesc = new JLabel("Beschreibung");
        JTextField textFieldDesc = new JTextField(50);
        textFieldDesc.setMaximumSize(textFieldDesc.getPreferredSize());

        JLabel labelO1 = new JLabel("Objekttyp 1");
        JComboBox<Object> comboBoxO1 = new JComboBox<>(SimpleReferenceManager.getInstance(_connection).getSystemObjectTypesForSets());
        comboBoxO1.setMaximumSize(comboBoxO1.getPreferredSize());
        SystemObjectType prototype = _connection.getDataModel().getType("typ.anzeigeQuerschnittLoehne");
        comboBoxO1.setPrototypeDisplayValue(prototype);
        comboBoxO1.setEnabled(true);
        comboBoxO1.setSelectedIndex(-1);

        JLabel labelSet = new JLabel("Menge");
        JComboBox<Object> comboBoxSet = new JComboBox<>();
        comboBoxSet.setMaximumSize(comboBoxSet.getPreferredSize());
        comboBoxSet.setEnabled(false);

        JLabel labelO2 = new JLabel("Objekttyp 2");
        JComboBox<Object> comboBoxO2 = new JComboBox<>();
        comboBoxO2.setMaximumSize(comboBoxO2.getPreferredSize());
        comboBoxO2.setPrototypeDisplayValue(prototype);
        comboBoxO2.setEnabled(false);

        JLabel labelUse = new JLabel("Verwendung");
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, BoxLayout.X_AXIS));
        JRadioButton forwardButton = new JRadioButton("vorwärts");
        JRadioButton backwardButton = new JRadioButton("rückwärts");
        radioButtonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        radioButtonPanel.add(forwardButton);
        radioButtonPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        radioButtonPanel.add(backwardButton);
        ButtonGroup bg = new ButtonGroup();
        bg.add(forwardButton);
        bg.add(backwardButton);

        JPanel upperPanel = new JPanel();
        upperPanel.setLayout(new SpringLayout());
        upperPanel.add(labelDesc);
        upperPanel.add(textFieldDesc);
        upperPanel.add(labelO1);
        upperPanel.add(comboBoxO1);
        upperPanel.add(labelSet);
        upperPanel.add(comboBoxSet);
        upperPanel.add(labelO2);
        upperPanel.add(comboBoxO2);
        upperPanel.add(labelUse);
        upperPanel.add(radioButtonPanel);

        upperPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        SpringUtilities.makeCompactGrid(upperPanel, 2, 5, 5);
        setPanel.add(upperPanel, BorderLayout.WEST);

        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new SpringLayout());
        JButton okayButton = new JButton("Übernehmen");
        lowerPanel.add(okayButton);
        JButton closeButton = new JButton("Schließen");
        lowerPanel.add(closeButton);
        JButton helpButton = new JButton("Hilfe");
        lowerPanel.add(helpButton);
        lowerPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        SpringUtilities.makeCompactGrid(lowerPanel, 3, 20, 5);
        setPanel.add(lowerPanel, BorderLayout.SOUTH);

        setSetPanelActionListener(comboBoxO1, comboBoxSet, comboBoxO2);
        setSetButtonActionListeners(okayButton, closeButton, helpButton, textFieldDesc, comboBoxO1, comboBoxSet, comboBoxO2, forwardButton,
                                    backwardButton);
        return setPanel;
    }

    private void setSetPanelActionListener(final JComboBox<Object> comboBoxO1, final JComboBox<Object> comboBoxSet,
                                           final JComboBox<Object> comboBoxO2) {
        comboBoxO1.addActionListener(e -> {
            SystemObjectType type = (SystemObjectType) comboBoxO1.getSelectedItem();
            if (null != type) {
                Object[] sets = SimpleReferenceManager.getInstance(_connection).getSets(type);
                if (0 != sets.length) {
                    comboBoxSet.setModel(new DefaultComboBoxModel<>(sets));
                    comboBoxSet.setEnabled(true);
                    comboBoxSet.setSelectedIndex(-1);
                } else {
                    comboBoxSet.setModel(new DefaultComboBoxModel<>());
                    comboBoxSet.setEnabled(false);
                }
                comboBoxO2.setModel(new DefaultComboBoxModel<>());
                comboBoxO2.setEnabled(false);
            } else {
                comboBoxSet.setModel(new DefaultComboBoxModel<>());
                comboBoxSet.setEnabled(false);
                comboBoxO2.setModel(new DefaultComboBoxModel<>());
                comboBoxO2.setEnabled(false);
            }
        });

        comboBoxSet.addActionListener(e -> {
            SystemObjectType type = (SystemObjectType) comboBoxO1.getSelectedItem();
            String setName = (String) comboBoxSet.getSelectedItem();
            if (null != type && null != setName) {
                SystemObjectType otherType = SimpleReferenceManager.getInstance(_connection).getSystemObjectType(type, setName);
                if (null != otherType) {
                    Object[] array = {otherType};
                    comboBoxO2.setModel(new DefaultComboBoxModel<>(array));
                    comboBoxO2.setEnabled(true);
                    comboBoxO2.setSelectedIndex(0);
                }
            }
        });
    }

    @SuppressWarnings("MethodWithTooManyParameters")
    private void setSetButtonActionListeners(final JButton okayButton, final JButton closeButton, final JButton helpButton,
                                             final JTextField textFieldDesc, final JComboBox<Object> comboBoxO1, final JComboBox<Object> comboBoxSet,
                                             final JComboBox<Object> comboBoxO2, final JRadioButton forwardButton,
                                             final JRadioButton backwardButton) {
        okayButton.addActionListener(e -> {
            String description = textFieldDesc.getText();
            if (null == description || description.isEmpty()) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen geben Sie eine Beschreibung ein.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            SystemObjectType type1 = (SystemObjectType) comboBoxO1.getSelectedItem();
            if (null == type1) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen Sie einen Objekttyp 1 aus.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            String setName = (String) comboBoxSet.getSelectedItem();
            if (null == setName) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen Sie eine Menge aus.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            SystemObjectType type2 = (SystemObjectType) comboBoxO2.getSelectedItem();
            if (null == type2) {
                JOptionPane.showMessageDialog(this.getDialog(), "Kein Objeckttype 2 gefunden.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            if (!forwardButton.isSelected() && !backwardButton.isSelected()) {
                JOptionPane.showMessageDialog(this.getDialog(), "Bitte wählen Sie eine Verwendung aus.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return;
            }
            SimpleReference simpleReference = SimpleReferenceManager.getInstance(_connection).checkForSimpleReference(type1, setName, type2);
            if (null == simpleReference) {
                JOptionPane.showMessageDialog(this.getDialog(), "Die eingebenen Daten bilden keine gültige Objekttypen-Referenz.", "Fehler",
                                              JOptionPane.ERROR_MESSAGE);
                return;
            }
            _owner.addDirectedReference(new DirectedReference(description, simpleReference, backwardButton.isSelected()));
        });

        closeButton.addActionListener(e -> {
            setVisible(false);
            storePreferenceBounds();
            dispose();
        });

        helpButton.addActionListener(e -> GndHelp.openHelp("#drSelectionDialog"));
    }

    private void setPositionAndSize() {
        final Rectangle bounds = getBounds();
        setPositionAndSize(0, 0, (int) (bounds.getHeight() / 1.5 + 720), (int) (bounds.getWidth() / 1.5), false, 720, 300);
        if (!hasBoundsFromPrefs() && _owner != null) {
            setLocationRelativeTo(_owner.getFrame());
        }
    }

    public void runDialog() {
        setVisible(true);
    }

    @Override
    public String toString() {
        return "DRSelectionDialog{}";
    }
}
