/*
 * Copyright 2011-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.gnd;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;

/**
 * @author Kappich Systemberatung
 */
public class DynamicListModel extends AbstractListModel<Object> {

    private final TreeSet<SystemObject> _systemObjects = new TreeSet<>();

    @Override
    public int getSize() {
        return _systemObjects.size();
    }

    @Override
    @Nullable
    public Object getElementAt(final int index) {
        SystemObject o = getObject(index);
        if (null != o) {
            return o.getNameOrPidOrId();
        } else {
            return null;
        }
    }

    /**
     * Setzt die Elemente der Liste.
     *
     * @param newElements die neuen Elemente
     */
    public void setElements(final Collection<SystemObject> newElements) {
        final HashSet<SystemObject> addedElements = new HashSet<>(newElements);
        final HashSet<SystemObject> removedElements = new HashSet<>(_systemObjects);
        addedElements.removeAll(_systemObjects);
        removedElements.removeAll(newElements);
        for (final SystemObject element : addedElements) {
            if (_systemObjects.add(element)) {
                notifyElementAdded(element);
            }
        }
        for (final SystemObject element : removedElements) {
            notifyElementRemoved(element);
            _systemObjects.remove(element);
        }
    }

    private void notifyElementAdded(final SystemObject element) {
        final int index = getElementIndex(element);
        fireIntervalAdded(this, index, index);
    }

    private void notifyElementRemoved(final SystemObject element) {
        final int index = getElementIndex(element);
        fireIntervalRemoved(this, index, index);
    }

    private int getElementIndex(final SystemObject element) {
        int i = 0;
        for (final SystemObject systemObject : _systemObjects) {
            if (element.equals(systemObject)) {
                return i;
            }
            i++;
        }
        return -1;
    }

    /**
     * Gibt die Indizes der Elemente in der Collection zurück.
     *
     * @param selectedSystemObjects die Collection
     *
     * @return ein Array von Indizes
     */
    public int[] getElementIndizes(final Collection<SystemObject> selectedSystemObjects) {
        final List<Integer> list = new ArrayList<>();
        int i = 0;

        for (final SystemObject systemObject : _systemObjects) {
            if (selectedSystemObjects.contains(systemObject)) {
                list.add(i);
            }
            i++;
        }
        int[] result = new int[list.size()];
        for (int index = 0, listSize = list.size(); index < listSize; index++) {
            result[index] = list.get(index);
        }
        return result;
    }

    /**
     * Gibt das {@link SystemObject} zu dem Index zurück oder {@code null}, wenn kein solches Object existiert.
     *
     * @param index der Index
     *
     * @return das SystemObject
     */
    @Nullable
    public SystemObject getObject(final int index) {
        int i = 0;
        for (final SystemObject systemObject : _systemObjects) {
            if (i == index) {
                return systemObject;
            }
            i++;
        }
        return null;
    }
}
