/*
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.needlePlugin;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.displayObjectToolkit.DOTDefinitionDialog;
import de.kappich.pat.gnd.gnd.PluginManager;
import de.kappich.pat.gnd.pluginInterfaces.DOTDefinitionPanel;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectTypePlugin;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectsInitializer;
import de.kappich.pat.gnd.properties.Property;

/**
 * Die Selbstbeschreibung des Linien-Plugins.
 *
 * @author Kappich Systemberatung
 */
public final class DOTNeedlePlugin implements DisplayObjectTypePlugin {

    /**
     * Konstruiert eine Selbstbeschreibung des Plugins.
     */
    public DOTNeedlePlugin() {
        super();
        // prüft, ob die Implementation im PluginManager bekannt ist
        if (!PluginManager.hasPlugin(getName())) {
            throw new RuntimeException("Das DOTNeedlePlugin ist dem PluginManager nicht bekannt.");
        }

    }

    @Override
    public String getName() {
        return "Nadel";
    }

    @Override
    public DOTDefinitionPanel getPanel(final DOTDefinitionDialog dotDefinitionDialog) {
        return new DOTNeedlePanel();
    }

    @Override
    public DisplayObjectType getDisplayObjectType() {
        return new DOTNeedle();
    }

    @Override
    public DisplayObjectsInitializer getInitializer() {
        return new NeedleInitializer();
    }

    @Override
    public DisplayObjectPainter getPainter() {
        return new DOTNeedlePainter();
    }

    @Override
    public String[] getPrimitiveFormTypes() {
        return new String[0];
    }

    @Override
    @Nullable
    public Property[] getProperties(Object o) {
        Property[] properties = null;
        if (o == null) {
            properties = new Property[] {};
        }
        return properties;
    }

    @Override
    public String getGeometryType() {
        return "typ.konfigurationsObjekt";
    }

    @Override
    public boolean isSystemObjectTypeSupported(DataModel configuration, SystemObjectType systemObjectType) {
        return true;
    }

    @Override
    public boolean isDynamicsPossible() {
        return false;
    }

    @Override
    public boolean isMapScaleListeningNecessary() {
        return false;
    }

}
