/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.needlePlugin;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.areaPlugin.DOTAreaPlugin;
import de.kappich.pat.gnd.complexPlugin.DOTComplexPlugin;
import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.layerManagement.Layer;
import de.kappich.pat.gnd.linePlugin.DOTLinePlugin;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectTypePlugin;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectsInitializer;
import de.kappich.pat.gnd.pointPlugin.DOTPointPlugin;
import de.kappich.pat.gnd.viewManagement.NoticeLayer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JProgressBar;

/**
 * Dies ist die Implementierung des {@code DisplayObjectsInitializers} im Needle-Plugin.
 *
 * @author Kappich Systemberatung
 */
public class NeedleInitializer implements DisplayObjectsInitializer {
    private static final Debug _debug = Debug.getLogger();

    // Diese Methode dient der Herstellung der Abwärtskompatibiliät zu alten in den Präferenzen
    // ohne Plugin abgespeicherten Layern. Eine ähnliche Methode musste im DisplayObjectManager
    // hinzugefügt werden.
    @Nullable
    private static DisplayObjectTypePlugin computePluginForLayer(final DataModel configuration, final Layer layer) {
        // Layer, die mit alten Versionen der GND gespeichert wurden, haben kein Plugin.
        SystemObjectType systemObjectType = configuration.getType(layer.getConfigurationObjectType());
        if (systemObjectType == null) {
            return null;   // Passiert, wenn die Konfiguration unvollständig ist.
        }
        SystemObjectType pointType = configuration.getType("typ.punkt");
        SystemObjectType lineType = configuration.getType("typ.linie");
        SystemObjectType areaType = configuration.getType("typ.fläche");
        SystemObjectType complexType = configuration.getType("typ.komplex");

        if (systemObjectType.inheritsFrom(pointType)) {
            return new DOTPointPlugin();
        } else if (systemObjectType.inheritsFrom(lineType)) {
            return new DOTLinePlugin();
        } else if (systemObjectType.inheritsFrom(areaType)) {
            return new DOTAreaPlugin();
        } else if (systemObjectType.inheritsFrom(complexType)) {
            return new DOTComplexPlugin();
        }
        return null;
    }

    @Override
    public void initializeDisplayObjects(final DataModel configuration, final Layer layer, final MapPane mapPane, final JProgressBar progressBar,
                                         final List<DisplayObject> returnList) {
	    if (layer instanceof NoticeLayer noticeLayer) {  // sollte stets der Fall sein
            // Da der DOTNeedlePainter (im Moment) nur OnlineDisplayObjects benutzt (s. insbesondere den NoticeManager,
            // müssen wir hier die Plugins einschränken; damit werden z.B. Betriebskilometrierung und ASB-Knotennamen
            // ausgeschlossen.
            DisplayObjectTypePlugin plugin = noticeLayer.getOriginalLayer().getPlugin();
            if (null == plugin) {
                plugin = computePluginForLayer(configuration, noticeLayer.getOriginalLayer());
            }
            if (null != plugin && plugin.isDynamicsPossible()) {
                List<DisplayObject> displayObjects = new ArrayList<>();
                plugin.getInitializer().initializeDisplayObjects(configuration, noticeLayer, mapPane, progressBar, displayObjects);
                DOTNeedlePainter painter = new DOTNeedlePainter();
                for (DisplayObject displayObject : displayObjects) {
                    displayObject.setPainter(painter);
                    returnList.add(displayObject);
                }
            }
        }
    }
}
