/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.pluginInterfaces;

import de.bsvrz.dav.daf.main.config.DataModel;
import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.layerManagement.Layer;
import java.util.List;
import javax.swing.JProgressBar;

/**
 * Das Interface des Initialisierers aller {@code DisplayObjects} eines Plugins. Der Initialisierer arbeitet grundsätzlich layer-weise.
 *
 * @author Kappich Systemberatung
 */
public interface DisplayObjectsInitializer {

    /**
     * Die Methode zur Initialisierung aller {@code DisplayObjects} eines {@code Layer}s.
     *
     * @param configuration die Konfiguration
     * @param layer         ein Layer
     * @param returnList    die Liste der {@code DisplayObjects}
     * @param mapPane       MapPane
     * @param progressBar   kann zur Fortschrittsanzeige genutzt werden
     */
    void initializeDisplayObjects(final DataModel configuration, final Layer layer, final MapPane mapPane, final JProgressBar progressBar,
                                  List<DisplayObject> returnList);
}
