/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.colorManagement.ColorManager;
import de.kappich.pat.gnd.utils.SpringUtilities;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

/**
 * Diese Klasse verkapselt die Eigenschaft Farbe.
 *
 * @author Kappich Systemberatung
 */
public final class ColorProperty extends AbstractProperty {
    private static final ColorProperty _instance = new ColorProperty();
    private static final String KEY = "color";
    private static final String DEFAULT_COLOR = "hellgrau";

    private ColorProperty() {
        super("Farbe");
    }

    public static Property getInstance() {
        return _instance;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_COLOR;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable) {
        if (value != null && ColorManager.getInstance().hasColor((String) value)) {
            return new ColorPanel((String) value, changeable);
        } else {
            return new ColorPanel(DEFAULT_COLOR, changeable);
        }
    }

    private static class ColorPanel extends JPanel implements PropertyPanel {
        private final JComboBox<Object> _colorComboBox = new JComboBox<>(ColorManager.getInstance().getColorNames());

        public ColorPanel(String colorName, boolean changeable) {
            JLabel label = new JLabel("Farbe: ");
            _colorComboBox.setMaximumSize(new Dimension(200, 25));
            _colorComboBox.getModel().setSelectedItem(colorName);
            _colorComboBox.setEnabled(changeable);
            setLayout(new SpringLayout());
            add(label);
            add(_colorComboBox);
            SpringUtilities.makeCompactGrid(this, 2, 5, 5);
        }

        @Override
        public void addListener(final PropertyPanelListener listener) {
            ItemListener itemListener = e -> listener.stateChanged();
            _colorComboBox.addItemListener(itemListener);
        }

        @Override
        public Object getPropertyValue() {
            return _colorComboBox.getSelectedItem();
        }

        @Override
        public void setSelectionEnabled(final boolean enabled) {
            _colorComboBox.setEnabled(enabled);
        }

    }
}
