/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.utils.SpringUtilities;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

/**
 * Diese Klasse verkapselt die Eigenschaft Abstandsraster oder Abstandsstufe, die zur Subtypisierung der DisplayObjects im Kilometrierungs- und
 * Stationierungs-Plugin benutzt wird.
 *
 * @author Kappich Systemberatung
 */
public final class DistanceRasterProperty extends AbstractProperty {
    private static final DistanceRasterProperty _instance = new DistanceRasterProperty();
    private static final String KEY = "distanceraster";
    private static final DistanceRasterType DEFAULT_DISTANCE_RASTER_TYPE = DistanceRasterType.TEN;

    private DistanceRasterProperty() {
        super("Abstandsraster");
    }

    public static Property getInstance() {
        return _instance;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_DISTANCE_RASTER_TYPE;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable) {
        if (value != null) {
            return new DistanceRastrePanel((DistanceRasterType) value, changeable);
        } else {
            return new DistanceRastrePanel(DEFAULT_DISTANCE_RASTER_TYPE, changeable);
        }
    }

    private static class DistanceRastrePanel extends JPanel implements PropertyPanel {
        private static final Object[] RASTER_TYPE_ITEMS = DistanceRasterType.values();
        private final JComboBox<Object> _rasterTypeComboBox = new JComboBox<>(RASTER_TYPE_ITEMS);

        public DistanceRastrePanel(DistanceRasterType distanceRasterType, boolean changeable) {
            JLabel label = new JLabel("Abstandsstufe: ");
            _rasterTypeComboBox.setMaximumSize(new Dimension(200, 25));
            _rasterTypeComboBox.getModel().setSelectedItem(distanceRasterType);
            _rasterTypeComboBox.setEnabled(changeable);
            setLayout(new SpringLayout());
            add(label);
            add(_rasterTypeComboBox);
            SpringUtilities.makeCompactGrid(this, 2, 5, 5);
        }

        @Override
        public void addListener(final PropertyPanelListener listener) {
            ItemListener itemListener = e -> listener.stateChanged();
            _rasterTypeComboBox.addItemListener(itemListener);
        }

        @Override
        public Object getPropertyValue() {
            return _rasterTypeComboBox.getSelectedItem();
        }

        @Override
        public void setSelectionEnabled(final boolean enabled) {
            _rasterTypeComboBox.setEnabled(enabled);
        }
    }
}
