/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

/**
 * Diese Klasse stellt Objekte der Implementierungen des Interface {@link Property} zur Verfügung.
 *
 * @author Kappich Systemberatung
 */
public enum PropertiesManager {
    INSTANCE;

    public Property getProperty(final String key) {
	    return switch (key) {
		    case "color" -> ColorProperty.getInstance();
		    case "diameter" -> DiameterProperty.getInstance();
		    case "distance" -> DistanceProperty.getInstance();
		    case "distanceraster" -> DistanceRasterProperty.getInstance();
		    case "dotting" -> DottingProperty.getInstance();
		    case "fill" -> FillingProperty.getInstance();
		    case "kmformat" -> KmFormatProperty.getInstance();
		    case "kmstroke" -> DottingProperty.getInstance();
		    case "rnformat" -> RnFormatProperty.getInstance();
		    case "statformat" -> StatFormatProperty.getInstance();
		    case "strokewidth" -> StrokeWidthProperty.getInstance();            // alt
		    case "size", "textsize" ->        // neu
				    TextSizeProperty.getInstance();
		    case "text" -> TextProperty.getInstance();
		    case "textstyle" -> TextStyleProperty.getInstance();
		    case "transparency" -> TransparencyProperty.getInstance();
		    default ->
				    throw new IllegalArgumentException("Es gibt keine Property-Klasse für den Kurznamen '" + key + "'");
	    };
    }
}
