/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;

/**
 * {@code Property} ist ein Interface für die verschiedenen Eigenschaften, die zum Zeichnen von {@link
 * de.kappich.pat.gnd.displayObjectToolkit.DisplayObject DisplayObjects} benötigt werden.
 *
 * @author Kappich Systemberatung
 */
public interface Property {

    /**
     * Gibt den Namen der Eienschaft zurück.
     *
     * @return der Name
     */
    String getName();

    /**
     * Gibt den Default-Wert der Eigenschaft zurück.
     *
     * @return der Default-Wert
     */
    Object getDefaultValue();

    /**
     * Gibt einen unter allen Implementationen eindeutigen Kurznamen der Eigenschaft zurück, wie er etwa zum Abspeichern in den Präferenzen benutzt
     * werden kann.
     *
     * @return ein Kurzname der Eigenschaft
     */
    String getKey();

    /**
     * Gibt ein {@link PropertyPanel} für die Eigenschaft zurück.
     *
     * @param value wird selektiert, falls möglich
     *
     * @return das PropertyPanel
     */
    PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable);

}
