/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

/**
 * {@code PropertyPanel} ist ein Interface für ein Panel zu einer Property, deren Wert man erfragen kann. Ein solches Panel besteht aus einem Label
 * und einer Auswahlkomponente in Form einer JComboBox oder einem JSpinner.
 *
 * @author Kappich Systemberatung
 */
public interface PropertyPanel {

    /**
     * Der Auswahlkomponente wird ein {@code PropertyPanelListener} hinzugefügt.
     *
     * @param listener ein {@code PropertyPanelListener}
     */
    void addListener(PropertyPanelListener listener);

    /**
     * Gibt den aktuellen Wert der Eigenschaft im Panel zurück.
     *
     * @return den Wert der Eigenschaft im Panel
     */
    Object getPropertyValue();

    /**
     * Enabled oder disabled die Auswahlkomponente.
     *
     * @param enabled
     */
    void setSelectionEnabled(final boolean enabled);
}
