/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.properties;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.utils.SpringUtilities;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeListener;

/**
 * Diese Klasse verkapselt die Eigenschaft Transparenz.
 *
 * @author Kappich Systemberatung
 */
public final class TransparencyProperty extends AbstractProperty {
    private static final TransparencyProperty _instance = new TransparencyProperty();
    private static final String KEY = "transparency";
    private static final Double DEFAULT_TRANSPARENCY = 0.;

    private TransparencyProperty() {
        super("Transparenz");
    }

    public static Property getInstance() {
        return _instance;
    }

    @Override
    public Object getDefaultValue() {
        return DEFAULT_TRANSPARENCY;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public PropertyPanel getPropertyPanel(@Nullable Object value, boolean changeable) {
        if (value != null) {
            return new TransparencyPanel((Double) value, changeable);
        } else {
            return new TransparencyPanel(DEFAULT_TRANSPARENCY, changeable);
        }
    }

    private static class TransparencyPanel extends JPanel implements PropertyPanel {
        private final JSpinner _transparencySpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));

        public TransparencyPanel(Double diameter, boolean changeable) {
            JLabel label = new JLabel("Tranzparenz: ");
            _transparencySpinner.setMaximumSize(new Dimension(200, 20));
            _transparencySpinner.setValue(diameter);
            _transparencySpinner.setEnabled(changeable);
            setLayout(new SpringLayout());
            add(label);
            add(_transparencySpinner);
            SpringUtilities.makeCompactGrid(this, 2, 5, 5);
        }

        @Override
        public void addListener(final PropertyPanelListener listener) {
            ChangeListener changeListener = e -> listener.stateChanged();
            _transparencySpinner.addChangeListener(changeListener);
        }

        @Override
        public Object getPropertyValue() {
            return _transparencySpinner.getValue();
        }

        @Override
        public void setSelectionEnabled(final boolean enabled) {
            _transparencySpinner.setEnabled(enabled);
        }
    }
}
