/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.rnPlugin;

import de.kappich.pat.gnd.displayObjectToolkit.DOTManager;
import de.kappich.pat.gnd.displayObjectToolkit.DynamicDOTItem;
import de.kappich.pat.gnd.gnd.LegendTreeNodes;
import de.kappich.pat.gnd.pluginInterfaces.DefaultDisplayObjectType;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectTypePlugin;
import de.kappich.pat.gnd.properties.Property;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * {@code DOTRn} ist die Implementation von {@link DisplayObjectType} im RN-Plugin. {@code DOTKm} erweitert {@code DefaultDisplayObjectType}.
 *
 * @author Kappich Systemberatung
 */
public class DOTRn extends DefaultDisplayObjectType {

    private static final String INFO = "INFO";
    private static final Icon ICON = new ImageIcon(DOTRn.class.getResource("/de/kappich/pat/gnd/res/Autobahn24-1.png"));

    private final RnDisplayObject.Category _category;

    /**
     * Ein Defaultkonstruktor für {@code DOTRn}. Eine spezifische Verwendung ohne Namen und Info ist nicht sinnvoll.
     */
    public DOTRn() {
        super(true);
        _name = "";
        _info = "";
        _category = RnDisplayObject.Category.NULL;
        DOTManager.getInstance().addDOTChangeListener(this);
    }

    /**
     * Konstruktor mit vorgegebenen Namen, Info und Kategorie. Die Kategorie wird im {@link DOTRnPainter} ausgewertet: die Kategorie eines {@code
     * DOTRn} ist dort die untere Schranke für die Kategorien der {@link RnDisplayObject RnDisplayObjects}, die gezeichnet werden.
     *
     * @param name     der unter allen DisplayObjectTypes eindeutige Name
     * @param info     eine Kurzinformation, die z.B. als Tooltipp verwendet wird
     * @param category die Kategorie des Objekts
     */
    public DOTRn(String name, String info, RnDisplayObject.Category category) {
        super(true);
        _name = name;
        _info = info;
        _category = category;
        DOTManager.getInstance().addDOTChangeListener(this);
    }

    /**
     * Der Getter für die Kategorie.
     *
     * @return die Kategorie
     */
    public RnDisplayObject.Category getCategory() {
        return _category;
    }

    @Override
    public DisplayObjectTypePlugin getDisplayObjectTypePlugin() {
        return new DOTRnPlugin();
    }

    @Override
    public DisplayObjectType getCopy(String name) {
        String s = name;
        if (null == s) {
            s = getName();
        }
        return super.getCopy(s);
    }

    @Override
    public String toString() {
        return "DOTRn{" + '}';
    }

    @Override
    public void initializeFromPreferences(Preferences prefs) {
        super.initializeFromPreferences(prefs);
    }

    @Override
    public void putPreferences(Preferences prefs) {
        deletePreferences(prefs);
        Preferences classPrefs = prefs.node(getClass().getSimpleName());
        Preferences objectPrefs = classPrefs.node(getName());
        Preferences infoPrefs = objectPrefs.node("info");
        infoPrefs.put(INFO, getInfo());

        Preferences staticPrefs = objectPrefs.node("static");
        for (final Map.Entry<Property, Boolean> entry : _isStaticMap.entrySet()) {
            if (entry.getValue()) {
                // Eine statische Property wird als dynamische ohne Anmeldungsdaten weggeschrieben.
                Preferences propertyPrefs = staticPrefs.node(entry.getKey().getKey());
                final DynamicDOTItem dynamicDOTItem = new DynamicDOTItem("", "", "", "", _staticPropertyValues.get(entry.getKey()));
                dynamicDOTItem.putPreferences(propertyPrefs);
            }
        }
    }

    @Override
    public LegendTreeNodes getLegendTreeNodes() {
        LegendTreeNodes legendTreeNodes = new LegendTreeNodes();
        LegendTreeNodes.IconTreeNode iconTreeNode = new LegendTreeNodes.IconTreeNode("", "Autobahnschilder", ICON, null);
        legendTreeNodes.add(iconTreeNode, 0);
        return legendTreeNodes;
    }
}
