/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.utils;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import java.awt.geom.Point2D;

/**
 * Diese Klasse kapselt ein Paar bestehend aus einem Punkt und einem Winkel.
 *
 * @author Kappich Systemberatung
 */
public class PointWithAngle {

    private final Point2D _point;
    private final Double _angle;

    /**
     * Konstruiert ein Objekt mit den übergebenen Werten.
     */
    public PointWithAngle(Point2D point, @Nullable Double angle) {
        super();
        _point = point;
        _angle = angle;
    }

    /**
     * Gibt den Punkt zurück.
     */
    public Point2D getPoint() {
        return _point;
    }

    /**
     * Gibt den Winkel zurück.
     */
    @Nullable
    public Double getAngle() {
        return _angle;
    }

    @Override
    public String toString() {
        return _point.toString() + "[Angle:" + _angle + "]";
    }
}
