/*
 * Copyright 2012-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.kappich.
 *
 * de.bsvrz.sys.funclib.kappich is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.kappich is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.kappich; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.kappich.annotations;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.LOCAL_VARIABLE;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PARAMETER;


import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Zeigt an, dass eine Funktion, Variable oder Feld den Wert {@code null} <strong>nicht</strong> enthalten bzw. zurückgeben darf. Lässt sich in den
 * IntelliJ-Idea-Inspections unter @Nullable/@NotNull einrichten um entsprechende Warnungen über mögliche NullPointerExceptions zu erhalten. Dient
 * außerdem der Code-Dokumentation.
 * <p>
 * Hinweis: Dies ist typischerweise der default, aber die Annotation kann verwendet werden um Unklarheiten zu beseitigen oder den Inspections in der
 * IDE auf die Sprünge zu helfen.
 *
 * @author Kappich Systemberatung
*/
@Retention(RetentionPolicy.CLASS)
@Documented
@Target(value = {FIELD, LOCAL_VARIABLE, PARAMETER, METHOD})
public @interface NotNull {

}
