/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.kappich.
 *
 * de.bsvrz.sys.funclib.kappich is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.kappich is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.kappich; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.kappich.collections;

import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Function;

/**
 * Optimierung Sortierung nach einem Collator
 *
 * @author Kappich Systemberatung
 */
public final class CollatorComparator<T> implements Comparator<T> {
    private final Function<T, String> _toStringFunction;
    private Collator _collator;

    public CollatorComparator(final Function<T, String> toStringFunction, final Locale locale) {
        _toStringFunction = toStringFunction;
        _collator = Collator.getInstance(locale);
    }

    public SortKey getSortKey(T o) {
        return new SortKey(_collator.getCollationKey(_toStringFunction.apply(o)), o);
    }

    @Override
    public int compare(final T o1, final T o2) {
        return _collator.compare(_toStringFunction.apply(o1), _toStringFunction.apply(o2));
    }

    public final class SortKey implements Comparable<SortKey> {
        private final CollationKey _collationKey;
        private final T _object;

        SortKey(final CollationKey collationKey, final T object) {

            _collationKey = collationKey;
            _object = object;
        }

        public CollationKey getCollationKey() {
            return _collationKey;
        }

        public T getObject() {
            return _object;
        }

        @Override
        public int compareTo(final SortKey o) {
            return _collationKey.compareTo(o._collationKey);
        }
    }
}
