/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.kappich.
 *
 * de.bsvrz.sys.funclib.kappich is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.kappich is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.kappich; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.kappich.collections;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Klasse, die zu einem Key mehrere Values zuordnen kann.
 *
 * @author Kappich Systemberatung
 * @deprecated Entspricht einer {@link com.google.common.collect.Multimap} und sollte durch diese ersetzt werden.
 */
@Deprecated
public interface MultiValueMap<K, V> {
    /**
     * Gibt die Anzahl der gespeicherten Werte (Values) zurück
     *
     * @return die Anzahl der gespeicherten Werte (Values)
     */
    int size();

    /**
     * Gibt true zurück, wenn keine Werte gespeichert sind
     *
     * @return true, wenn keine Werte gespeichert sind
     */
    boolean isEmpty();

    /**
     * Gibt {@code true} zurück, wenn ein Objekt vom Typ Map.Entry enthalten ist, also hier dem Entry-Key mindestens das Entry-Value zugeordnet ist.
     *
     * @param o zu testendes Objekt
     *
     * @return {@code true}, wenn ein Objekt vom Typ Map.Entry enthalten ist, sonst {@code false}
     */
    boolean contains(Object o);

    /**
     * Fügt einen Entry hinzu. Shortcut für add(entry.getKey(), entry.getValue()).
     *
     * @param entry Entry
     *
     * @return siehe {@link #add(Object, Object)}
     */
    boolean add(Map.Entry<K, V> entry);

    /**
     * Gibt true zurück, wenn die Klasse zu diesem Key mindestens einen Wert enthält
     *
     * @param key Key
     *
     * @return true wenn die Klasse zu diesem key mindestens einen Wert enthält
     */
    boolean containsKey(Object key);

    /**
     * Gibt true zurück, wenn dieser Wert mindestens einmal einem Key zugeordnet wurde
     *
     * @param value Wert
     *
     * @return true, wenn dieser Wert mindestens einmal einem Key zugeordnet wurde
     */
    boolean containsValue(Object value);

    /**
     * Gibt die Collection mit Objekten zurück, die hinter diesem Key liegen
     *
     * @param key Key
     *
     * @return Liste mit Objekten
     */
    Collection<V> get(K key);

    /**
     * Fügt einem Key einen Wert hinzu
     *
     * @param key   Key
     * @param value Wert
     *
     * @return true wenn die Collection verändert wurde
     */
    boolean add(K key, V value);

    /**
     * Fügt einem Key mehrere Werte hinzu
     *
     * @param key   Key
     * @param value Werte
     *
     * @return true wenn die Collection verändert wurde
     */
    boolean addAll(K key, Collection<? extends V> value);

    /**
     * Löscht einen Eintrag
     *
     * @param key   Key
     * @param value Wert
     *
     * @return true falls ein Wert entfernt wurde
     */
    boolean remove(Object key, Object value);

    /**
     * Löscht alle Einträge eines Keys
     *
     * @param key Key
     *
     * @return true falls ein Wert entfernt wurde
     */
    Collection<V> removeAll(Object key);

    void clear();

    /**
     * Gibt ein Set über die Keys zurück
     *
     * @return ein Set über die Keys
     */
    Set<K> keySet();

    /**
     * Gibt eine Liste über alle values zurück. Änderungen an der zurückgegeben Collection haben keine Auswirkungen auf die HashBagMap. Einträge, die
     * mehreren Keys zugeordnet sind werden mehrfach zurückgegeben. Die Reihenfolge der Listeneinträge ist nicht definiert.
     *
     * @return eine Liste über alle values
     */
    List<V> values();

    /**
     * Gibt ein Set über alle values zurück. Änderungen an der zurückgegeben Collection haben keine Auswirkungen auf die HashBagMap.
     *
     * @return eine Liste über alle values
     */
    Set<V> valueSet();

    /**
     * Gibt ein Set über alle Einträge zurück
     *
     * @return ein Set über alle Einträge
     */
    Set<Map.Entry<K, Collection<V>>> entrySet();

    /**
     * Findet Keys, die mindestens den angegeben Wert als Value haben
     *
     * @param value Wert
     *
     * @return Collection mit Keys die den angegebenen Werten zugeordnet sind
     */
    Set<K> findKey(V value);

    /**
     * Findet Keys, die mindestens einen der angegebenen Werte als (nicht unbedingt einzigen) Value haben
     *
     * @param values Werte
     *
     * @return Collection mit Keys die den angegebenen Werten zugeordnet sind
     */
    Set<K> findKeys(Collection<? extends V> values);

    /**
     * Fügt mehrere Werte hinzu
     *
     * @param map Map mit bestehenden Werten
     */
    void addAll(Map<? extends K, Collection<? extends V>> map);

    /**
     * Fügt eine bestehende {@code MultiValueMap<K, V>} hinzu
     *
     * @param multiValueMap Map mit bestehenden Werten
     */
    void addAll(MultiValueMap<? extends K, ? extends V> multiValueMap);

    /**
     * Gibt {@code true} zurück, wenn ein Set für die Werte verwendet wird
     *
     * @return {@code true}, wenn ein Set für die Werte verwendet wird, sonst {@code false}
     */
    boolean isUsingUniqueValues();
}
