/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.kappich.
 *
 * de.bsvrz.sys.funclib.kappich is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.kappich is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.kappich; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.kappich.properties;

import com.google.common.collect.Multimap;
import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.bsvrz.sys.funclib.kappich.collections.MultiValueMap;
import de.bsvrz.sys.funclib.kappich.propertytree.PropertyTreeModel;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/**
 * @author Kappich Systemberatung
 */
public class DefaultFormatter implements PropertyFormatter {
    @Override
    public String format(@Nullable final PropertyName propertyName, final Object o) {

        if (o == null) {
            return "<Nicht vorhanden>";
        }
        if (o.equals(PropertyTreeModel.MULTIPLE)) {
            return "<Unterschiedlich>";
        }
        if (o.equals(true)) {
            return "Ja";
        }
        if (o.equals(false)) {
            return "Nein";
        }
        String s;
	    if (o instanceof Iterable<?> iterable) {
		    if (iterable instanceof Collection<?> collection) {
                int size = collection.size();
                if (size == 1) {
                    s = ObjectProperties.objectToString(propertyName, collection.iterator().next());
                } else {
                    s = size + " Elemente";
                }
            } else {
                int size = 0;
                for (final Object x : iterable) {
                    size++;
                    if (size == 11) {
                        break;
                    }
                }
                if (size == 11) {
                    s = "über 10 Elemente";
                } else if (size == 1) {
                    s = "1 Element";
                } else {
                    s = size + " Elemente";
                }
            }
	    } else if (o instanceof Map<?, ?> map) {
            int size = map.size();
            if (size == 1) {
                Map.Entry<?, ?> next = map.entrySet().iterator().next();
                s = ObjectProperties.objectToString(propertyName, next.getKey()) + ": " +
                    ObjectProperties.objectToString(propertyName, next.getValue());
            } else {
                s = size + " Elemente";
            }
	    } else if (o instanceof Multimap<?, ?> map) {
            int size = map.size();
            if (size == 1) {
                Map.Entry<?, ?> next = map.asMap().entrySet().iterator().next();
                s = ObjectProperties.objectToString(propertyName, next.getKey()) + ": " +
                    ObjectProperties.objectToString(propertyName, next.getValue());
            } else {
                s = size + " Elemente";
            }
	    } else if (o instanceof MultiValueMap<?, ?> map) {
            int size = map.size();
            if (size == 1) {
                Map.Entry<?, ?> next = map.entrySet().iterator().next();
                s = ObjectProperties.objectToString(propertyName, next.getKey()) + ": " +
                    ObjectProperties.objectToString(propertyName, next.getValue());
            } else {
                s = size + " Elemente";
            }
        } else if (o.getClass().isArray()) {
            int size = Array.getLength(o);
            if (size == 1) {
                s = ObjectProperties.objectToString(propertyName, Array.get(o, 0));
            } else {
                s = size + " Elemente";
            }
        } else if (o instanceof Number && propertyName != null && !propertyName.unit().isEmpty()) {
            DisplayUnit displayUnit = new DisplayUnit(propertyName.unit(), propertyName.power(), propertyName.factor());
            s = displayUnit.format(((Number) o).doubleValue());
        } else {
            s = String.valueOf(o);
        }
        return s;
    }
}
