/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.kappich.
 *
 * de.bsvrz.sys.funclib.kappich is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.kappich is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.kappich; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.kappich.properties;

import static java.lang.annotation.ElementType.TYPE;


import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Definiert zusätzliche Klassen, die zusätzliche Eigenschaften über diese Klasse bzw. Objekte dieser Klasse abrufen kann. Nützlich wenn das Objekt
 * selber keine Methoden bietet oder bieten soll, die diese Eigenschaften bereitstellen, oder wenn die Eigenschaften in unterschiedliche Kategorien
 * abgelegt werden sollen.
 * <p>
 * Referenzierte Klassen benötigen einen Konstruktor mit einem Parameter vom Typ der hier annotierten Klasse und sollten entsprechende {@link
 * PropertyClass} und {@link PropertyName}-Annotationen besitzen.
 *
 * @author Kappich Systemberatung
* @see PropertyClass
 * @see ObjectProperties
 */
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Target(value = {TYPE})
public @interface PropertyHandler {
    Class<?>[] value() default {};

    String[] className() default {};
}
