/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.sys.funclib.kappich.
 *
 * de.bsvrz.sys.funclib.kappich is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.sys.funclib.kappich is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with de.bsvrz.sys.funclib.kappich; If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.sys.funclib.kappich.selectionlist;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;

/**
 * Textfeld, dass im unfocussierten Zustand wie ein Label aussieht
 *
 * @author Kappich Systemberatung
 * @version $Revision: 000 $
 */
public class FilterTextField extends JTextField {

    private final String _placeholder;

    public FilterTextField(final String placeholder) {
        _placeholder = placeholder;
        Dimension maxSize = getPreferredSize();
        maxSize.width = Integer.MAX_VALUE;
        setMaximumSize(maxSize);
        setOpaque(false);
        setLayout(new BorderLayout());
        add(new JLabel(placeholder));
    }

    @Override
    protected void paintBorder(final Graphics g) {
        if (_placeholder.isEmpty() || !getText().isEmpty() || hasFocus()) {
            super.paintBorder(g);
        }
    }

    @Override
    public void paint(final Graphics g) {
        if (_placeholder.isEmpty() || !getText().isEmpty() || hasFocus()) {
            super.paint(g);
            return;
        }
        super.paintChildren(g);
    }

    @Override
    protected void paintChildren(final Graphics g) {
    }

    @Override
    protected void processFocusEvent(final FocusEvent e) {
        super.processFocusEvent(e);
        repaint();
    }
}
