/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.sys.funclib.srp6;


import java.math.BigInteger;


/**
 * The SRP-6a client credentials sent to the server at 
 * {@link SRP6ClientSession.State#STEP_2 step two}. These consist of the public 
 * client value 'A' and the client evidence message 'M1'.
 *
 * @author Vladimir Dzhuvinov
 */
public final class SRP6ClientCredentials {


	/**
	 * The public client value 'A'.
	 */
	public final BigInteger A;
	
	
	/**
	 * The client evidence message 'M1'.
	 */
	public final BigInteger M1;
	
	
	/**
	 * Creates a new SRP-6a client credentials.
	 *
	 * @param A  The public client value 'A'. Must not be {@code null}.
	 * @param M1 The client evidence message 'M1'. Must not be {@code null}.
	 */
	public SRP6ClientCredentials(final BigInteger A, final BigInteger M1) {
	
		if (A == null)
			throw new IllegalArgumentException("The public client value 'A' must not be null");
			
		this.A = A;
		
		
		if (M1 == null)
			throw new IllegalArgumentException("The client evidence message 'M1' must not be null");
			
		this.M1 = M1;
	}
}
