/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.sys.funclib.srp6;


/**
 * Secure Remote Password (SRP-6a) exception.
 *
 * @author Vladimir Dzhuvinov
 */
public class SRP6Exception extends Exception {


	private static final long serialVersionUID = 4640494990301260666L;


	/**
	 * SRP-6a exception causes.
	 */
	public static enum CauseType {
	
	
		/**
		 * Invalid public client or server value ('A' or 'B').
		 */
		BAD_PUBLIC_VALUE,
		
		
		/**
		 * Invalid credentials (password).
		 */
		BAD_CREDENTIALS,
		
		
		/**
		 * SRP-6a authentication session timeout.
		 */
		TIMEOUT
	}
	
	
	/**
	 * The cause type.
	 */
	private CauseType cause;


	/**
	 * Creates a new Secure Remote Password (SRP-6a) exception with the 
	 * specified message.
	 *
	 * @param message The exception message.
	 * @param cause   The exception cause type. Must not be {@code null}.
	 */
	public SRP6Exception(final String message, final CauseType cause) {
	
		super(message);
		
		if (cause == null)
			throw new IllegalArgumentException("The cause type must not be null");
		
		this.cause = cause;
	}
	
	
	/**
	 * Gets the cause type for this exception.
	 *
	 * @return The exception cause type.
	 */
	public CauseType getCauseType() {
	
		return cause;
	}
}
