/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.sys.funclib.srp6;


import java.math.BigInteger;


/**
 * Immutable snapshot of SRP-6a server session variables to be used in a
 * {@link ServerEvidenceRoutine}.
 *
 * @author Vladimir Dzhuvinov
 */
public class SRP6ServerEvidenceContext {


	/**
	 * The public client value 'A'.
	 */
	public final BigInteger A;
	
	
	/**
	 * The client evidence message 'M1'.
	 */
	public final BigInteger M1;
	
	
	/**
	 * The session key 'S'.
	 */
	public final BigInteger S;
	
	
	/**
	 * Creates a new immutable snapshot of SRP-6a server session variables.
	 *
	 * @param A  The public client value 'A'.
	 * @param M1 The client evidence message 'M1'.
	 * @param S  The session key 'S'.
	 */
	public SRP6ServerEvidenceContext(final BigInteger A,
					 final BigInteger M1,
					 final BigInteger S) {
					    
		this.A = A;
		this.M1 = M1;
		this.S = S;
	}

}
