/*
 * Copyright 2011-2021 Connect2id Ltd. and others
 * Copyright 2021 by DTV-Verkehrsconsult, Aachen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.sys.funclib.srp6;


import java.math.BigInteger;


/**
 * Custom routine interface for computing the server evidence message 'M2'.
 *
 * <p>If you don't want to employ the {@link SRP6Routines#computeServerEvidence 
 * default routine} for computing the server evidence message you can use this 
 * interface to define your own. Remember to make sure that exactly the same 
 * routine is used by both client and server session, else authentication will 
 * fail.
 *
 * @author Vladimir Dzhuvinov
 */
public interface ServerEvidenceRoutine {


	/**
	 * Computes a server evidence message 'M2'.
	 *
	 * @param cryptoParams The crypto parameters for the SRP-6a protocol.
	 * @param ctx          Snapshot of the SRP-6a server session variables 
	 *                     which may be used in the computation of the 
	 *                     server evidence message.
	 *
	 * @return The resulting server evidence message 'M1'.
	 */
	public BigInteger computeServerEvidence(final SRP6CryptoParams cryptoParams,
	                                        final SRP6ServerEvidenceContext ctx);
}
