/*
 * Copyright 2004 by Kappich+Kniß Systemberatung, Aachen
 * Copyright 2007-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.bsvrz.dav.dav.
 *
 * de.bsvrz.dav.dav is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.dav.dav is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.dav.dav.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.bsvrz.dav.dav.communication.davProtocol;

import de.bsvrz.dav.daf.communication.lowLevel.telegrams.DataTelegram;
import de.bsvrz.dav.dav.main.RoutingConnectionInterface;
import de.bsvrz.dav.dav.main.ServerHighLevelCommunication;
import de.bsvrz.dav.dav.subscriptions.TransmitterCommunicationInterface;

/**
 * Dieses Interface erweitert die Interfaces {@link de.bsvrz.dav.dav.main.ServerHighLevelCommunication} und {@link
 * de.bsvrz.dav.dav.main.RoutingConnectionInterface} um die Funktionalität zum Senden von Telegrammen von einem Datenverteiler zum Nächsten
 * (DaV-DaV).
 *
 * @author Kappich Systemberatung
 */
public interface T_T_HighLevelCommunicationInterface
    extends ServerHighLevelCommunication, RoutingConnectionInterface, TransmitterCommunicationInterface {

    /**
     * Diese Methode wird von der Verbindungsverwaltung, der Zuliefererverwaltung und der Anmeldungsverwaltung aufgerufen. Sie sendet über die
     * Telegrammverwaltung ein Telegramm zu einem anderen Datenverteiler.
     *
     * @param telegram Grundtyp eines Telegramms
     */
    public void sendTelegram(DataTelegram telegram);

    /**
     * Mehrere Telegramme können en bloc versandt werden.
     *
     * @param telegrams Feld von zu sendenden Telegrammen
     *
     * @see #sendTelegram(de.bsvrz.dav.daf.communication.lowLevel.telegrams.DataTelegram)
     */
    public void sendTelegrams(DataTelegram[] telegrams);
}
