/*
 * Copyright 2017-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.choose;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.kappich.selectionlist.SelectionList;
import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.displayObjectToolkit.OnlineDisplayObject;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

/**
 * ACHTUNG: dies ist ein Analogon zu SystemObjectSelectionList.
 *
 * @author Kappich Systemberatung
 * @version $Revision:$
 */
class DisplayObjectSelectionList extends SelectionList<DisplayObject> {

    DisplayObjectSelectionList(final String header, String headerPlural, Comparator<DisplayObject> comparator) {
        super(header, headerPlural, (pattern, id, object) -> {
	        if (object instanceof OnlineDisplayObject displayObject) {
                SystemObject systemObject = displayObject.getSystemObject();
                return pattern == null || pattern.matcher(systemObject.getPid()).find() || pattern.matcher(systemObject.getName()).find() ||
                       id == systemObject.getId();
            } else //noinspection SimplifiableIfStatement
                if (object != null) {
                    return pattern == null || pattern.matcher(object.getName()).find();
                } else {
                    return false;
                }
        }, FilterStyle.VisibleFilter, comparator);
        addTheMouseListener();
    }

    private void addTheMouseListener() {
        _jList.addMouseListener(new MyMouseListener());
    }

    private static class MyMouseListener extends MouseAdapter {
        private final JPopupMenu _popup = new JPopupMenu();
        private final JMenuItem _copyIds = new JMenuItem("IDs kopieren");
        private final JMenuItem _copyPids = new JMenuItem("Pids kopieren");
        private final JMenuItem _copyNames = new JMenuItem("Namen kopieren");

        MyMouseListener() {
            _popup.add(_copyIds);
            _popup.add(_copyPids);
            _popup.add(_copyNames);
        }

        List<SystemObject> getSelectedSystemObjects(MouseEvent e) {
            List<SystemObject> list = new ArrayList<>();

            final Object obj = e.getSource();
            if (obj instanceof JList) {
                JList<DisplayObject> objectList = (JList<DisplayObject>) obj;
                int[] selectedIndices = objectList.getSelectedIndices();
                for (final int selectedIndice : selectedIndices) {
                    DisplayObject displayObject = objectList.getModel().getElementAt(selectedIndice);
	                if (displayObject instanceof OnlineDisplayObject onlineDisplayObject) {
                        SystemObject systemObject = onlineDisplayObject.getSystemObject();
                        if (null != systemObject) {
                            list.add(systemObject);
                        }
                    }
                }
            }
            return list;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            List<SystemObject> systemObjects = getSelectedSystemObjects(e);
            if (systemObjects.isEmpty()) {
                _copyIds.setEnabled(false);
                _copyPids.setEnabled(false);
                _copyNames.setEnabled(false);
            } else {
                _copyIds.setEnabled(true);
                _copyPids.setEnabled(true);
                _copyNames.setEnabled(true);
                if (systemObjects.size() == 1) {
                    _copyIds.setText("ID kopieren");
                    _copyPids.setText("Pid kopieren");
                    _copyNames.setText("Name kopieren");
                } else {
                    _copyIds.setText("IDs kopieren");
                    _copyPids.setText("Pids kopieren");
                    _copyNames.setText("Namen kopieren");
                }
                setActionListenerIds(systemObjects);
                setActionListenerPids(systemObjects);
                setActionListenerNames(systemObjects);
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                _popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private void setActionListenerIds(List<SystemObject> systemObjects) {
            ActionListener[] als = _copyIds.getActionListeners();
            for (ActionListener al : als) {
                _copyIds.removeActionListener(al);
            }
            _copyIds.addActionListener(e -> {
                StringBuilder sb = new StringBuilder();
                boolean firstOne = true;
                for (SystemObject systemObject : systemObjects) {
                    if (firstOne) {
                        firstOne = false;
                    } else {
                        sb.append(System.lineSeparator());
                    }
                    sb.append(systemObject.getId());
                }
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents(new StringSelection(sb.toString()), null);
            });
        }

        private void setActionListenerPids(List<SystemObject> systemObjects) {
            ActionListener[] als = _copyPids.getActionListeners();
            for (ActionListener al : als) {
                _copyPids.removeActionListener(al);
            }
            _copyPids.addActionListener(e -> {
                StringBuilder sb = new StringBuilder();
                boolean firstOne = true;
                for (SystemObject systemObject : systemObjects) {
                    if (firstOne) {
                        firstOne = false;
                    } else {
                        sb.append(System.lineSeparator());
                    }
                    sb.append(systemObject.getPid());
                }
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents(new StringSelection(sb.toString()), null);
            });
        }

        private void setActionListenerNames(List<SystemObject> systemObjects) {
            ActionListener[] als = _copyNames.getActionListeners();
            for (ActionListener al : als) {
                _copyNames.removeActionListener(al);
            }
            _copyNames.addActionListener(e -> {
                StringBuilder sb = new StringBuilder();
                boolean firstOne = true;
                for (SystemObject systemObject : systemObjects) {
                    if (firstOne) {
                        firstOne = false;
                    } else {
                        sb.append(System.lineSeparator());
                    }
                    sb.append(systemObject.getName());
                }
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                cb.setContents(new StringSelection(sb.toString()), null);
            });
        }
    }

}
