/*
 * Copyright 2009-2020 by Kappich Systemberatung, Aachen
 *
 * This file is part of de.kappich.pat.gnd.
 *
 * de.kappich.pat.gnd is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.kappich.pat.gnd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.kappich.pat.gnd.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * Kappich Systemberatung
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 240
 * mail: <info@kappich.de>
 */

package de.kappich.pat.gnd.complexPlugin;

import de.bsvrz.sys.funclib.kappich.annotations.Nullable;
import de.kappich.pat.gnd.colorManagement.ColorManager;
import de.kappich.pat.gnd.displayObjectToolkit.DisplayObject;
import de.kappich.pat.gnd.displayObjectToolkit.DynamicDOTItem;
import de.kappich.pat.gnd.displayObjectToolkit.PrimitiveFormPropertyPair;
import de.kappich.pat.gnd.gnd.MapPane;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectPainter;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType;
import de.kappich.pat.gnd.pluginInterfaces.DisplayObjectType.DisplayObjectTypeItem;
import de.kappich.pat.gnd.properties.ColorProperty;
import de.kappich.pat.gnd.utils.PointWithAngle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;

/**
 * Der Painter des Plugins für komplexe Objekte.
 *
 * @author Kappich Systemberatung
 */

@SuppressWarnings("serial")
public class DOTComplexPainter extends JPanel implements DisplayObjectPainter {

    @Override
    public void paintDisplayObject(MapPane mapPane, Graphics2D g2D, DisplayObject displayObject, boolean selected) {
        DisplayObjectType dot = displayObject.getDOTCollection().getDisplayObjectType(mapPane.getMapScale().intValue());
	    if (!(dot instanceof DOTComplex dotComplex)) {
            return;
        }
        final Color color;
        if (dotComplex.isPropertyStatic(null, ColorProperty.getInstance())) {
            color = ColorManager.getInstance().getColor((String) dotComplex.getValueOfStaticProperty(null, ColorProperty.getInstance()));
        } else {
            final PrimitiveFormPropertyPair primitiveFormPropertyPair = new PrimitiveFormPropertyPair(null, ColorProperty.getInstance());
            final DisplayObjectTypeItem displayObjectTypeItem = displayObject.getDisplayObjectTypeItem(primitiveFormPropertyPair);
            if (displayObjectTypeItem == null) {
                return;
            }
            final Object propertyValue = displayObjectTypeItem.getPropertyValue();
            if (propertyValue != null) {
                color = ColorManager.getInstance().getColor((String) propertyValue);
            } else if (Objects.equals(displayObjectTypeItem, DynamicDOTItem.NO_DATA_ITEM)) {
                color = ColorManager.getInstance().getColor("keine");
            } else if (Objects.equals(displayObjectTypeItem, DynamicDOTItem.NO_SOURCE_ITEM)) {
                color = ColorManager.getInstance().getColor("keine");
            } else {
                color = ColorManager.getInstance().getColor("keine");
            }
            // Die letzten drei Fälle werden noch gleichbehandelt, aber bei einer kommenden
            // Erweiterung kann hier unterschieden werden.
        }

        if (!selected) {
            g2D.setColor(color);
            g2D.setStroke(new BasicStroke(1.f));
        } else {
            if (null != color) {
                g2D.setColor(color.darker());
            }
            g2D.setStroke(new BasicStroke(3.f));
        }
        for (Object o : displayObject.getCoordinates(0)) {
	        if (o instanceof PointWithAngle pointWithAngle) {
                final Point2D point = pointWithAngle.getPoint();
                final Double pointX = point.getX();
                final Double pointY = point.getY();
                g2D.drawOval(pointX.intValue() - 1, pointY.intValue() - 1, 2, 2);
	        } else if (o instanceof Path2D.Double polyline) {
                g2D.draw(polyline);
	        } else if (o instanceof Polygon polygon) {
                g2D.fill(polygon);
            }
        }
        displayObject.setDefaultType(0);
    }

    @Nullable
    @Override
    public Rectangle getBoundingRectangle(DisplayObject displayObject, int type) {
        Rectangle rect = null;
        for (Object o : displayObject.getCoordinates(type)) {
	        if (o instanceof PointWithAngle pointWithAngle) {
                final Point2D point = pointWithAngle.getPoint();
                final Double x = point.getX();
                final Double y = point.getY();
                Point p = new Point(x.intValue(), y.intValue());
                if (rect == null) {
                    rect = new Rectangle(p);
                } else {
                    rect.add(p);
                }
	        } else if (o instanceof Path2D.Double polyline) {
                if (rect == null) {
                    rect = polyline.getBounds();
                } else {
                    rect.add(polyline.getBounds());
                }
	        } else if (o instanceof Polygon polygon) {
                if (rect == null) {
                    rect = polygon.getBounds();
                } else {
                    rect.add(polygon.getBounds());
                }
            }
        }
        return rect;
    }

    @Override
    public List<Object> getCoordinates(List<Object> coordinates, int type) {
        return coordinates;
    }
}
